/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.utils;

import eu.europeana.corelib.edm.exceptions.SolrQueryException;
import eu.europeana.corelib.web.exception.ProblemType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class BoostParamUtils {
    private static String curlyBracesPattern = "[{+|}+]";

    private BoostParamUtils() {
    }

    public static boolean validateBoostParam(String boostParam) throws SolrQueryException {
        if (StringUtils.isNotEmpty((CharSequence)boostParam)) {
            String normalised = StringUtils.normalizeSpace((String)boostParam);
            if (!StringUtils.startsWith((CharSequence)normalised, (CharSequence)"{!edismax") || !StringUtils.endsWith((CharSequence)normalised, (CharSequence)"}")) {
                throw new SolrQueryException(ProblemType.BOOST_PARAM_INVALID_FORMAT);
            }
            Pattern pattern = Pattern.compile(curlyBracesPattern);
            Matcher matcher = pattern.matcher(BoostParamUtils.removeStartAndEndBraces((String)boostParam));
            if (matcher.find()) {
                throw new SolrQueryException(ProblemType.BOOST_PARAM_INVALID_VALUE);
            }
        }
        return true;
    }

    private static String removeStartAndEndBraces(String boostParam) {
        String cleaned = StringUtils.removeStart((String)StringUtils.normalizeSpace((String)boostParam), (String)"{");
        return StringUtils.removeEnd((String)cleaned, (String)"}");
    }
}

