/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.service.translate;

import com.auth0.jwt.JWT;
import eu.europeana.api2.v2.exceptions.TranslationException;
import eu.europeana.api2.v2.service.translate.TranslationService;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.stereotype.Service;

@Service
@PropertySources(value={@PropertySource(value={"classpath:europeana.properties"}), @PropertySource(value={"classpath:europeana.user.properties"}, ignoreResourceNotFound=true)})
public class PangeanicTranslationService
implements TranslationService {
    private static final Logger LOG = LogManager.getLogger(PangeanicTranslationService.class);
    private static final String APPLICATION_JSON = "application/json";
    private static final int MAX_CONNECTIONS = 100;
    private static final int MAX_CONNECTIONS_PER_ROUTE = 100;
    private static final int TOKEN_MIN_AGE = 30000;
    @Value(value="${translation.pangeanic.endpoint.translate:}")
    private String translateEndpoint;
    @Value(value="${translation.pangeanic.endpoint.auth:}")
    private String tokenEndpoint;
    @Value(value="${translation.pangeanic.username:}")
    private String userName;
    @Value(value="${translation.pangeanic.passwd:}")
    private String password;
    private String token;
    private long tokenExpiration;
    private CloseableHttpClient translateClient;

    @PostConstruct
    private void init() throws IOException, JSONException {
        this.token = this.getNewToken(this.tokenEndpoint, this.userName, this.password);
        this.tokenExpiration = JWT.decode((String)this.token).getExpiresAt().getTime();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(100);
        cm.setDefaultMaxPerRoute(100);
        this.translateClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
        LOG.info("Pangeanic translation service is initialized. Endpoint is {}", (Object)this.translateEndpoint);
    }

    private String getNewToken(String tokenEndpoint, String username, String password) throws IOException, JSONException {
        LOG.info("Requesting token from Pangeanic API...");
        HttpPost post = new HttpPost(tokenEndpoint);
        JSONObject body = new JSONObject();
        body.put("user", (Object)username);
        body.put("password", (Object)password);
        post.setEntity((HttpEntity)new StringEntity(body.toString()));
        post.setHeader("Accept", APPLICATION_JSON);
        post.setHeader("Content-Type", APPLICATION_JSON);
        try (CloseableHttpClient client = HttpClients.createDefault();){
            String string;
            block13: {
                CloseableHttpResponse response = client.execute((HttpUriRequest)post);
                try {
                    if (response.getStatusLine().getStatusCode() != 200) {
                        throw new IOException("Unable to retrieve token from Pangeanic Translation API: " + response.getStatusLine().getStatusCode() + " - " + response.getStatusLine().getReasonPhrase());
                    }
                    String json = EntityUtils.toString((HttpEntity)response.getEntity());
                    JSONObject obj = new JSONObject(json);
                    LOG.info("Token received");
                    string = obj.getString("access_token");
                    if (response == null) break block13;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
    }

    private synchronized String getValidToken() throws JSONException, IOException {
        if (this.tokenExpiration - new Date().getTime() < 30000L) {
            this.token = this.getNewToken(this.tokenEndpoint, this.userName, this.password);
            this.tokenExpiration = JWT.decode((String)this.token).getExpiresAt().getTime();
        }
        return this.token;
    }

    public List<String> translate(List<String> texts, String targetLanguage) throws TranslationException {
        return this.translate(texts, targetLanguage, null);
    }

    public List<String> translate(List<String> texts, String targetLanguage, String sourceLanguage) throws TranslationException {
        try {
            HttpPost post = this.createTranslateRequest(texts, targetLanguage, sourceLanguage);
            return this.sendTranslateRequestAndParse(post);
        }
        catch (IOException | JSONException e) {
            throw new TranslationException((Exception)e);
        }
    }

    private HttpPost createTranslateRequest(List<String> texts, String targetLanguage, String sourceLanguage) throws JSONException, IOException {
        HttpPost post = new HttpPost(this.translateEndpoint);
        JSONObject body = new JSONObject();
        JSONArray textArray = new JSONArray();
        for (String text : texts) {
            textArray.put((Object)text);
        }
        body.put("text", (Object)textArray);
        if (StringUtils.isNotBlank((CharSequence)sourceLanguage)) {
            body.put("src", (Object)sourceLanguage);
        }
        body.put("tgt", (Object)targetLanguage);
        post.setEntity((HttpEntity)new StringEntity(body.toString(), StandardCharsets.UTF_8));
        post.setHeader("Authorization", "Bearer " + this.getValidToken());
        post.setHeader("Accept", APPLICATION_JSON);
        post.setHeader("Content-Type", APPLICATION_JSON);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Sending POST {}", (Object)post.getURI());
            LOG.trace("  body {}", (Object)body);
            LOG.trace("  headers:");
            for (Header header : post.getAllHeaders()) {
                LOG.trace("  {}: {}", (Object)header.getName(), (Object)header.getValue());
            }
        }
        return post;
    }

    private List<String> sendTranslateRequestAndParse(HttpPost post) throws IOException, JSONException {
        try (CloseableHttpResponse response = this.translateClient.execute((HttpUriRequest)post);){
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Error from Pangeanic Translation API: " + response.getStatusLine().getStatusCode() + " - " + response.getStatusLine().getReasonPhrase());
            }
            String json = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONObject obj = new JSONObject(json);
            ArrayList<String> result = new ArrayList<String>();
            JSONArray translations = obj.getJSONArray("translation");
            for (int i = 0; i < translations.length(); ++i) {
                result.add(translations.getString(i));
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
    }

    public void close() {
        if (this.translateClient != null) {
            try {
                this.translateClient.close();
            }
            catch (IOException e) {
                LOG.error("Error closing connection to Pangeanic Translation API", (Throwable)e);
            }
        }
    }
}

