/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.service.translate;

import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.tasks.v2.stub.CloudTasksStubSettings;
import com.google.cloud.translate.v3.LocationName;
import com.google.cloud.translate.v3.TranslateTextRequest;
import com.google.cloud.translate.v3.TranslateTextResponse;
import com.google.cloud.translate.v3.Translation;
import com.google.cloud.translate.v3.TranslationServiceClient;
import com.google.cloud.translate.v3.TranslationServiceSettings;
import eu.europeana.api2.v2.service.translate.TranslationService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;

@PropertySources(value={@PropertySource(value={"classpath:europeana.properties"}), @PropertySource(value={"classpath:europeana.user.properties"}, ignoreResourceNotFound=true)})
public class GoogleTranslationService
implements TranslationService {
    private static final Logger LOG = LogManager.getLogger(GoogleTranslationService.class);
    private static final String MIME_TYPE_TEXT = "text/plain";
    @Value(value="#{europeanaProperties['translation.google.projectId']}")
    private String projectId;
    private TranslationServiceClient client;
    private LocationName locationName;

    @PostConstruct
    private void init() throws IOException {
        InstantiatingGrpcChannelProvider transportChannelProvider = CloudTasksStubSettings.defaultGrpcTransportProviderBuilder().setChannelConfigurator(managedChannelBuilder -> managedChannelBuilder.proxyDetector(socketAddress -> null)).build();
        TranslationServiceSettings tss = ((TranslationServiceSettings.Builder)TranslationServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)transportChannelProvider)).build();
        this.client = TranslationServiceClient.create((TranslationServiceSettings)tss);
        this.locationName = LocationName.of((String)this.projectId, (String)"global");
        LOG.info("GoogleTranslationService initialised, projectId = {}", (Object)this.projectId);
    }

    @PreDestroy
    public void close() {
        if (this.client != null) {
            LOG.info("Shutting down GoogleTranslationService client...");
            this.client.close();
        }
    }

    public List<String> translate(List<String> texts, String targetLanguage) {
        TranslateTextRequest request = TranslateTextRequest.newBuilder().setParent(this.locationName.toString()).setMimeType(MIME_TYPE_TEXT).setTargetLanguageCode(targetLanguage).addAllContents(texts).build();
        TranslateTextResponse response = this.client.translateText(request);
        ArrayList<String> result = new ArrayList<String>();
        for (Translation t : response.getTranslationsList()) {
            result.add(t.getTranslatedText());
        }
        return result;
    }

    public List<String> translate(List<String> text, String targetLanguage, String sourceLanguage) {
        TranslateTextRequest request = TranslateTextRequest.newBuilder().setParent(this.locationName.toString()).setMimeType(MIME_TYPE_TEXT).setTargetLanguageCode(targetLanguage).setSourceLanguageCode(sourceLanguage).addAllContents(text).build();
        TranslateTextResponse response = this.client.translateText(request);
        ArrayList<String> result = new ArrayList<String>();
        for (Translation t : response.getTranslationsList()) {
            result.add(t.getTranslatedText());
        }
        return result;
    }
}

