/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.config;

import eu.europeana.api2.config.SwaggerConfig;
import eu.europeana.api2.utils.SolrEscapeAnnotationFormatterFactory;
import eu.europeana.api2.utils.XmlUtils;
import eu.europeana.api2.v2.model.xml.kml.KmlResponse;
import eu.europeana.api2.v2.model.xml.rss.RssResponse;
import eu.europeana.api2.v2.web.controller.ObjectController;
import eu.europeana.api2.v2.web.controller.SearchController;
import java.util.Collections;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.format.AnnotationFormatterFactory;
import org.springframework.format.FormatterRegistry;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.DefaultServletHandlerConfigurer;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.web.servlet.view.xml.MarshallingView;

@Configuration
@EnableWebMvc
@ComponentScan(basePackageClasses={ObjectController.class, SearchController.class})
@Import(value={SwaggerConfig.class})
@EnableAsync
public class WebMvcConfig
extends WebMvcConfigurerAdapter {
    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.favorPathExtension(true);
    }

    @Bean
    public ViewResolver contentViewResolver() {
        InternalResourceViewResolver viewResolver = new InternalResourceViewResolver();
        viewResolver.setPrefix("/WEB-INF/jsp/");
        viewResolver.setSuffix(".jsp");
        return viewResolver;
    }

    @Bean(name={"api2_mvc_views_jaxbmarshaller"})
    public Jaxb2Marshaller jaxb2Marshaller() {
        Jaxb2Marshaller marshaller = new Jaxb2Marshaller();
        marshaller.setClassesToBeBound(new Class[]{RssResponse.class, KmlResponse.class});
        marshaller.setMarshallerProperties(Collections.singletonMap("jaxb.formatted.output", Boolean.TRUE));
        return marshaller;
    }

    @Bean
    public MarshallingView marshallingView() {
        return new MarshallingView((Marshaller)this.jaxb2Marshaller());
    }

    @Bean(name={"api2_mvc_xmlUtils"})
    public XmlUtils xmlUtils() {
        return new XmlUtils();
    }

    public void configureDefaultServletHandling(DefaultServletHandlerConfigurer configurer) {
        configurer.enable();
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowCredentials(false).allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"*"}).exposedHeaders(new String[]{"Allow", "Vary", "Link", "ETag"}).maxAge(1000L);
    }

    public void addFormatters(FormatterRegistry registry) {
        super.addFormatters(registry);
        registry.addFormatterForFieldAnnotation((AnnotationFormatterFactory)new SolrEscapeAnnotationFormatterFactory());
    }
}

