/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.model.translate;

import eu.europeana.api2.v2.model.translate.Query;
import eu.europeana.api2.v2.model.translate.QueryPart;
import eu.europeana.api2.v2.model.translate.QueryPartType;
import eu.europeana.api2.v2.service.translate.TranslationService;
import java.util.ArrayList;
import java.util.List;

public class QueryLanguageDetector {
    private TranslationService translationService;

    public QueryLanguageDetector(TranslationService translationService) {
        this.translationService = translationService;
    }

    public List<String> detectLanguages(Query query) {
        ArrayList<String> languages = new ArrayList<String>();
        for (QueryPart queryPart : query.getQueryPartList()) {
            String text;
            String originalText = queryPart.getText();
            QueryPartType type = queryPart.getPartType();
            if (type != QueryPartType.QUOTED && type != QueryPartType.TEXT || (text = originalText.trim()).isEmpty()) continue;
            languages.add(this.translationService.detectLanguage(originalText));
        }
        return languages;
    }
}

