/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.config;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import eu.europeana.api2.config.SwaggerConfig;
import eu.europeana.api2.model.utils.Api2UrlService;
import eu.europeana.api2.utils.VersionUtils;
import eu.europeana.api2.v2.web.swagger.SwaggerIgnore;
import eu.europeana.api2.v2.web.swagger.SwaggerSelect;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;
import springfox.documentation.PathProvider;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Tag;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@EnableSwagger2
@PropertySource(value={"classpath:swagger.properties"})
public class SwaggerConfig {
    public static final String SEARCH_TAG = "Search";
    public static final String RECORD_TAG = "Record";
    private static final String API_PATH = "/";

    private String getApiBaseUrl() {
        return StringUtils.substringAfter((String)Api2UrlService.getBeanInstance().getApi2BaseUrl(""), (String)"://");
    }

    @Bean
    public Docket apiDocumentationConfig() {
        return new Docket(DocumentationType.SWAGGER_2).select().apis(RequestHandlerSelectors.withClassAnnotation(SwaggerSelect.class)).apis(Predicates.not((Predicate)Predicates.or((Predicate)RequestHandlerSelectors.withMethodAnnotation(SwaggerIgnore.class), (Predicate)RequestHandlerSelectors.withClassAnnotation(SwaggerIgnore.class)))).paths(PathSelectors.ant((String)"/record/v2/**")).build().host(this.getApiBaseUrl()).pathProvider((PathProvider)new ApiPathProvider(this, API_PATH)).apiInfo(this.apiInfo()).tags(new Tag(SEARCH_TAG, ""), new Tag[0]).tags(new Tag(RECORD_TAG, ""), new Tag[0]);
    }

    private ApiInfo apiInfo() {
        String version = VersionUtils.getVersion(this.getClass());
        return new ApiInfo("Europeana Search & Record API", "This Swagger API console provides an overview of the Europeana Search & Record API. You can build and test anything from the simplest search to a complex query using facetList such as dates, geotags and permissions. For more help and information, head to our comprehensive <a href=\"https://pro.europeana.eu/page/intro\">online documentation</a>.", StringUtils.isNotEmpty((CharSequence)version) ? version : "version unknown", "https://www.europeana.eu/en/rights/api-terms-of-use", "https://pro.europeana.eu/page/intro#general", "API terms of use", "https://www.europeana.eu/en/rights/api-terms-of-use");
    }
}

