/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.service.translate;

import eu.europeana.api2.v2.model.translate.Language;
import eu.europeana.corelib.definitions.edm.beans.FullBean;
import eu.europeana.corelib.definitions.edm.entity.EuropeanaAggregation;
import eu.europeana.corelib.utils.EuropeanaUriUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.ReflectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class BeanFilterLanguage {
    private static final Logger LOG = LogManager.getLogger(BeanFilterLanguage.class);

    private BeanFilterLanguage() {
    }

    public static FullBean filter(FullBean bean, List<Language> targetLangs) {
        long startTime = System.currentTimeMillis();
        BeanFilterLanguage.iterativeFilterFields((Object)bean, targetLangs);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Filtering record language data took {} ms", (Object)(System.currentTimeMillis() - startTime));
        }
        return bean;
    }

    private static void iterativeFilterFields(Object o, List<Language> targetLangs) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Filtering - object {}", (Object)o.getClass().getName());
        }
        ReflectionUtils.FieldFilter fieldFilter = field -> field.getType().isAssignableFrom(Map.class) || field.getType().isAssignableFrom(List.class) || field.getType().isAssignableFrom(EuropeanaAggregation.class);
        ReflectionUtils.doWithFields(o.getClass(), field -> {
            ReflectionUtils.makeAccessible((Field)field);
            Object fieldValue = field.get(o);
            if (LOG.isDebugEnabled()) {
                LOG.debug("  Field {} has class {}", (Object)field.getName(), fieldValue == null ? null : fieldValue.getClass());
            }
            if (fieldValue instanceof Map) {
                fieldValue = BeanFilterLanguage.filterLanguageMap((String)field.getName(), (Map)((Map)fieldValue), (List)targetLangs);
                if (fieldValue == null) {
                    LOG.debug("    Deleting map {} entirely", (Object)field.getName());
                    field.set(o, null);
                }
            } else if (fieldValue instanceof List) {
                List list = (List)fieldValue;
                for (Object item : list) {
                    BeanFilterLanguage.iterativeFilterFields(item, (List)targetLangs);
                }
            } else if (fieldValue instanceof EuropeanaAggregation) {
                BeanFilterLanguage.iterativeFilterFields((Object)fieldValue, (List)targetLangs);
            } else assert (fieldValue == null) : "Unknown field class " + fieldValue.getClass() + ". Checks do not match field filter";
        }, (ReflectionUtils.FieldFilter)fieldFilter);
    }

    private static Map filterLanguageMap(String fieldName, Map<?, ?> map, List<Language> targetLangs) {
        if (map == null) {
            return null;
        }
        LOG.debug("    Map {} has {} keys and {} values", (Object)fieldName, (Object)map.keySet().size(), (Object)map.values().size());
        Set<Map.Entry<?, ?>> set = map.entrySet();
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (Map.Entry<?, ?> keyValue : set) {
            if ("def".equals(keyValue.getKey()) || EuropeanaUriUtils.isUri((String)keyValue.getValue().toString())) {
                LOG.debug("      Keeping key def, value {}", keyValue.getValue());
                continue;
            }
            String keyLang = keyValue.getKey().toString();
            if (!Language.isSupported((String)keyLang) || !targetLangs.contains(Language.valueOf((String)keyLang.toUpperCase(Locale.ROOT)))) {
                LOG.debug("      Removing key {}, value {}", (Object)keyLang, keyValue.getValue());
                keysToRemove.add(keyLang);
                continue;
            }
            LOG.debug("      Keeping key {}, value {}", (Object)keyLang, keyValue.getValue());
        }
        if (map.keySet().size() == keysToRemove.size()) {
            return null;
        }
        for (String keyToRemove : keysToRemove) {
            map.remove(keyToRemove);
        }
        return map;
    }
}

