/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.annotation.Resource;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.springframework.oxm.XmlMappingException;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.springframework.stereotype.Service;

@Service
public class XmlUtils {
    @Resource(name="api2_mvc_views_jaxbmarshaller")
    private Jaxb2Marshaller marshaller;

    public String toString(Object rss) {
        String xml = null;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            this.marshaller.marshal(rss, (Result)new StreamResult(baos));
            xml = new String(baos.toByteArray(), "UTF-8");
        }
        catch (IOException | XmlMappingException e) {
            LogManager.getLogger(XmlUtils.class).error("Error during serialization: {}", (Object)e.getMessage(), (Object)e);
        }
        return xml;
    }
}

