/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.utils;

import eu.europeana.api2.ApiKeyException;
import eu.europeana.api2.model.utils.Api2UrlService;
import eu.europeana.corelib.web.exception.ProblemType;
import java.io.IOException;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApiKeyUtils {
    private static final Logger LOG = LogManager.getLogger(ApiKeyUtils.class);
    private static final String AUTHORIZATION = "Authorization";
    private static final String APIKEYSERVICEERROR = "Problem connecting to the apikey service";
    private static final int MAXCONNTOTAL = 200;
    private static final int MAXCONNPERROUTE = 100;
    @Resource
    private Api2UrlService urlService;
    private CloseableHttpClient httpClient;

    public ApiKeyUtils() {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(200);
        cm.setDefaultMaxPerRoute(100);
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
    }

    @PreDestroy
    public void close() throws IOException {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void validateApiKey(String apikey) throws ApiKeyException {
        if (StringUtils.isBlank((CharSequence)apikey)) {
            throw new ApiKeyException(ProblemType.APIKEY_MISSING, null, 400);
        }
        t = System.currentTimeMillis();
        httpPost = new HttpPost(this.urlService.getApikeyValidateUrl());
        httpPost.setHeader("Authorization", "APIKEY " + apikey);
        try {
            response = this.httpClient.execute((HttpUriRequest)httpPost);
            try {
                statusCode = response.getStatusLine().getStatusCode();
                switch (statusCode) {
                    case 200: {
                        ** break;
lbl13:
                        // 1 sources

                        break;
                    }
                    case 204: {
                        ** break;
lbl16:
                        // 1 sources

                        break;
                    }
                    case 401: {
                        throw new ApiKeyException(ProblemType.APIKEY_DOES_NOT_EXIST, apikey, response.getStatusLine().getStatusCode());
                    }
                    case 410: {
                        throw new ApiKeyException(ProblemType.APIKEY_DEPRECATED, apikey, response.getStatusLine().getStatusCode());
                    }
                    default: {
                        ApiKeyUtils.LOG.error("{}: {} ({})", (Object)"Unexpected API key service response", (Object)statusCode, (Object)response.getStatusLine().getReasonPhrase());
                        break;
                    }
                }
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }
        catch (IOException e) {
            ApiKeyUtils.LOG.error("Problem connecting to the apikey service", (Throwable)e);
        }
        ApiKeyUtils.LOG.debug("Post request to validate apiKey took {} ms", (Object)(System.currentTimeMillis() - t));
    }
}

