/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.service.translate;

import com.google.api.gax.rpc.ResourceExhaustedException;
import eu.europeana.api2.v2.exceptions.TranslationException;
import eu.europeana.api2.v2.exceptions.TranslationServiceLimitException;
import eu.europeana.api2.v2.service.translate.FieldValuesLanguageMap;
import eu.europeana.api2.v2.service.translate.TranslationService;
import eu.europeana.corelib.utils.ComparatorUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class TranslationUtils {
    private static final Logger LOG = LogManager.getLogger(TranslationUtils.class);

    private TranslationUtils() {
    }

    public static FieldValuesLanguageMap translate(TranslationService translationService, FieldValuesLanguageMap toTranslate, String targetLanguage) throws TranslationException, TranslationServiceLimitException {
        List translations;
        LinkedHashMap<String, Integer> linesPerField = new LinkedHashMap<String, Integer>();
        ArrayList linesToTranslate = new ArrayList();
        for (Map.Entry entry : toTranslate.entrySet()) {
            List lines = (List)entry.getValue();
            linesPerField.put((String)entry.getKey(), lines.size());
            linesToTranslate.addAll(lines);
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace("Key {}, values to translate {}", entry.getKey(), (Object)lines);
        }
        try {
            if ("def".equals(toTranslate.getSourceLanguage())) {
                LOG.debug("Sending translate query with language detect...");
                translations = translationService.translate(linesToTranslate, targetLanguage);
            } else {
                LOG.debug("Sending translate query with source language {} and target language {}...", (Object)toTranslate.getSourceLanguage(), (Object)targetLanguage);
                translations = translationService.translate(linesToTranslate, targetLanguage, toTranslate.getSourceLanguage());
            }
        }
        catch (ResourceExhaustedException e) {
            throw new TranslationServiceLimitException((Exception)((Object)e));
        }
        catch (RuntimeException e) {
            throw new TranslationException((Exception)e);
        }
        if (translations.size() != linesToTranslate.size()) {
            throw new IllegalStateException("Expected " + linesToTranslate.size() + " lines of translated text, but received " + translations.size());
        }
        FieldValuesLanguageMap result = new FieldValuesLanguageMap(targetLanguage);
        int counter = 0;
        for (String key : toTranslate.keySet()) {
            int nrLines = (Integer)linesPerField.get(key);
            if (nrLines == 0) {
                result.put(key, null);
            } else {
                result.put(key, translations.subList(counter, counter + nrLines));
            }
            counter += nrLines;
        }
        return result;
    }

    public static FieldValuesLanguageMap removeIfOriginalIsSameAsTranslated(FieldValuesLanguageMap translatedMap, FieldValuesLanguageMap mapToTranslate) {
        HashMap actualTranslationMap = new HashMap();
        for (Map.Entry translated : translatedMap.entrySet()) {
            ArrayList<String> actualTranslatedValues = new ArrayList<String>();
            for (int i = 0; i < ((List)translated.getValue()).size(); ++i) {
                if (ComparatorUtils.sameValueWithoutSpace((String)((String)((List)mapToTranslate.get(translated.getKey())).get(i)), (String)((String)((List)translated.getValue()).get(i)))) continue;
                actualTranslatedValues.add((String)((List)translated.getValue()).get(i));
            }
            if (actualTranslatedValues.isEmpty()) continue;
            actualTranslationMap.put((String)translated.getKey(), actualTranslatedValues);
        }
        if (!actualTranslationMap.isEmpty()) {
            return new FieldValuesLanguageMap(translatedMap.getSourceLanguage(), actualTranslationMap);
        }
        return null;
    }
}

