/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.service;

import eu.europeana.api2.config.RouteConfigLoader;
import eu.europeana.api2.model.utils.RouteMatcher;
import eu.europeana.corelib.record.BaseUrlWrapper;
import eu.europeana.corelib.record.DataSourceWrapper;
import eu.europeana.corelib.record.config.RecordServerConfig;
import eu.europeana.corelib.search.config.SearchServerConfig;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RouteDataService {
    @Autowired
    private RouteConfigLoader routeConfig;
    @Autowired
    private RecordServerConfig recordServerConfig;
    @Autowired
    private SearchServerConfig searchServerConfig;
    private static final Logger LOG = LogManager.getLogger(RouteDataService.class);
    private static final BaseUrlWrapper EMPTY_BASE_URL = new BaseUrlWrapper("", "", "");

    public RouteDataService() {
    }

    @Autowired
    public RouteDataService(RouteConfigLoader routeConfig, RecordServerConfig recordServerConfig, SearchServerConfig searchServerConfig) {
        this.routeConfig = routeConfig;
        this.recordServerConfig = recordServerConfig;
        this.searchServerConfig = searchServerConfig;
    }

    @PostConstruct
    void validateRouteConfig() {
        String route;
        boolean isConfigValid = true;
        for (Map.Entry entry : this.routeConfig.getRouteDataSourceMap().entrySet()) {
            route = (String)entry.getKey();
            String dsId = (String)entry.getValue();
            if (this.recordServerConfig.getDataSourceById(dsId).isPresent()) {
                LOG.info("Route {} - data source id {} configured", (Object)route, (Object)dsId);
                continue;
            }
            LOG.error("Invalid data source configured for route {}: no data source found with id {}", (Object)route, (Object)dsId);
            isConfigValid = false;
        }
        for (Map.Entry entry : this.routeConfig.getRouteSolrMap().entrySet()) {
            route = (String)entry.getKey();
            String solrId = (String)entry.getValue();
            if (this.searchServerConfig.getSolrClientById(solrId).isPresent()) {
                LOG.info("Route {} - solr client id {} configured", (Object)route, (Object)solrId);
                continue;
            }
            LOG.error("Invalid solr config for route {}: no solr client with id {}", (Object)route, (Object)solrId);
            isConfigValid = false;
        }
        for (Map.Entry entry : this.routeConfig.getRouteBaseUrlMap().entrySet()) {
            route = (String)entry.getKey();
            BaseUrlWrapper baseUrlWrapper = (BaseUrlWrapper)entry.getValue();
            LOG.info("Route {} - configured baseUrls {}", (Object)route, (Object)baseUrlWrapper);
        }
        if (!isConfigValid) {
            throw new IllegalStateException("Invalid route configuration");
        }
    }

    public Optional<DataSourceWrapper> getRecordServerForRequest(String requestRoute) {
        Optional dataSourceId = RouteMatcher.getEntryForRoute((String)requestRoute, (Map)this.routeConfig.getRouteDataSourceMap());
        if (dataSourceId.isEmpty()) {
            return Optional.empty();
        }
        return this.recordServerConfig.getDataSourceById((String)dataSourceId.get());
    }

    public Optional<SolrClient> getSolrClientForRequest(String requestRoute) {
        Optional solrId = RouteMatcher.getEntryForRoute((String)requestRoute, (Map)this.routeConfig.getRouteSolrMap());
        if (solrId.isEmpty()) {
            return Optional.empty();
        }
        return this.searchServerConfig.getSolrClientById((String)solrId.get());
    }

    public BaseUrlWrapper getBaseUrlsForRequest(String requestRoute) {
        Optional baseUrl = RouteMatcher.getEntryForRoute((String)requestRoute, (Map)this.routeConfig.getRouteBaseUrlMap());
        if (baseUrl.isEmpty()) {
            LOG.debug("No baseUrl configured. Using empty strings as baseUrl values");
            return EMPTY_BASE_URL;
        }
        return (BaseUrlWrapper)baseUrl.get();
    }
}

