/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.model.translate;

import eu.europeana.api2.v2.exceptions.InvalidParamValueException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum Language {
    EN,
    NL,
    FR,
    DE,
    ES,
    SV,
    IT,
    FI,
    DA,
    EL,
    CS,
    SK,
    SL,
    PT,
    HU,
    LT,
    PL,
    RO,
    BG,
    HR,
    LV,
    GA,
    MT,
    ET,
    NO,
    CA,
    RU;

    private static final Set<String> LANGUAGES;
    private static final String SEPARATOR = ",";
    public static final String DEF = "def";
    public static final String ENGLISH;

    public static Language validateSingle(String languageAbbrevation) throws InvalidParamValueException {
        Language result;
        if (StringUtils.isBlank((CharSequence)languageAbbrevation)) {
            throw new InvalidParamValueException("Empty language value");
        }
        try {
            result = Language.valueOf((String)languageAbbrevation.trim().toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidParamValueException("Language value '" + languageAbbrevation + "' is not valid");
        }
        return result;
    }

    public static List<Language> validateMultiple(String languageAbbrevations) throws InvalidParamValueException {
        String[] languages;
        if (StringUtils.isBlank((CharSequence)languageAbbrevations)) {
            throw new InvalidParamValueException("Empty language value");
        }
        ArrayList<Language> result = new ArrayList<Language>();
        for (String language : languages = languageAbbrevations.split(",")) {
            result.add(Language.validateSingle((String)language));
        }
        if (result.isEmpty()) {
            throw new InvalidParamValueException("Language value '" + languageAbbrevations + "' is not valid");
        }
        return result;
    }

    public static boolean isSupported(String lang) {
        return LANGUAGES.contains(lang.toUpperCase(Locale.ROOT));
    }

    static {
        LANGUAGES = new HashSet(Stream.of(Language.values()).map(Enum::name).collect(Collectors.toList()));
        ENGLISH = EN.name().toLowerCase(Locale.ROOT);
    }
}

