/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.config;

import eu.europeana.api2.config.RouteConfigLoader;
import eu.europeana.api2.model.utils.Api2UrlService;
import eu.europeana.api2.v2.service.RouteDataService;
import eu.europeana.api2.v2.utils.ApiKeyUtils;
import eu.europeana.api2.v2.utils.HttpCacheUtils;
import java.util.Arrays;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

@Configuration
@ImportResource(value={"classpath:corelib-definitions-context.xml", "classpath:corelib-mongo-context.xml", "classpath:corelib-solr-context.xml", "classpath:corelib-web-context.xml"})
@PropertySource(value={"classpath:europeana.properties"})
public class AppConfig {
    private static final Logger LOG = LogManager.getLogger(AppConfig.class);
    @Value(value="${portal.baseUrl:}")
    private String portalBaseUrl;
    @Value(value="${api2.baseUrl:}")
    private String api2BaseUrl;
    @Value(value="${apikey.validate.url:}")
    private String apikeyValidateUrl;
    @Value(value="${apiGateway.baseUrl:}")
    private String apiGatewayBaseUrl;
    @Autowired
    private Environment env;

    @PostConstruct
    public void logConfiguration() {
        LOG.info("CF_INSTANCE_INDEX  = {}, CF_INSTANCE_GUID = {}, CF_INSTANCE_IP  = {}", (Object)System.getenv("CF_INSTANCE_INDEX"), (Object)System.getenv("CF_INSTANCE_GUID"), (Object)System.getenv("CF_INSTANCE_IP"));
        LOG.info("Active Spring profiles: {}", (Object)Arrays.toString(this.env.getActiveProfiles()));
        LOG.info("Default Spring profiles: {}", (Object)Arrays.toString(this.env.getDefaultProfiles()));
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer properties() {
        PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer = new PropertySourcesPlaceholderConfigurer();
        propertySourcesPlaceholderConfigurer.setIgnoreResourceNotFound(true);
        propertySourcesPlaceholderConfigurer.setLocalOverride(true);
        propertySourcesPlaceholderConfigurer.setLocations(new Resource[]{new ClassPathResource("europeana.properties"), new ClassPathResource("europeana.user.properties")});
        return propertySourcesPlaceholderConfigurer;
    }

    @Bean
    public ApiKeyUtils apiKeyUtils() {
        return new ApiKeyUtils();
    }

    @Bean
    public HttpCacheUtils httpCacheUtils() {
        return new HttpCacheUtils();
    }

    @Bean
    public Api2UrlService api2UrlService() {
        Api2UrlService urlService = new Api2UrlService(this.routeConfigLoader().getRouteBaseUrlMap(), this.portalBaseUrl, this.api2BaseUrl, this.apikeyValidateUrl, this.apiGatewayBaseUrl);
        LogManager.getLogger(Api2UrlService.class).info("Portal base url = {}", (Object)urlService.getPortalBaseUrl(""));
        LogManager.getLogger(Api2UrlService.class).info("API2 base url = {}", (Object)urlService.getApi2BaseUrl(""));
        LogManager.getLogger(Api2UrlService.class).info("Apikey validate url = {}", (Object)urlService.getApikeyValidateUrl());
        LogManager.getLogger(Api2UrlService.class).info("Api gateway base url = {}", (Object)urlService.getApiGatewayBaseUrl(""));
        return urlService;
    }

    @Bean
    public RouteConfigLoader routeConfigLoader() {
        return new RouteConfigLoader();
    }

    @Bean
    public RouteDataService routeService() {
        return new RouteDataService();
    }
}

