/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.web.controller.admin;

import eu.europeana.api2.model.json.abstracts.ApiResponse;
import eu.europeana.api2.model.request.admin.ApiKeyCreate;
import eu.europeana.api2.model.request.admin.ApiKeyUpdate;
import eu.europeana.api2.model.response.admin.ApiKeyResponse;
import eu.europeana.api2.v2.model.json.ModificationConfirmation;
import eu.europeana.api2.v2.web.swagger.SwaggerIgnore;
import eu.europeana.corelib.db.exception.DatabaseException;
import eu.europeana.corelib.db.service.ApiKeyService;
import eu.europeana.corelib.definitions.db.entity.relational.ApiKey;
import eu.europeana.corelib.web.exception.EmailServiceException;
import java.io.Serializable;
import java.security.Principal;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/apikey"})
@SwaggerIgnore
public class ApiKeyAdminController {
    private static final long DEFAULT_USAGE_LIMIT = 10000L;
    @Resource
    private ApiKeyService apiKeyService;

    @RequestMapping(value={"/{term:.+}"}, method={RequestMethod.GET}, produces={"application/json"})
    public ApiResponse find(@PathVariable String term, Principal principal) {
        ApiKeyResponse response = new ApiKeyResponse(principal.getName());
        try {
            if (StringUtils.contains((CharSequence)term, (CharSequence)"@")) {
                for (ApiKey apiKey : this.apiKeyService.findByEmail(term)) {
                    response.getApiKeys().add(this.toEntity(apiKey));
                }
            } else {
                ApiKey apiKey = (ApiKey)this.apiKeyService.findByID((Serializable)((Object)term));
                if (apiKey != null) {
                    response.getApiKeys().add(this.toEntity(apiKey));
                }
            }
        }
        catch (DatabaseException e) {
            response.success = false;
            response.error = e.getMessage();
        }
        return response;
    }

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public ApiResponse createApiKey(@RequestBody ApiKeyCreate create, Principal principal) {
        ModificationConfirmation response = new ModificationConfirmation(principal.getName());
        try {
            this.apiKeyService.createApiKey(create.getEmail(), Long.valueOf(10000L), create.getApplication(), create.getCompany(), create.getFirstName(), create.getLastName(), create.getWebsite(), create.getDescription());
            response.success = true;
        }
        catch (DatabaseException | EmailServiceException e) {
            response.success = false;
            response.error = e.getMessage();
        }
        return response;
    }

    @RequestMapping(value={"/{apiKey}"}, method={RequestMethod.PUT}, consumes={"application/json"}, produces={"application/json"})
    public ApiResponse updateApiKey(@PathVariable String apiKey, @RequestBody ApiKeyUpdate update, Principal principal) {
        ModificationConfirmation response = new ModificationConfirmation(principal.getName());
        try {
            this.apiKeyService.updateApiKey(apiKey, update.getEmail(), update.getUsageLimit(), update.getApplication(), update.getCompany(), update.getFirstName(), update.getLastName(), update.getWebsite(), update.getDescription());
            response.success = true;
        }
        catch (DatabaseException e) {
            response.success = false;
            response.error = e.getMessage();
        }
        return response;
    }

    @RequestMapping(value={"/{apiKey}/limit/{limit}"}, method={RequestMethod.PUT}, produces={"application/json"})
    public ApiResponse updateApiKeyUsageLimit(@PathVariable String apiKey, @PathVariable long limit, Principal principal) {
        ModificationConfirmation response = new ModificationConfirmation(principal.getName());
        try {
            this.apiKeyService.changeLimit(apiKey, limit);
            response.success = true;
        }
        catch (DatabaseException e) {
            response.success = false;
            response.error = e.getMessage();
        }
        return response;
    }

    @RequestMapping(value={"/{apiKey}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    public ApiResponse deleteApiKey(@PathVariable String apiKey, Principal principal) {
        ModificationConfirmation response = new ModificationConfirmation(principal.getName());
        try {
            this.apiKeyService.removeApiKey(apiKey);
        }
        catch (DatabaseException e) {
            response.success = false;
            response.error = e.getMessage();
        }
        return response;
    }

    private ApiKeyResponse.ApiKey toEntity(ApiKey apiKey) {
        if (apiKey != null) {
            ApiKeyResponse.ApiKey entity = new ApiKeyResponse.ApiKey(new ApiKeyResponse());
            entity.setPublicKey((String)((Object)apiKey.getId()));
            entity.setPrivateKey(apiKey.getPrivateKey());
            entity.setApplication(apiKey.getApplicationName());
            entity.setCompany(apiKey.getCompany());
            entity.setDescription(apiKey.getDescription());
            entity.setEmail(apiKey.getEmail());
            entity.setFirstName(apiKey.getFirstName());
            entity.setLastName(apiKey.getLastName());
            entity.setWebsite(apiKey.getWebsite());
            entity.setUsageLimit(apiKey.getUsageLimit());
            entity.setLevel(apiKey.getLevel().toString());
            return entity;
        }
        return null;
    }
}

