/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.web.controller;

import eu.europeana.corelib.db.service.ApiKeyService;
import eu.europeana.corelib.definitions.db.entity.relational.ApiKey;
import eu.europeana.corelib.web.exception.EuropeanaException;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.security.Principal;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.approval.Approval;
import org.springframework.security.oauth2.provider.approval.ApprovalStore;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
@Deprecated
public class AccessConfirmationController {
    @Resource
    private ApiKeyService apiKeyService;
    @Resource
    private ApprovalStore approvalStore;
    @Resource(name="api2_oauth2_clientDetailsService")
    private ClientDetailsService clientDetailsService;

    public ModelAndView getAccessConfirmation(Map<String, Object> model, Principal principal) throws EuropeanaException {
        AuthorizationRequest clientAuth = (AuthorizationRequest)model.remove("authorizationRequest");
        ClientDetails client = this.clientDetailsService.loadClientByClientId(clientAuth.getClientId());
        ApiKey key = (ApiKey)this.apiKeyService.findByID((Serializable)((Object)client.getClientId()));
        model.put("auth_request", clientAuth);
        model.put("client", client);
        model.put("appName", StringUtils.defaultIfBlank((CharSequence)key.getApplicationName(), (CharSequence)((String)StringUtils.defaultIfBlank((CharSequence)key.getCompany(), (CharSequence)((String)((Object)key.getId()))))));
        LinkedHashMap<CallSite, String> scopes = new LinkedHashMap<CallSite, String>();
        for (String scope : clientAuth.getScope()) {
            scopes.put((CallSite)((Object)("scope." + scope)), "false");
        }
        this.approvalStore.getApprovals(principal.getName(), client.getClientId()).stream().filter(approval -> clientAuth.getScope().contains(approval.getScope())).forEach(approval -> scopes.put((CallSite)((Object)("scope." + approval.getScope())), approval.getStatus() == Approval.ApprovalStatus.APPROVED ? "true" : "false"));
        model.put("scopes", scopes);
        return new ModelAndView("user/authorize", model);
    }

    public String handleError(Map<String, Object> model) {
        model.put("message", "There was a problem with the OAuth2 protocol");
        return "user/error";
    }

    public String loginUserForm() {
        return "user/login";
    }
}

