/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.web.security.oauth2;

import eu.europeana.api2.web.security.model.OAuth2ClientDetails;
import eu.europeana.corelib.db.exception.DatabaseException;
import eu.europeana.corelib.db.service.ApiKeyService;
import eu.europeana.corelib.definitions.db.entity.relational.ApiKey;
import java.io.Serializable;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.stereotype.Service;

@Service(value="api2_oauth2_clientDetailsService")
public class OAuth2ClientDetailsService
implements ClientDetailsService {
    @Resource
    private ApiKeyService apiKeyService;

    public ClientDetails loadClientByClientId(String oAuthClientId) throws OAuth2Exception {
        try {
            ApiKey apiKey = (ApiKey)this.apiKeyService.findByID((Serializable)((Object)oAuthClientId));
            if (apiKey != null) {
                return new OAuth2ClientDetails(apiKey);
            }
        }
        catch (DatabaseException e) {
            LogManager.getLogger(this.getClass()).error(e.getMessage());
        }
        throw new OAuth2Exception("OAuth2 ClientId unknown");
    }
}

