/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.config;

import eu.europeana.api2.config.ActuatorConfig;
import eu.europeana.api2.config.AppConfig;
import eu.europeana.api2.config.OAuth2ServerConfig;
import eu.europeana.api2.config.SecurityConfig;
import eu.europeana.api2.config.SwaggerConfig;
import eu.europeana.api2.config.WebMvcConfig;
import eu.europeana.api2.config.filter.GetMethodConvertingFilter;
import eu.europeana.corelib.web.context.VcapPropertyLoader;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.filter.DelegatingFilterProxy;
import org.springframework.web.servlet.support.AbstractDispatcherServletInitializer;

@ComponentScan(basePackageClasses={GetMethodConvertingFilter.class})
public class ServletInitializer
extends AbstractDispatcherServletInitializer {
    public void onStartup(ServletContext servletContext) throws ServletException {
        super.onStartup(servletContext);
        this.registerProxyFilter(servletContext, "springSecurityFilterChain");
    }

    private void registerProxyFilter(ServletContext servletContext, String name) {
        DelegatingFilterProxy filter = new DelegatingFilterProxy(name);
        filter.setContextAttribute("org.springframework.web.servlet.FrameworkServlet.CONTEXT.dispatcher");
        servletContext.addFilter(name, (Filter)filter).addMappingForUrlPatterns(null, false, new String[]{"/*"});
    }

    protected WebApplicationContext createRootApplicationContext() {
        AnnotationConfigWebApplicationContext context = new AnnotationConfigWebApplicationContext();
        context.register(new Class[]{AppConfig.class, OAuth2ServerConfig.class, SecurityConfig.class});
        new VcapPropertyLoader();
        return context;
    }

    protected WebApplicationContext createServletApplicationContext() {
        AnnotationConfigWebApplicationContext context = new AnnotationConfigWebApplicationContext();
        context.register(new Class[]{SwaggerConfig.class, WebMvcConfig.class, ActuatorConfig.class});
        return context;
    }

    protected String[] getServletMappings() {
        return new String[]{"/"};
    }
}

