/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.web.controller.admin;

import eu.europeana.api2.model.json.abstracts.ApiResponse;
import eu.europeana.api2.model.request.admin.UserCreate;
import eu.europeana.api2.model.request.admin.UserPasswordReset;
import eu.europeana.api2.model.response.admin.UserResponse;
import eu.europeana.api2.v2.model.json.ModificationConfirmation;
import eu.europeana.api2.v2.web.swagger.SwaggerIgnore;
import eu.europeana.corelib.db.exception.DatabaseException;
import eu.europeana.corelib.db.service.UserService;
import eu.europeana.corelib.definitions.db.entity.relational.User;
import eu.europeana.corelib.web.exception.EmailServiceException;
import eu.europeana.corelib.web.exception.ProblemType;
import java.io.Serializable;
import java.security.Principal;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/user"})
@SwaggerIgnore
@Deprecated
public class UserAdminController {
    @Resource
    private UserService userService;
    @Value(value="${api2.canonical.url}")
    private String apiUrl;

    @RequestMapping(value={"/{term:.+}"}, method={RequestMethod.GET}, produces={"application/json"})
    public ApiResponse find(@PathVariable String term, Principal principal) {
        UserResponse response = new UserResponse(principal.getName());
        try {
            User user;
            User user2 = StringUtils.contains((CharSequence)term, (CharSequence)"@") ? this.userService.findByEmail(term) : (user = NumberUtils.isNumber((String)term) ? (User)this.userService.findByID((Serializable)NumberUtils.createLong((String)term)) : this.userService.findByName(term));
            if (user != null) {
                response.getUsers().add(this.toEntity(user));
            }
        }
        catch (DatabaseException e) {
            response.success = false;
            response.error = e.getMessage();
        }
        return response;
    }

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public ApiResponse createUser(@RequestBody UserCreate registration, Principal principal) {
        ModificationConfirmation response = new ModificationConfirmation(principal.getName());
        try {
            this.userService.create(registration.getEmail(), registration.getUsername(), registration.getPassword(), registration.getCompany(), registration.getCountry(), registration.getFirstName(), registration.getLastName(), registration.getWebsite(), registration.getAddress(), registration.getPhone(), registration.getFieldOfWork(), registration.getRedirect(), this.apiUrl);
            response.success = true;
        }
        catch (DatabaseException | EmailServiceException e) {
            response.success = false;
            response.error = e.getMessage();
        }
        return response;
    }

    @RequestMapping(value={"/{term:.+}"}, method={RequestMethod.PUT}, consumes={"application/json"}, produces={"application/json"})
    public ApiResponse updateUser(@RequestBody UserCreate update, @PathVariable String term, Principal principal, HttpServletResponse httpResponse) {
        UserResponse response = new UserResponse(principal.getName());
        response.success = false;
        if (null == update.getEmail() || null == update.getUsername() || null == update.getPassword()) {
            response.error = null == update.getEmail() ? ProblemType.MISSING_PARAM_EMAIL.getMessage() : (null == update.getUsername() ? ProblemType.MISSING_PARAM_USERNAME.getMessage() : ProblemType.MISSING_PARAM_PASSWORD.getMessage());
            httpResponse.setStatus(400);
            return response;
        }
        try {
            User user;
            User user2 = StringUtils.contains((CharSequence)term, (CharSequence)"@") ? this.userService.findByEmail(term) : (user = NumberUtils.isNumber((String)term) ? (User)this.userService.findByID((Serializable)NumberUtils.createLong((String)term)) : this.userService.findByName(term));
            if (user != null) {
                this.userService.update(user, update.getEmail(), update.getUsername(), update.getPassword(), update.getCompany(), update.getCountry(), update.getFirstName(), update.getLastName(), update.getWebsite(), update.getAddress(), update.getPhone(), update.getFieldOfWork());
                response.success = true;
                response.getUsers().add(this.toEntity(user));
            } else {
                response.error = ProblemType.NO_USER.getMessage();
            }
        }
        catch (DatabaseException e) {
            httpResponse.setStatus(418);
            e.printStackTrace();
            response.error = e.getMessage();
        }
        return response;
    }

    @RequestMapping(value={"/{term:.+}"}, method={RequestMethod.DELETE}, consumes={"application/json"}, produces={"application/json"})
    public ApiResponse deleteUser(@PathVariable String term, Principal principal, HttpServletResponse httpResponse) {
        UserResponse response = new UserResponse(principal.getName());
        response.success = false;
        try {
            User user;
            User user2 = StringUtils.contains((CharSequence)term, (CharSequence)"@") ? this.userService.findByEmail(term) : (user = NumberUtils.isNumber((String)term) ? (User)this.userService.findByID((Serializable)NumberUtils.createLong((String)term)) : this.userService.findByName(term));
            if (user != null) {
                this.userService.delete(user);
                response.success = true;
                httpResponse.setStatus(204);
            } else {
                response.error = ProblemType.NO_USER.getMessage();
            }
        }
        catch (DatabaseException e) {
            httpResponse.setStatus(500);
            e.printStackTrace();
            response.error = e.getMessage();
        }
        return response;
    }

    private UserResponse.User toEntity(User user) {
        if (user != null) {
            UserResponse.User entity = new UserResponse.User(new UserResponse());
            entity.setId((Long)user.getId());
            entity.setEmail(user.getEmail());
            entity.setUsername(user.getUserName());
            entity.setFirstName(user.getFirstName());
            entity.setLastName(user.getLastName());
            entity.setCompany(user.getCompany());
            entity.setCountry(user.getCountry());
            entity.setPhone(user.getPhone());
            entity.setAddress(user.getAddress());
            entity.setWebsite(user.getWebsite());
            entity.setFieldOfWork(user.getFieldOfWork());
            entity.setRole(user.getRole());
            return entity;
        }
        return null;
    }

    @RequestMapping(path={"/forgot"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    @Deprecated
    public ApiResponse forgotPassword(@RequestBody UserPasswordReset passwordReset, Principal principal) {
        ModificationConfirmation response = new ModificationConfirmation(principal.getName());
        try {
            this.userService.sendResetPasswordToken(passwordReset.getEmail(), passwordReset.getRedirect(), this.apiUrl);
            response.success = true;
        }
        catch (DatabaseException | EmailServiceException e) {
            response.success = false;
            response.error = e.getMessage();
        }
        return response;
    }

    @RequestMapping(path={"/resetpassword"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public ApiResponse resetPassword(@RequestBody UserPasswordReset passwordReset, Principal principal) {
        ModificationConfirmation response = new ModificationConfirmation(principal.getName());
        try {
            this.userService.resetPassword(passwordReset.getEmail(), passwordReset.getToken(), passwordReset.getPassword());
            response.success = true;
        }
        catch (DatabaseException | EmailServiceException e) {
            response.success = false;
            response.error = e.getMessage();
        }
        return response;
    }
}

