/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import com.github.jsonldjava.utils.JsonUtils;
import eu.europeana.api2.model.json.ApiError;
import eu.europeana.api2.model.utils.Api2UrlService;
import eu.europeana.api2.v2.model.json.ObjectResult;
import eu.europeana.api2.v2.model.json.view.FullView;
import eu.europeana.api2.v2.utils.ApiKeyUtils;
import eu.europeana.api2.v2.utils.HttpCacheUtils;
import eu.europeana.api2.v2.web.controller.ObjectController;
import eu.europeana.api2.v2.web.swagger.SwaggerIgnore;
import eu.europeana.api2.v2.web.swagger.SwaggerSelect;
import eu.europeana.corelib.db.entity.enums.RecordType;
import eu.europeana.corelib.definitions.edm.beans.FullBean;
import eu.europeana.corelib.edm.utils.EdmUtils;
import eu.europeana.corelib.edm.utils.SchemaOrgUtils;
import eu.europeana.corelib.record.RecordService;
import eu.europeana.corelib.solr.bean.impl.FullBeanImpl;
import eu.europeana.corelib.web.exception.EuropeanaException;
import eu.europeana.corelib.web.utils.RequestUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.JsonLDWriteContext;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.WriterDatasetRIOT;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.Context;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import springfox.documentation.annotations.ApiIgnore;

@Controller
@Api(tags={"Record"})
@RequestMapping(value={"/v2/record"})
@SwaggerSelect
public class ObjectController {
    private static final Logger LOG = LogManager.getLogger(ObjectController.class);
    private static final String MEDIA_TYPE_RDF_UTF8 = "application/rdf+xml; charset=UTF-8";
    private static final String MEDIA_TYPE_JSONLD_UTF8 = "application/ld+json; charset=UTF-8";
    private static final String MEDIA_TYPE_TURTLE_TEXT = "text/turtle";
    private static final String MEDIA_TYPE_TURTLE = "application/turtle";
    private static final String MEDIA_TYPE_TURTLE_X = "application/x-turtle";
    private static Object jsonldContext = new Object();
    private RecordService recordService;
    private ApiKeyUtils apiKeyUtils;
    private HttpCacheUtils httpCacheUtils;
    @Resource
    private Api2UrlService urlService;

    @Autowired
    public ObjectController(RecordService recordService, ApiKeyUtils apiKeyUtils, HttpCacheUtils httpCacheUtils) {
        this.recordService = recordService;
        this.apiKeyUtils = apiKeyUtils;
        this.httpCacheUtils = httpCacheUtils;
    }

    @ApiOperation(value="get a single record in JSON format", nickname="getSingleRecordJson")
    @GetMapping(value={"/{collectionId}/{recordId}.json"}, produces={"application/json;charset=UTF-8"})
    public ModelAndView record(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="profile", required=false, defaultValue="full") String profile, @RequestParam(value="wskey") String apikey, @RequestParam(value="callback", required=false) String callback, @ApiIgnore HttpServletRequest request, @ApiIgnore HttpServletResponse response) throws EuropeanaException {
        RequestData data = new RequestData(collectionId, recordId, apikey, profile, callback, request);
        return (ModelAndView)this.handleRecordRequest(RecordType.OBJECT, data, response);
    }

    @SwaggerIgnore
    @GetMapping(value={"/context.jsonld", "/context.json-ld"}, produces={"application/ld+json; charset=UTF-8", "application/json;charset=UTF-8"})
    public ModelAndView contextJSONLD(@RequestParam(value="callback", required=false) String callback) throws IOException {
        String jsonld = JsonUtils.toString((Object)jsonldContext);
        return eu.europeana.api2.utils.JsonUtils.toJson((String)jsonld, (String)callback);
    }

    @SwaggerIgnore
    @GetMapping(value={"/{collectionId}/{recordId}.json-ld"}, produces={"application/ld+json; charset=UTF-8", "application/json;charset=UTF-8"})
    public ModelAndView recordJSON_LD(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="wskey") String apikey, @RequestParam(value="callback", required=false) String callback, @ApiIgnore HttpServletRequest request, @ApiIgnore HttpServletResponse response) throws EuropeanaException {
        return this.recordJSONLD(collectionId, recordId, apikey, callback, request, response);
    }

    @ApiOperation(value="get single record in JSON LD format", nickname="getSingleRecordJsonLD")
    @GetMapping(value={"/{collectionId}/{recordId}.jsonld"}, produces={"application/ld+json; charset=UTF-8", "application/json;charset=UTF-8"})
    public ModelAndView recordJSONLD(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="wskey") String apikey, @RequestParam(value="callback", required=false) String callback, @ApiIgnore HttpServletRequest request, @ApiIgnore HttpServletResponse response) throws EuropeanaException {
        RequestData data = new RequestData(collectionId, recordId, apikey, null, callback, request);
        return (ModelAndView)this.handleRecordRequest(RecordType.OBJECT_JSONLD, data, response);
    }

    @ApiOperation(value="get single record in Schema.org JSON LD format", nickname="getSingleRecordSchemaOrg")
    @GetMapping(value={"/{collectionId}/{recordId}.schema.jsonld"}, produces={"application/ld+json; charset=UTF-8", "application/json;charset=UTF-8"})
    public ModelAndView recordSchemaOrg(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="wskey", required=true) String apikey, @RequestParam(value="callback", required=false) String callback, @ApiIgnore HttpServletRequest request, @ApiIgnore HttpServletResponse response) throws EuropeanaException {
        RequestData data = new RequestData(collectionId, recordId, apikey, null, callback, request);
        return (ModelAndView)this.handleRecordRequest(RecordType.OBJECT_SCHEMA_ORG, data, response);
    }

    @ApiOperation(value="get single record in RDF format)", nickname="getSingleRecordRDF")
    @GetMapping(value={"/{collectionId}/{recordId}.rdf"}, produces={"application/rdf+xml; charset=UTF-8"})
    public ModelAndView recordRdf(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="wskey") String apikey, @ApiIgnore HttpServletRequest request, @ApiIgnore HttpServletResponse response) throws EuropeanaException {
        RequestData data = new RequestData(collectionId, recordId, apikey, null, null, request);
        return (ModelAndView)this.handleRecordRequest(RecordType.OBJECT_RDF, data, response);
    }

    @ApiOperation(value="get single record in turtle format)", nickname="getSingleRecordTurtle")
    @GetMapping(value={"/{collectionId}/{recordId}.ttl"}, produces={"application/turtle", "text/turtle", "application/x-turtle"})
    public ModelAndView recordTurtle(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="wskey") String wskey, @ApiIgnore HttpServletRequest request, @ApiIgnore HttpServletResponse response) throws EuropeanaException {
        RequestData data = new RequestData(collectionId, recordId, wskey, null, null, request);
        return (ModelAndView)this.handleRecordRequest(RecordType.OBJECT_TURTLE, data, response);
    }

    private Object handleRecordRequest(RecordType recordType, RequestData data, HttpServletResponse response) throws EuropeanaException {
        ModelAndView output;
        if (!StringUtils.equalsIgnoreCase((CharSequence)"GET", (CharSequence)data.servletRequest.getMethod()) && !StringUtils.equalsIgnoreCase((CharSequence)"HEAD", (CharSequence)data.servletRequest.getMethod())) {
            response.setStatus(405);
            return null;
        }
        long startTime = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieving record with id " + data.europeanaId + ", type = " + recordType);
        }
        this.apiKeyUtils.validateApiKey(data.wskey);
        FullBean bean = this.recordService.fetchFullBean(data.europeanaId, true);
        if (Objects.isNull(bean)) {
            ModelAndView result;
            response.setStatus(404);
            if (recordType == RecordType.OBJECT_RDF) {
                HashMap<String, String> model = new HashMap<String, String>();
                model.put("error", "Non-existing record identifier");
                result = new ModelAndView("rdf", model);
            } else {
                result = eu.europeana.api2.utils.JsonUtils.toJson((Object)new ApiError(data.wskey, "Invalid record identifier: " + data.europeanaId), (String)data.callback);
            }
            return result;
        }
        String tsUpdated = this.httpCacheUtils.dateToRFC1123String(bean.getTimestampUpdated());
        String eTag = this.httpCacheUtils.generateETag(data.europeanaId + tsUpdated, true, true);
        if (StringUtils.isNotBlank((CharSequence)data.servletRequest.getHeader("If-None-Match"))) {
            if (this.httpCacheUtils.doesAnyIfNoneMatch(data.servletRequest, eTag)) {
                response = this.httpCacheUtils.addDefaultHeaders(response, eTag, tsUpdated);
                response.setStatus(304);
                return null;
            }
        } else if (StringUtils.isNotBlank((CharSequence)data.servletRequest.getHeader("If-Match"))) {
            if (this.httpCacheUtils.doesPreconditionFail(data.servletRequest, eTag)) {
                response.setStatus(412);
                return null;
            }
        } else if (this.httpCacheUtils.isNotModifiedSince(data.servletRequest, bean.getTimestampUpdated())) {
            response.setStatus(304);
            return null;
        }
        bean = this.recordService.enrichFullBean(bean);
        response = this.httpCacheUtils.addDefaultHeaders(response, eTag, tsUpdated);
        switch (1.$SwitchMap$eu$europeana$corelib$db$entity$enums$RecordType[recordType.ordinal()]) {
            case 1: {
                output = this.generateJson(bean, data, startTime);
                break;
            }
            case 2: {
                output = this.generateJsonLd(bean, data, response);
                break;
            }
            case 3: {
                output = this.generateRdf(bean);
                break;
            }
            case 4: {
                output = this.generateSchemaOrg(bean, data, response);
                break;
            }
            case 5: {
                output = this.generateTurtle(bean, data, response);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown record output type: " + recordType);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Done generating record output in " + (System.currentTimeMillis() - startTime) + " ms");
        }
        return output;
    }

    private ModelAndView generateJson(FullBean bean, RequestData data, long startTime) {
        ObjectResult objectResult = new ObjectResult(data.wskey);
        if (StringUtils.containsIgnoreCase((CharSequence)data.profile, (CharSequence)"params")) {
            objectResult.addParams(RequestUtils.getParameterMap((HttpServletRequest)data.servletRequest), new String[]{"wskey"});
            objectResult.addParam("profile", (Object)data.profile);
        }
        objectResult.object = new FullView(bean);
        objectResult.statsDuration = System.currentTimeMillis() - startTime;
        return eu.europeana.api2.utils.JsonUtils.toJson((Object)objectResult, (String)data.callback);
    }

    private ModelAndView generateSchemaOrg(FullBean bean, RequestData data, HttpServletResponse response) {
        try {
            String jsonld = SchemaOrgUtils.toSchemaOrg((FullBeanImpl)((FullBeanImpl)bean));
            return eu.europeana.api2.utils.JsonUtils.toJsonLd((String)jsonld, (String)data.callback);
        }
        catch (IOException e) {
            LOG.error("Error generating schema.org data", (Throwable)e);
            response.setStatus(500);
            return eu.europeana.api2.utils.JsonUtils.toJson((Object)new ApiError(data.wskey, e.getClass().getSimpleName() + ": " + e.getMessage()), (String)data.callback);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private ModelAndView generateJsonLd(FullBean bean, RequestData data, HttpServletResponse response) {
        String rdf = EdmUtils.toEDM((FullBeanImpl)((FullBeanImpl)bean));
        try (InputStream rdfInput = IOUtils.toInputStream((String)rdf);){
            ModelAndView modelAndView;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                Model modelResult = ModelFactory.createDefaultModel().read(rdfInput, "", "RDF/XML");
                DatasetGraph graph = DatasetFactory.wrap((Model)modelResult).asDatasetGraph();
                PrefixMap pm = RiotLib.prefixMap((DatasetGraph)graph);
                JsonLDWriteContext ctx = new JsonLDWriteContext();
                ctx.setJsonLDContext(jsonldContext);
                WriterDatasetRIOT writer = RDFDataMgr.createDatasetWriter((RDFFormat)RDFFormat.JSONLD_FLAT);
                writer.write((OutputStream)outputStream, graph, pm, null, (Context)ctx);
                modelAndView = eu.europeana.api2.utils.JsonUtils.toJsonLd((String)((Object)outputStream).toString(), (String)data.callback);
            }
            return modelAndView;
        }
        catch (IOException e) {
            LOG.error("Error parsing JSON-LD data", (Throwable)e);
            response.setStatus(500);
            return eu.europeana.api2.utils.JsonUtils.toJson((Object)new ApiError(data.wskey, e.getClass().getSimpleName() + ": " + e.getMessage()), (String)data.callback);
        }
    }

    private ModelAndView generateRdf(FullBean bean) {
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("record", EdmUtils.toEDM((FullBeanImpl)((FullBeanImpl)bean)));
        return new ModelAndView("rdf", model);
    }

    /*
     * Exception decompiling
     */
    private ModelAndView generateTurtle(FullBean bean, RequestData data, HttpServletResponse response) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String generateRedirectUrl(HttpServletRequest req, String oldId, String newId) {
        String scheme = req.getScheme();
        String serverName = req.getServerName();
        int serverPort = req.getServerPort();
        String requestUri = req.getRequestURI();
        String pathInfo = req.getPathInfo();
        String queryString = req.getQueryString();
        if (!(requestUri = requestUri.replace(oldId, newId)).contains(newId)) {
            throw new IllegalStateException("Error generating record redirect url");
        }
        StringBuilder url = new StringBuilder();
        url.append(scheme).append("://").append(serverName);
        if (serverPort != 80 && serverPort != 443) {
            url.append(':').append(serverPort);
        }
        url.append(requestUri);
        if (pathInfo != null) {
            url.append(pathInfo);
        }
        if (queryString != null) {
            url.append('?').append(queryString);
        }
        return url.toString();
    }

    static {
        try {
            InputStream in = ObjectController.class.getResourceAsStream("/jsonld/context.jsonld");
            jsonldContext = JsonUtils.fromInputStream((InputStream)in);
        }
        catch (IOException e) {
            LOG.error("Error reading context.jsonld", (Throwable)e);
        }
    }
}

