/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.utils;

import eu.europeana.api2.model.utils.Api2UrlService;
import eu.europeana.api2.v2.model.xml.rss.fieldtrip.FieldTripImage;
import eu.europeana.api2.v2.model.xml.rss.fieldtrip.FieldTripItem;
import eu.europeana.corelib.definitions.edm.beans.ApiBean;
import eu.europeana.corelib.definitions.edm.beans.BriefBean;
import eu.europeana.corelib.definitions.edm.beans.RichBean;
import eu.europeana.corelib.utils.StringArrayUtils;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class FieldTripUtils {
    private Api2UrlService urlService;
    private static final SimpleDateFormat FIELDTRIP_DATE_FORMATTER = new SimpleDateFormat("EEE, MMM d yyyy HH:mm:ss Z");
    private static final Pattern DESCRIPTION_PATTERN = Pattern.compile("(<description>)(.*?)(</description>)", 32);
    private static final Pattern ATTRIBUTION_PATTERN = Pattern.compile("(<attribution>)(.*?)(</attribution>)", 32);

    public FieldTripUtils(Api2UrlService urlService) {
        this.urlService = urlService;
    }

    public FieldTripItem createItem(RichBean bean) {
        FieldTripItem item = new FieldTripItem();
        item.guid = this.urlService.getRecordPortalUrl(bean.getId());
        item.title = this.getTitle((BriefBean)bean);
        item.description = this.extractDescription(bean.getDcDescription());
        item.images = this.getThumbnail(bean);
        item.point = this.getPoint((ApiBean)bean);
        item.pubDate = this.getPublicationDate(bean.getTimestampCreated());
        item.link = this.getLink(bean);
        return item;
    }

    public String cleanRss(String xml) {
        xml = this.cleanDescriptions(xml);
        xml = this.cleanAttributions(xml);
        return xml;
    }

    private String cleanDescriptions(String xml) {
        return this.cleanElements(DESCRIPTION_PATTERN.matcher(xml));
    }

    private String cleanAttributions(String xml) {
        return this.cleanElements(ATTRIBUTION_PATTERN.matcher(xml));
    }

    private String cleanElements(Matcher matcher) {
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(result, this.cleanElement(matcher));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private String cleanElement(Matcher matcher) {
        if (matcher.group(2).contains("&lt;")) {
            return matcher.group(1) + "<![CDATA[" + this.unescapeTags(matcher.group(2)) + "]]>" + matcher.group(3);
        }
        return matcher.group(0);
    }

    private String unescapeTags(String xml) {
        return xml.replace("&lt;", "<").replace("&gt;", ">");
    }

    private String getLink(RichBean bean) {
        String link = null;
        if (StringArrayUtils.isNotBlank((String[])bean.getEdmIsShownAt())) {
            for (String candidate : bean.getEdmIsShownAt()) {
                if (!StringUtils.isNotBlank((CharSequence)candidate)) continue;
                link = candidate;
                break;
            }
        }
        if (link == null) {
            for (String candidate : bean.getEdmLandingPage()) {
                if (!StringUtils.isNotBlank((CharSequence)candidate)) continue;
                link = candidate;
                break;
            }
        }
        return link;
    }

    private String getPublicationDate(Date timestampCreated) {
        if (timestampCreated == null) {
            return null;
        }
        return FIELDTRIP_DATE_FORMATTER.format(timestampCreated);
    }

    private String extractDescription(String[] dcDescription) {
        ArrayList<CallSite> descriptions = new ArrayList<CallSite>();
        for (String t : dcDescription) {
            if (!StringUtils.isNotBlank((CharSequence)t)) continue;
            t = t.trim().replaceAll("\n+", "\n").replace("\n", "</p>\n<p>");
            descriptions.add((CallSite)((Object)("<p>" + t + "</p>")));
        }
        if (descriptions.size() > 0) {
            return StringUtils.join(descriptions, (String)"\n");
        }
        return null;
    }

    private List<FieldTripImage> getThumbnail(RichBean bean) {
        ArrayList<FieldTripImage> images = new ArrayList<FieldTripImage>();
        String attribution = this.getAttribution(bean);
        if (bean.getEdmIsShownBy() != null) {
            for (String object : bean.getEdmIsShownBy()) {
                if (!StringUtils.isNotBlank((CharSequence)object)) continue;
                FieldTripImage image = new FieldTripImage(object);
                image.attribution = attribution;
                images.add(image);
            }
        }
        return images;
    }

    private String getAttribution(RichBean bean) {
        ArrayList<String> attribution = new ArrayList<String>();
        if (StringArrayUtils.isNotBlank((String[])bean.getRights())) {
            String right = null;
            for (String candidate : bean.getRights()) {
                if (!StringUtils.isNotBlank((CharSequence)candidate)) continue;
                right = candidate;
                break;
            }
            attribution.add(String.format("<a href=\"%s\">Copyrights</a>", right));
        }
        if (StringArrayUtils.isNotBlank((String[])bean.getDataProvider())) {
            attribution.add(String.format("%s", StringUtils.join((Object[])bean.getDataProvider(), (String)", ")));
        }
        return StringUtils.join(attribution, (String)" ");
    }

    private String getPoint(ApiBean bean) {
        String latitude = null;
        if (bean.getEdmPlaceLatitude() != null) {
            for (String coordinate : bean.getEdmPlaceLatitude()) {
                if (!this.isValidCoordinate(coordinate)) continue;
                latitude = coordinate;
                break;
            }
        }
        String longitude = null;
        if (bean.getEdmPlaceLongitude() != null) {
            for (String coordinate : bean.getEdmPlaceLongitude()) {
                if (!this.isValidCoordinate(coordinate)) continue;
                longitude = coordinate;
                break;
            }
        }
        if (StringUtils.isNotBlank(latitude) && StringUtils.isNotBlank(longitude)) {
            return latitude + " " + longitude;
        }
        return null;
    }

    private boolean isValidCoordinate(String coordinate) {
        return StringUtils.isNotBlank((CharSequence)coordinate) && !coordinate.equals("0") && !coordinate.equals("0.0");
    }

    private String getTitle(BriefBean bean) {
        if (!ArrayUtils.isEmpty((Object[])bean.getTitle())) {
            for (String title : bean.getTitle()) {
                if (StringUtils.isBlank((CharSequence)title)) continue;
                return title;
            }
        }
        return bean.getDataProvider()[0] + " " + bean.getId();
    }
}

