/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.utils;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.XSD;
import org.apache.log4j.Logger;

public class TurtleRecordWriter
implements AutoCloseable {
    private static final Logger LOG = Logger.getLogger(TurtleRecordWriter.class);
    private static final int KB = 1024;
    private static final int BUFFER_SIZE = 32768;
    private BufferedWriter bufferedWriter;
    private Map<String, String> map = new HashMap();

    public TurtleRecordWriter(OutputStream out) {
        this.bufferedWriter = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8), 32768);
    }

    public void write(Model m) throws IOException {
        this.writeHeader(m);
        try (ResIterator iter = m.listSubjectsWithProperty(RDF.type);){
            while (iter.hasNext()) {
                this.writeResource((Resource)iter.next());
            }
        }
    }

    private void writeResource(Resource r) throws IOException {
        Map props = this.getProperties(r);
        int len = this.calcMaxLength(props.keySet());
        boolean first = true;
        this.bufferedWriter.newLine();
        this.writeValue(r);
        for (Map.Entry entry : props.entrySet()) {
            if (first) {
                first = false;
            } else {
                this.bufferedWriter.append(" ;");
            }
            this.bufferedWriter.newLine();
            this.writePropertyDecl((String)entry.getKey(), len);
            this.writePropertyValues(r, (Property)entry.getValue());
        }
        this.bufferedWriter.append(" .");
        this.bufferedWriter.newLine();
    }

    private void writeHeader(Model m) throws IOException {
        for (Map.Entry entry : m.getNsPrefixMap().entrySet()) {
            String nPre = (String)entry.getKey();
            String nURI = (String)entry.getValue();
            String oURI = (String)this.map.get(nPre);
            if (oURI != null && oURI.equals(nURI)) continue;
            this.writePrefix(nPre, nURI);
        }
    }

    private void writePrefix(String prefix, String ns) throws IOException {
        this.map.put(prefix, ns);
        this.bufferedWriter.append("@prefix ").append(prefix).append(": ");
        this.writeAsIRI(ns).append(" .");
        this.bufferedWriter.newLine();
    }

    private void writePropertyDecl(String qname, int length) throws IOException {
        this.bufferedWriter.append("\t").append(qname);
        for (int i = length - qname.length(); i > 0; --i) {
            this.bufferedWriter.append(" ");
        }
        this.bufferedWriter.append("  ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePropertyValues(Resource r, Property p) throws IOException {
        boolean first = true;
        try (StmtIterator iter = r.listProperties(p);){
            while (iter.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    this.bufferedWriter.append(", ");
                }
                this.writeValue(((Statement)iter.next()).getObject());
            }
        }
    }

    private void writeValue(RDFNode node) throws IOException {
        if (node.isResource()) {
            this.writeValue(node.asResource());
        } else {
            this.writeValue(node.asLiteral());
        }
    }

    private void writeValue(Resource r) throws IOException {
        String uri = r.getURI();
        for (Map.Entry entry : this.map.entrySet()) {
            String value = (String)entry.getValue();
            if (!uri.startsWith(value)) continue;
            this.bufferedWriter.append((CharSequence)entry.getKey()).append(":").append(uri.substring(value.length()));
            return;
        }
        this.writeAsIRI(uri);
    }

    private void writeValue(Literal l) throws IOException {
        this.bufferedWriter.append('\"');
        this.writeAsString(l.getString());
        this.bufferedWriter.append('\"');
        String lang = l.getLanguage();
        if (!StringUtils.isEmpty((CharSequence)lang)) {
            this.bufferedWriter.append("@").append(lang);
            return;
        }
        RDFDatatype dt = l.getDatatype();
        if (this.hasDatatype(dt)) {
            this.writeDatatype(dt, l.getModel());
        }
    }

    private void escapeUnicode(char c) throws IOException {
        this.bufferedWriter.append("\\u");
        String s = Integer.toHexString(c).toUpperCase(Locale.GERMAN);
        for (int i = 4 - s.length(); i > 0; --i) {
            this.bufferedWriter.append('0');
        }
        this.bufferedWriter.append(s);
    }

    private void writeAsString(String str) throws IOException {
        int len = str.length();
        block3: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case '\"': 
                case '\\': {
                    this.bufferedWriter.append('\\').append(c);
                    continue block3;
                }
                default: {
                    this.bufferedWriter.append(c);
                }
            }
        }
    }

    private void writeDatatype(RDFDatatype dt, Model model) throws IOException {
        this.bufferedWriter.append("^^");
        String uri = dt.getURI();
        String prefix = model.getNsURIPrefix("http://www.w3.org/2001/XMLSchema#");
        if (prefix != null && uri.startsWith("http://www.w3.org/2001/XMLSchema#")) {
            this.bufferedWriter.append(prefix).append(":").append(uri.substring("http://www.w3.org/2001/XMLSchema#".length()));
        } else {
            this.writeAsIRI(uri);
        }
    }

    private BufferedWriter writeAsIRI(String str) throws IOException {
        this.bufferedWriter.append('<');
        int len = str.length();
        block3: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c >= '\u0000' && c <= ' ') {
                this.escapeUnicode(c);
                continue;
            }
            switch (c) {
                case '\"': 
                case '<': 
                case '>': 
                case '\\': 
                case '^': 
                case '`': 
                case '{': 
                case '|': 
                case '}': {
                    this.escapeUnicode(c);
                    continue block3;
                }
                default: {
                    this.bufferedWriter.append(c);
                }
            }
        }
        this.bufferedWriter.append('>');
        return this.bufferedWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Property> getProperties(Resource r) {
        TreeMap<String, Property> ret = new TreeMap<String, Property>();
        try (StmtIterator iter = r.listProperties();){
            while (iter.hasNext()) {
                Property p = ((Statement)iter.next()).getPredicate();
                ret.put(RDF.type.equals(p) ? "a" : this.getPropertyRef((Resource)p), p);
            }
        }
        return ret;
    }

    private String getPropertyRef(Resource r) {
        if (r == null) {
            return null;
        }
        String ns = r.getNameSpace();
        if (ns == null) {
            return "<" + r.getURI() + ">";
        }
        String p = r.getModel().getNsURIPrefix(ns);
        return p == null ? r.getURI() : p + ":" + r.getLocalName();
    }

    private int calcMaxLength(Collection<String> col) {
        int len = 0;
        for (String value : col) {
            len = Math.max(len, value.length());
        }
        return len;
    }

    private boolean hasDatatype(RDFDatatype dt) {
        String uri = XSD.xstring.getURI();
        return dt != null && !dt.getURI().equals(uri);
    }

    @Override
    public void close() {
        try {
            this.bufferedWriter.flush();
            this.bufferedWriter.close();
        }
        catch (IOException e) {
            LOG.error((Object)"Error closing the buffer writer ", (Throwable)e);
        }
    }
}

