/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.web.security.oauth2;

import eu.europeana.api2.web.security.model.Api2OAuth2ClientDetails;
import eu.europeana.corelib.db.exception.DatabaseException;
import eu.europeana.corelib.db.service.ApiKeyService;
import eu.europeana.corelib.definitions.db.entity.relational.ApiKey;
import java.io.Serializable;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;

public class OAuth2ClientDetailsService
implements ClientDetailsService {
    @Resource
    private ApiKeyService apiKeyService;

    public ClientDetails loadClientByClientId(String oauthClientId) throws OAuth2Exception {
        try {
            ApiKey apiKey = (ApiKey)this.apiKeyService.findByID((Serializable)((Object)oauthClientId));
            if (apiKey != null) {
                return new Api2OAuth2ClientDetails((String)((Object)apiKey.getId()), apiKey.getPrivateKey());
            }
        }
        catch (DatabaseException e) {
            Logger.getLogger(this.getClass()).error((Object)e.getMessage());
            e.printStackTrace();
        }
        throw new OAuth2Exception("OAuth2 ClientId unknown");
    }
}

