/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller.mydata;

import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.v2.model.json.UserModification;
import eu.europeana.api2.v2.model.json.UserResults;
import eu.europeana.api2.v2.model.json.abstracts.UserObject;
import eu.europeana.api2.v2.model.json.user.Tag;
import eu.europeana.api2.v2.web.controller.abstracts.AbstractUserController;
import eu.europeana.corelib.db.exception.DatabaseException;
import eu.europeana.corelib.definitions.db.entity.relational.ApiKey;
import eu.europeana.corelib.definitions.db.entity.relational.SocialTag;
import eu.europeana.corelib.definitions.db.entity.relational.User;
import eu.europeana.corelib.definitions.db.entity.relational.abstracts.EuropeanaUserObject;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class MyDataTagController
extends AbstractUserController {
    @RequestMapping(value={"/v2/mydata/tag.json"}, params={"!action"}, produces={"application/json"})
    public ModelAndView defaultAction(@RequestParam(value="europeanaid", required=false) String europeanaId, @RequestParam(value="tag", required=false) String tag, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        return this.list(europeanaId, tag, callback, principal);
    }

    @RequestMapping(value={"/v2/mydata/tag.json"}, params={"action=LIST"}, produces={"application/json"})
    public ModelAndView list(@RequestParam(value="europeanaid", required=false) String europeanaId, @RequestParam(value="tag", required=false) String tagFilter, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        UserResults response = new UserResults(principal.getName(), "/v2/mydata/tag.json");
        try {
            ApiKey apiKey = (ApiKey)this.apiKeyService.findByID((Serializable)((Object)principal.getName()));
            if (apiKey != null) {
                User user = apiKey.getUser();
                response.items = new ArrayList();
                response.username = user.getUserName();
                List tags = StringUtils.isNotBlank((String)tagFilter) ? this.userService.findSocialTagsByTag((Long)user.getId(), tagFilter) : (StringUtils.isNotBlank((String)europeanaId) ? this.userService.findSocialTagsByEuropeanaId((Long)user.getId(), europeanaId) : new ArrayList(user.getSocialTags()));
                response.itemsCount = tags.size();
                for (SocialTag item : tags) {
                    Tag tag = new Tag();
                    this.copyUserObjectData(response.apikey, (UserObject)tag, (EuropeanaUserObject)item);
                    tag.tag = item.getTag();
                    response.items.add(tag);
                }
                return JsonUtils.toJson((Object)response, (String)callback);
            }
            response.success = false;
            response.error = "Invalid credentials";
        }
        catch (DatabaseException e) {
            response.success = false;
            response.error = e.getMessage();
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }

    @RequestMapping(value={"/v2/mydata/tag.json"}, params={"action=TAGCLOUD"}, produces={"application/json"})
    public ModelAndView listDistinct(@RequestParam(value="callback", required=false) String callback, Principal principal) {
        UserResults response;
        block5: {
            response = new UserResults(principal.getName(), "/v2/mydata/tag.json?action=TAGCLOUD");
            try {
                ApiKey apiKey = (ApiKey)this.apiKeyService.findByID((Serializable)((Object)principal.getName()));
                if (apiKey != null) {
                    User user = apiKey.getUser();
                    try {
                        response.items = this.userService.createSocialTagCloud((Long)user.getId());
                        response.itemsCount = response.items.size();
                        response.success = true;
                    }
                    catch (DatabaseException e) {
                        response.success = false;
                        response.error = e.getMessage();
                    }
                    response.username = user.getUserName();
                    break block5;
                }
                response.success = false;
                response.error = "Invalid credentials";
            }
            catch (DatabaseException e) {
                response.success = false;
                response.error = e.getMessage();
            }
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }

    @RequestMapping(value={"/v2/mydata/tag.json"}, produces={"application/json"}, method={RequestMethod.POST, RequestMethod.PUT})
    public ModelAndView createRest(@RequestParam(value="europeanaid", required=true) String europeanaId, @RequestParam(value="tag", required=true) String tag, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        return this.create(europeanaId, tag, callback, principal);
    }

    @RequestMapping(value={"/v2/mydata/tag.json"}, params={"action=CREATE"}, produces={"application/json"})
    public ModelAndView create(@RequestParam(value="europeanaid", required=true) String europeanaId, @RequestParam(value="tag", required=true) String tag, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        UserModification response = new UserModification(principal.getName(), "/v2/mydata/tag.json?action=CREATE");
        try {
            ApiKey apiKey = (ApiKey)this.apiKeyService.findByID((Serializable)((Object)principal.getName()));
            if (apiKey != null) {
                User user = apiKey.getUser();
                try {
                    this.userService.createSocialTag((Long)user.getId(), europeanaId, tag);
                    response.success = true;
                }
                catch (DatabaseException e) {
                    response.success = false;
                    response.error = e.getMessage();
                }
            } else {
                response.success = false;
                response.error = "Invalid credentials";
            }
        }
        catch (DatabaseException e) {
            response.success = false;
            response.error = e.getMessage();
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }

    @RequestMapping(value={"/v2/mydata/tag.json"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ModelAndView deleteRest(@RequestParam(value="tagid", required=false) Long tagId, @RequestParam(value="tag", required=false) String tag, @RequestParam(value="europeanaid", required=false) String europeanaId, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        return this.delete(tagId, tag, europeanaId, callback, principal);
    }

    @RequestMapping(value={"/v2/mydata/tag.json"}, params={"action=DELETE"}, produces={"application/json"})
    public ModelAndView delete(@RequestParam(value="tagid", required=false) Long tagId, @RequestParam(value="tag", required=false) String tag, @RequestParam(value="europeanaid", required=false) String europeanaId, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        UserModification response = new UserModification(principal.getName(), "/v2/mydata/tag.json?action=DELETE");
        try {
            ApiKey apiKey = (ApiKey)this.apiKeyService.findByID((Serializable)((Object)principal.getName()));
            if (apiKey != null) {
                User user = apiKey.getUser();
                if (tagId != null) {
                    this.userService.removeSocialTag((Long)user.getId(), tagId);
                } else if (StringUtils.isNotBlank((String)europeanaId) || StringUtils.isNotBlank((String)tag)) {
                    this.userService.removeSocialTag((Long)user.getId(), europeanaId, tag);
                }
                response.success = true;
            }
        }
        catch (DatabaseException e) {
            response.success = false;
            response.error = e.getMessage();
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }
}

