/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import com.mongodb.Mongo;
import eu.europeana.api2.model.enums.ApiLimitException;
import eu.europeana.api2.model.json.ApiError;
import eu.europeana.api2.utils.FieldTripUtils;
import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.utils.XmlUtils;
import eu.europeana.api2.v2.model.LimitResponse;
import eu.europeana.api2.v2.model.json.SearchResults;
import eu.europeana.api2.v2.model.json.Suggestions;
import eu.europeana.api2.v2.model.json.view.ApiView;
import eu.europeana.api2.v2.model.json.view.BriefView;
import eu.europeana.api2.v2.model.json.view.RichView;
import eu.europeana.api2.v2.model.xml.kml.KmlResponse;
import eu.europeana.api2.v2.model.xml.rss.Channel;
import eu.europeana.api2.v2.model.xml.rss.Item;
import eu.europeana.api2.v2.model.xml.rss.RssResponse;
import eu.europeana.api2.v2.model.xml.rss.fieldtrip.FieldTripChannel;
import eu.europeana.api2.v2.model.xml.rss.fieldtrip.FieldTripImage;
import eu.europeana.api2.v2.model.xml.rss.fieldtrip.FieldTripItem;
import eu.europeana.api2.v2.model.xml.rss.fieldtrip.FieldTripResponse;
import eu.europeana.api2.v2.utils.ControllerUtils;
import eu.europeana.api2.v2.utils.FacetParameterUtils;
import eu.europeana.api2.v2.utils.ModelUtils;
import eu.europeana.corelib.db.entity.enums.RecordType;
import eu.europeana.corelib.db.exception.DatabaseException;
import eu.europeana.corelib.db.exception.LimitReachedException;
import eu.europeana.corelib.db.service.ApiKeyService;
import eu.europeana.corelib.db.service.ApiLogService;
import eu.europeana.corelib.db.service.UserService;
import eu.europeana.corelib.definitions.db.entity.relational.ApiKey;
import eu.europeana.corelib.definitions.edm.beans.ApiBean;
import eu.europeana.corelib.definitions.edm.beans.BriefBean;
import eu.europeana.corelib.definitions.edm.beans.IdBean;
import eu.europeana.corelib.definitions.edm.beans.RichBean;
import eu.europeana.corelib.definitions.solr.Facet;
import eu.europeana.corelib.definitions.solr.model.Query;
import eu.europeana.corelib.edm.exceptions.SolrTypeException;
import eu.europeana.corelib.logging.Log;
import eu.europeana.corelib.logging.Logger;
import eu.europeana.corelib.search.SearchService;
import eu.europeana.corelib.search.model.ResultSet;
import eu.europeana.corelib.search.utils.SearchUtils;
import eu.europeana.corelib.utils.StringArrayUtils;
import eu.europeana.corelib.web.model.rights.RightReusabilityCategorizer;
import eu.europeana.corelib.web.service.EuropeanaUrlService;
import eu.europeana.corelib.web.support.Configuration;
import eu.europeana.corelib.web.utils.NavigationUtils;
import eu.europeana.corelib.web.utils.RequestUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.response.SpellCheckResponse;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
public class SearchController {
    @Log
    private Logger log;
    @Resource(name="corelib_db_mongo")
    private Mongo mongo;
    @Resource
    private SearchService searchService;
    @Resource
    private ApiKeyService apiService;
    @Resource
    private UserService userService;
    @Resource
    private ApiLogService apiLogService;
    @Resource
    private Configuration configuration;
    @Resource
    private EuropeanaUrlService urlService;
    @Resource
    private ControllerUtils controllerUtils;
    @Resource(name="api2_mvc_views_jaxbmarshaller")
    private Jaxb2Marshaller marshaller;
    @Resource(name="api2_mvc_xmlUtils")
    private XmlUtils xmlUtils;
    @Resource
    private AbstractMessageSource messageSource;
    public static final int FACET_LIMIT = 16;

    @RequestMapping(value={"/v2/search.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json"})
    public ModelAndView searchJson(@RequestParam(value="query", required=true) String queryString, @RequestParam(value="qf", required=false) String[] refinements, @RequestParam(value="reusability", required=false) String[] aReusability, @RequestParam(value="profile", required=false, defaultValue="standard") String profile, @RequestParam(value="start", required=false, defaultValue="1") int start, @RequestParam(value="rows", required=false, defaultValue="12") int rows, @RequestParam(value="facet", required=false) String[] aFacet, @RequestParam(value="wskey", required=false) String wskey, @RequestParam(value="callback", required=false) String callback, HttpServletRequest request, HttpServletResponse response) {
        String[] _qf = (String[])request.getParameterMap().get("qf");
        if (_qf != null && _qf.length != refinements.length) {
            refinements = _qf;
        }
        boolean isFacetsRequested = this.isFacetsRequested(profile);
        Object[] reusability = StringArrayUtils.splitWebParameter((String[])aReusability);
        Object[] facets = StringArrayUtils.splitWebParameter((String[])aFacet);
        boolean isDefaultFacetsRequested = this.isDefaultFacetsRequested(profile, (String[])facets);
        facets = SearchController.limitFacets((String[])facets, (boolean)isDefaultFacetsRequested);
        boolean isDefaultOrReusabilityFacetRequested = this.isDefaultOrReusabilityFacetRequested(profile, (String[])facets);
        Map facetLimits = null;
        Map facetOffsets = null;
        if (isFacetsRequested) {
            Map parameterMap = request.getParameterMap();
            facetLimits = FacetParameterUtils.getFacetParams((String)"limit", (String[])aFacet, (Map)parameterMap, (boolean)isDefaultFacetsRequested);
            facetOffsets = FacetParameterUtils.getFacetParams((String)"offset", (String[])aFacet, (Map)parameterMap, (boolean)isDefaultFacetsRequested);
        }
        this.controllerUtils.addResponseHeaders(response);
        rows = Math.min(rows, this.configuration.getApiRowLimit());
        Map valueReplacements = new HashMap();
        if (ArrayUtils.isNotEmpty((Object[])reusability)) {
            valueReplacements = RightReusabilityCategorizer.mapValueReplacements((String[])reusability, (boolean)true);
            refinements = (String[])ArrayUtils.addAll((Object[])refinements, (Object[])valueReplacements.keySet().toArray(new String[valueReplacements.keySet().size()]));
        }
        Query query = new Query(SearchUtils.rewriteQueryFields((String)queryString)).setApiQuery(true).setRefinements(refinements).setPageSize(rows).setStart(start - 1).setParameter("facet.mincount", "1").setParameter("fl", "*,score").setAllowSpellcheck(false).setAllowFacets(false);
        if (ArrayUtils.isNotEmpty((Object[])facets)) {
            query.setFacets((String[])facets);
            if (facetLimits != null && !facetLimits.isEmpty()) {
                for (Map.Entry entry : facetLimits.entrySet()) {
                    query.setParameter((String)entry.getKey(), String.valueOf(entry.getValue()));
                }
            }
            if (facetOffsets != null && !facetOffsets.isEmpty()) {
                for (Map.Entry entry : facetOffsets.entrySet()) {
                    query.setParameter((String)entry.getKey(), String.valueOf(entry.getValue()));
                }
            }
        }
        query.setValueReplacements(valueReplacements);
        if (isDefaultOrReusabilityFacetRequested) {
            query.setFacetQueries(RightReusabilityCategorizer.getQueryFacets());
        }
        if (StringUtils.containsIgnoreCase((String)profile, (String)"portal") || StringUtils.containsIgnoreCase((String)profile, (String)"spelling")) {
            query.setAllowSpellcheck(true);
        }
        if (isFacetsRequested) {
            query.setAllowFacets(true);
            if (!query.hasParameter("f.DATA_PROVIDER.facet.limit") && (ArrayUtils.contains((Object[])facets, (Object)"DATA_PROVIDER") || ArrayUtils.contains((Object[])facets, (Object)"DEFAULT"))) {
                query.setParameter("f.DATA_PROVIDER.facet.limit", "3000");
            }
        }
        LimitResponse limitResponse = null;
        try {
            limitResponse = this.controllerUtils.checkLimit(wskey, request.getRequestURL().toString(), "search.json", RecordType.SEARCH, profile);
        }
        catch (ApiLimitException e) {
            response.setStatus(e.getHttpStatus());
            return JsonUtils.toJson((Object)new ApiError(e), (String)callback);
        }
        Class clazz = this.selectBean(profile);
        try {
            SearchResults result = this.createResults(wskey, profile, query, clazz, ((Long)limitResponse.getApiKey().getUser().getId()).longValue());
            result.requestNumber = limitResponse.getRequestNumber();
            if (StringUtils.containsIgnoreCase((String)profile, (String)"params")) {
                result.addParams(RequestUtils.getParameterMap((HttpServletRequest)request), new String[]{"wskey"});
                result.addParam("profile", (Object)profile);
                result.addParam("start", (Object)start);
                result.addParam("rows", (Object)rows);
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("got response " + result.items.size());
            }
            return JsonUtils.toJson((Object)result, (String)callback);
        }
        catch (SolrTypeException e) {
            this.log.error(wskey + " [search.json] ", (Throwable)e);
            response.setStatus(500);
            return JsonUtils.toJson((Object)new ApiError(wskey, "search.json", e.getMessage()), (String)callback);
        }
        catch (Exception e) {
            this.log.error(wskey + " [search.json] " + e.getClass().getSimpleName(), (Throwable)e);
            response.setStatus(500);
            return JsonUtils.toJson((Object)new ApiError(wskey, "search.json", e.getMessage()), (String)callback);
        }
    }

    private Class<? extends IdBean> selectBean(String profile) {
        Class clazz = StringUtils.containsIgnoreCase((String)profile, (String)"minimal") ? BriefBean.class : (StringUtils.containsIgnoreCase((String)profile, (String)"rich") ? RichBean.class : ApiBean.class);
        return clazz;
    }

    public static String[] limitFacets(String[] facets, boolean isDefaultFacetsRequested) {
        List<String> requestedFacets = Arrays.asList(facets);
        ArrayList<String> allowedFacets = new ArrayList<String>();
        int count = 0;
        if (isDefaultFacetsRequested && !requestedFacets.contains("DEFAULT")) {
            count = Facet.values().length;
        }
        for (String facet : requestedFacets) {
            int increment = 1;
            if (StringUtils.equals((String)facet, (String)"DEFAULT")) {
                increment = Facet.values().length;
            }
            if (count + increment > 16) break;
            allowedFacets.add(facet);
            count += increment;
        }
        return allowedFacets.toArray(new String[allowedFacets.size()]);
    }

    @RequestMapping(value={"/v2/suggestions.json"}, produces={"application/json"})
    public ModelAndView suggestionsJson(@RequestParam(value="query", required=true) String query, @RequestParam(value="rows", required=false, defaultValue="10") int count, @RequestParam(value="phrases", required=false, defaultValue="false") boolean phrases, @RequestParam(value="callback", required=false) String callback, HttpServletResponse response) {
        this.controllerUtils.addResponseHeaders(response);
        if (this.log.isInfoEnabled()) {
            this.log.info("phrases: " + phrases);
        }
        Suggestions apiResponse = new Suggestions(null, "suggestions.json");
        try {
            apiResponse.items = this.searchService.suggestions(query, count);
            apiResponse.itemsCount = apiResponse.items.size();
        }
        catch (SolrTypeException e) {
            return JsonUtils.toJson((Object)new ApiError(null, "suggestions.json", e.getMessage()), (String)callback);
        }
        return JsonUtils.toJson((Object)apiResponse, (String)callback);
    }

    private <T extends IdBean> SearchResults<T> createResults(String apiKey, String profile, Query query, Class<T> clazz, long uid) throws SolrTypeException {
        List allQueryFacetsMap;
        SearchResults response = new SearchResults(apiKey, "search.json");
        ResultSet resultSet = this.searchService.search(clazz, query);
        response.totalResults = resultSet.getResultSize();
        response.itemsCount = resultSet.getResults().size();
        response.items = resultSet.getResults();
        ArrayList<Object> beans = new ArrayList<Object>();
        for (IdBean b : resultSet.getResults()) {
            Boolean optOut;
            if (b instanceof RichBean) {
                optOut = ((RichBean)b).getPreviewNoDistribute();
                beans.add(new RichView((RichBean)b, profile, apiKey, uid, optOut.booleanValue()));
                continue;
            }
            if (b instanceof ApiBean) {
                optOut = ((ApiBean)b).getPreviewNoDistribute();
                beans.add(new ApiView((ApiBean)b, profile, apiKey, uid, optOut.booleanValue()));
                continue;
            }
            if (!(b instanceof BriefBean)) continue;
            optOut = ((BriefBean)b).getPreviewNoDistribute();
            beans.add(new BriefView((BriefBean)b, profile, apiKey, uid, optOut.booleanValue()));
        }
        List facetFields = resultSet.getFacetFields();
        if (resultSet.getQueryFacets() != null && (allQueryFacetsMap = SearchUtils.extractQueryFacets((Map)resultSet.getQueryFacets())) != null && !allQueryFacetsMap.isEmpty()) {
            facetFields.addAll(allQueryFacetsMap);
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("beans: " + beans.size());
        }
        response.items = beans;
        if (StringUtils.containsIgnoreCase((String)profile, (String)"facets") || StringUtils.containsIgnoreCase((String)profile, (String)"portal")) {
            response.facets = ModelUtils.conventFacetList((List)resultSet.getFacetFields());
        }
        if (StringUtils.containsIgnoreCase((String)profile, (String)"breadcrumb") || StringUtils.containsIgnoreCase((String)profile, (String)"portal")) {
            response.breadCrumbs = NavigationUtils.createBreadCrumbList((Query)query);
        }
        if (StringUtils.containsIgnoreCase((String)profile, (String)"spelling") || StringUtils.containsIgnoreCase((String)profile, (String)"portal")) {
            response.spellcheck = ModelUtils.convertSpellCheck((SpellCheckResponse)resultSet.getSpellcheck());
        }
        return response;
    }

    @RequestMapping(value={"/v2/search.kml"}, produces={"application/vnd.google-earth.kml+xml", "*/*"})
    @ResponseBody
    public KmlResponse searchKml(@RequestParam(value="query", required=true) String queryString, @RequestParam(value="qf", required=false) String[] refinements, @RequestParam(value="start", required=false, defaultValue="1") int start, @RequestParam(value="wskey", required=true) String wskey, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] _qf = (String[])request.getParameterMap().get("qf");
        if (_qf != null && _qf.length != refinements.length) {
            refinements = _qf;
        }
        try {
            ApiKey apiKey = (ApiKey)this.apiService.findByID((Serializable)((Object)wskey));
            this.apiService.checkReachedLimit(apiKey);
        }
        catch (DatabaseException e) {
            response.setStatus(401);
            throw new Exception(e);
        }
        catch (LimitReachedException e) {
            response.setStatus(429);
            throw new Exception(e);
        }
        KmlResponse kmlResponse = new KmlResponse();
        Query query = new Query(SearchUtils.rewriteQueryFields((String)queryString)).setRefinements(refinements).setApiQuery(true).setAllowSpellcheck(false).setAllowFacets(false);
        query.setRefinements(new String[]{"pl_wgs84_pos_lat_long:[* TO *]"});
        try {
            ResultSet resultSet = this.searchService.search(BriefBean.class, query);
            kmlResponse.document.extendedData.totalResults.value = Long.toString(resultSet.getResultSize());
            kmlResponse.document.extendedData.startIndex.value = Integer.toString(start);
            kmlResponse.setItems(resultSet.getResults());
        }
        catch (SolrTypeException e) {
            response.setStatus(429);
            throw new Exception(e);
        }
        return kmlResponse;
    }

    @RequestMapping(value={"/v2/opensearch.rss"}, produces={"application/xml", "*/*"})
    @ResponseBody
    public RssResponse openSearchRss(@RequestParam(value="searchTerms", required=true) String queryString, @RequestParam(value="startIndex", required=false, defaultValue="1") int start, @RequestParam(value="count", required=false, defaultValue="12") int count) {
        RssResponse rss = new RssResponse();
        Channel channel = rss.channel;
        channel.startIndex.value = start;
        channel.itemsPerPage.value = count;
        channel.query.searchTerms = queryString;
        channel.query.startPage = start;
        try {
            Query query = new Query(SearchUtils.rewriteQueryFields((String)queryString)).setApiQuery(true).setPageSize(count).setStart(start - 1).setAllowFacets(false).setAllowSpellcheck(false);
            ResultSet resultSet = this.searchService.search(BriefBean.class, query);
            channel.totalResults.value = resultSet.getResultSize();
            for (BriefBean bean : resultSet.getResults()) {
                Item item = new Item();
                item.guid = this.urlService.getPortalRecord(false, bean.getId()).toString();
                item.title = this.getTitle(bean);
                item.description = this.getDescription(bean);
                item.link = item.guid;
                channel.items.add(item);
            }
        }
        catch (SolrTypeException e) {
            channel.totalResults.value = 0L;
            Item item = new Item();
            item.title = "Error";
            item.description = e.getMessage();
            channel.items.add(item);
        }
        return rss;
    }

    @RequestMapping(value={"/v2/search.rss"}, produces={"application/xml", "*/*"})
    public ModelAndView fieldTripRss(@RequestParam(value="query", required=true) String queryTerms, @RequestParam(value="offset", required=false, defaultValue="1") int offset, @RequestParam(value="limit", required=false, defaultValue="12") int limit, @RequestParam(value="profile", required=false, defaultValue="FieldTrip") String profile, @RequestParam(value="language", required=false) String reqLanguage, HttpServletRequest request, HttpServletResponse response) {
        this.controllerUtils.addResponseHeaders(response);
        String collectionID = this.getIdFromQueryTerms(queryTerms);
        Map gftChannelAttributes = this.configuration.getGftChannelAttributes(collectionID);
        FieldTripResponse rss = new FieldTripResponse();
        FieldTripChannel channel = rss.channel;
        if (gftChannelAttributes.isEmpty() || gftChannelAttributes.size() < 5) {
            this.log.error("error: one or more attributes are not defined in europeana.properties for [INSERT COLLECTION ID HERE]");
            channel.title = "error retrieving attributes";
            channel.description = "error retrieving attributes";
            channel.language = "--";
            channel.link = "error retrieving attributes";
            channel.image = null;
        } else {
            String string = gftChannelAttributes.get(reqLanguage + "_title") == null || ((String)gftChannelAttributes.get(reqLanguage + "_title")).equalsIgnoreCase("") ? (gftChannelAttributes.get("title") == null || ((String)gftChannelAttributes.get("title")).equalsIgnoreCase("") ? "no title defined" : (String)gftChannelAttributes.get("title")) : (channel.title = (String)gftChannelAttributes.get(reqLanguage + "_title"));
            channel.description = gftChannelAttributes.get(reqLanguage + "_description") == null || ((String)gftChannelAttributes.get(reqLanguage + "_description")).equalsIgnoreCase("") ? (gftChannelAttributes.get("description") == null || ((String)gftChannelAttributes.get("description")).equalsIgnoreCase("") ? "no description defined" : (String)gftChannelAttributes.get("description")) : (String)gftChannelAttributes.get(reqLanguage + "_description");
            channel.language = gftChannelAttributes.get("language") == null || ((String)gftChannelAttributes.get("language")).equalsIgnoreCase("") ? "--" : (String)gftChannelAttributes.get("language");
            channel.link = gftChannelAttributes.get("link") == null || ((String)gftChannelAttributes.get("link")).equalsIgnoreCase("") ? "no link defined" : (String)gftChannelAttributes.get("link");
            FieldTripImage fieldTripImage = channel.image = gftChannelAttributes.get("image") == null || ((String)gftChannelAttributes.get("image")).equalsIgnoreCase("") ? null : new FieldTripImage((String)gftChannelAttributes.get("image"));
        }
        if (StringUtils.equals((String)profile, (String)"FieldTrip")) {
            ++offset;
        }
        FieldTripUtils fieldTripUtils = new FieldTripUtils(this.urlService);
        try {
            Query query = new Query(SearchUtils.rewriteQueryFields((String)queryTerms)).setApiQuery(true).setPageSize(limit).setStart(offset - 1).setAllowFacets(false).setAllowSpellcheck(false);
            ResultSet resultSet = this.searchService.search(RichBean.class, query);
            for (RichBean bean : resultSet.getResults()) {
                if (reqLanguage != null && !this.getDcLanguage((BriefBean)bean).equalsIgnoreCase(reqLanguage)) continue;
                channel.items.add(fieldTripUtils.createItem(bean, this.getTranslatedEdmIsShownAtLabel((BriefBean)bean, reqLanguage == null ? channel.language : reqLanguage)));
            }
        }
        catch (SolrTypeException e) {
            this.log.error("error: " + e.getLocalizedMessage());
            FieldTripItem item = new FieldTripItem();
            item.title = "Error";
            item.description = e.getMessage();
            channel.items.add(item);
        }
        String xml = fieldTripUtils.cleanRss(this.xmlUtils.toString((Object)rss));
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("rss", xml);
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/xml");
        return new ModelAndView("rss", model);
    }

    private String getTitle(BriefBean bean) {
        if (!ArrayUtils.isEmpty((Object[])bean.getTitle())) {
            for (String title : bean.getTitle()) {
                if (StringUtils.isBlank((String)title)) continue;
                return title;
            }
        }
        return bean.getDataProvider()[0] + " " + bean.getId();
    }

    private String getDescription(BriefBean bean) {
        StringBuilder sb = new StringBuilder();
        if (bean.getDcCreator() != null && bean.getDcCreator().length > 0 && StringUtils.isNotBlank((String)bean.getDcCreator()[0])) {
            sb.append(bean.getDcCreator()[0]);
        }
        if (bean.getYear() != null && bean.getYear().length > 0) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(StringUtils.join((Object[])bean.getYear(), (String)", "));
        }
        if (!ArrayUtils.isEmpty((Object[])bean.getProvider())) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(StringUtils.join((Object[])bean.getProvider(), (String)", "));
        }
        return sb.toString();
    }

    private String getDcLanguage(BriefBean bean) {
        if (bean.getDcLanguage() != null && bean.getDcLanguage().length > 0 && StringUtils.isNotBlank((String)bean.getDcLanguage()[0])) {
            return bean.getDcLanguage()[0];
        }
        return "";
    }

    private boolean isFacetsRequested(String profile) {
        return StringUtils.containsIgnoreCase((String)profile, (String)"portal") || StringUtils.containsIgnoreCase((String)profile, (String)"facets");
    }

    private boolean isDefaultFacetsRequested(String profile, String[] facets) {
        return StringUtils.containsIgnoreCase((String)profile, (String)"portal") || StringUtils.containsIgnoreCase((String)profile, (String)"facets") && (ArrayUtils.isEmpty((Object[])facets) || ArrayUtils.contains((Object[])facets, (Object)"DEFAULT"));
    }

    private boolean isDefaultOrReusabilityFacetRequested(String profile, String[] facets) {
        return StringUtils.containsIgnoreCase((String)profile, (String)"portal") || StringUtils.containsIgnoreCase((String)profile, (String)"facets") && (ArrayUtils.isEmpty((Object[])facets) || ArrayUtils.contains((Object[])facets, (Object)"DEFAULT") || ArrayUtils.contains((Object[])facets, (Object)"REUSABILITY"));
    }

    private String getTranslatedEdmIsShownAtLabel(BriefBean bean, String language) {
        String translatedEdmIsShownAtLabel = "";
        translatedEdmIsShownAtLabel = this.getEdmIsShownAtLabelTranslation(this.getBeanLocale(bean.getLanguage()));
        if (StringUtils.isBlank((String)translatedEdmIsShownAtLabel)) {
            this.log.error("error: 'edmIsShownAtLabel translation for language code '" + this.getBeanLocale(bean.getLanguage()) + "' unavailable");
            this.log.error("falling back on channel language ('" + language + "')");
            translatedEdmIsShownAtLabel = this.getEdmIsShownAtLabelTranslation(language);
            if (StringUtils.isBlank((String)translatedEdmIsShownAtLabel)) {
                this.log.error("error: 'fallback edmIsShownAtLabel translation for channel language code '" + language + "' unavailable");
                this.log.error("falling back on default English translation ...");
                translatedEdmIsShownAtLabel = this.getEdmIsShownAtLabelTranslation("en");
                if (StringUtils.isBlank((String)translatedEdmIsShownAtLabel)) {
                    this.log.error("Default English translation unavailable.");
                    return "error: 'edmIsShownAtLabel' english fallback translation unavailable";
                }
            }
        }
        return translatedEdmIsShownAtLabel;
    }

    private String getEdmIsShownAtLabelTranslation(String language) {
        return this.messageSource.getMessage("edm_isShownAtLabel_t", null, new Locale(language));
    }

    private String getEdmIsShownAtLabelTranslation(Locale locale) {
        return this.messageSource.getMessage("edm_isShownAtLabel_t", null, locale);
    }

    private Locale getBeanLocale(String[] beanLanguage) {
        if (!ArrayUtils.isEmpty((Object[])beanLanguage) && !StringUtils.isBlank((String)beanLanguage[0]) && beanLanguage[0].length() == 2) {
            return new Locale(beanLanguage[0]);
        }
        this.log.error("error: language code unavailable or malformed (e.g. not two characters long)");
        return new Locale("en");
    }

    private String getIdFromQueryTerms(String queryTerms) {
        return queryTerms.substring(queryTerms.indexOf(":"), queryTerms.indexOf("*")).replaceAll("\\D+", "");
    }
}

