/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.service;

import com.google.code.morphia.Datastore;
import com.google.code.morphia.Morphia;
import com.google.code.morphia.query.Query;
import com.google.code.morphia.query.UpdateOperations;
import com.google.common.collect.Lists;
import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import eu.europeana.api2.v2.model.json.sugarcrm.DataSet;
import eu.europeana.api2.v2.model.json.sugarcrm.Provider;
import eu.europeana.api2.v2.model.json.sugarcrm.SugarCRMSearchResults;
import eu.europeana.api2.v2.service.SugarCRMCache;
import eu.europeana.corelib.logging.Log;
import eu.europeana.corelib.logging.Logger;
import eu.europeana.uim.sugarcrmclient.enums.EuropeanaDatasets;
import eu.europeana.uim.sugarcrmclient.enums.EuropeanaRetrievableField;
import eu.europeana.uim.sugarcrmclient.enums.EuropeanaUpdatableField;
import eu.europeana.uim.sugarcrmclient.internal.helpers.ClientUtils;
import eu.europeana.uim.sugarcrmclient.jibxbindings.GetEntryList;
import eu.europeana.uim.sugarcrmclient.jibxbindings.GetEntryListResponse;
import eu.europeana.uim.sugarcrmclient.jibxbindings.GetRelationships;
import eu.europeana.uim.sugarcrmclient.jibxbindings.GetRelationshipsResponse;
import eu.europeana.uim.sugarcrmclient.jibxbindings.SelectFields;
import eu.europeana.uim.sugarcrmclient.ws.SugarWsClient;
import eu.europeana.uim.sugarcrmclient.ws.exceptions.JIXBQueryResultException;
import java.io.StringWriter;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;

public class SugarCRMImporter {
    @Log
    private Logger log;
    @Resource(name="api_db_mongo_cache")
    private Mongo mongo;
    @Resource
    private SugarWsClient sugarwsClient;
    @Resource
    private SugarCRMCache sugarCRMCache;
    @Resource(name="corelib_db_morphia_datastore_sugarcrmcache")
    private Datastore datastore;
    private static final String CACHEDB = "sugarcrmCache";
    private static final String DATA_AGGREGATOR_QUERY = "(accounts_cstm.agg_status_c LIKE '%D')";
    private static final String CONTENT_PROVIDER_QUERY = "(accounts_cstm.agg_status_c LIKE '%P')";
    private static final String ALL_PROVIDER_QUERY = String.format("(%s OR %s)", "(accounts_cstm.agg_status_c LIKE '%D')", "(accounts_cstm.agg_status_c LIKE '%P')");

    public void populateRepositoryFromScratch() throws JIXBQueryResultException {
        SugarCRMSearchResults providers = this.sugarCRMCache.getProviders();
        if (providers.items.isEmpty()) {
            GetEntryListResponse response;
            ArrayList exportedProviders = Lists.newArrayListWithExpectedSize((int)1000);
            GetEntryList providerRequest = new GetEntryList();
            SelectFields fields = new SelectFields();
            providerRequest.setSelectFields(fields);
            providerRequest.setModuleName(EuropeanaDatasets.ORGANIZATIONS.getSysId());
            providerRequest.setSession(this.sugarwsClient.getSessionID());
            providerRequest.setOrderBy(EuropeanaRetrievableField.DATE_ENTERED.getFieldId());
            providerRequest.setMaxResults(100);
            providerRequest.setOffset(0);
            providerRequest.setQuery(DATA_AGGREGATOR_QUERY);
            int offset = 0;
            while ((response = this.sugarwsClient.getEntryList(providerRequest)).getReturn().getEntryList().getArray() != null) {
                exportedProviders.addAll((ArrayList)response.getReturn().getEntryList().getArray().getAnyList());
                offset = response.getReturn().getNextOffset();
                providerRequest.setOffset(offset);
            }
            this.log.info(String.format("Saving %d providers", exportedProviders.size()));
            int i = 1;
            for (Element exportedProvider : exportedProviders) {
                this.log.info(String.format("Processing provider %d/%d", i++, exportedProviders.size()));
                Provider provider = new Provider();
                this.populateProviderFromDOMElement(provider, exportedProvider);
                this.datastore.save((Object)provider);
                this.extractDatasetsFromProvider(exportedProvider);
            }
            this.log.info("All providers are saved.");
        }
    }

    private SugarCRMSearchResults<Provider> retrieveProviders(String ... query) throws JIXBQueryResultException {
        GetEntryList request = new GetEntryList();
        SugarCRMSearchResults results = new SugarCRMSearchResults("", "");
        results.items = new ArrayList();
        request.setSelectFields(new SelectFields());
        request.setModuleName(EuropeanaDatasets.ORGANIZATIONS.getSysId());
        request.setSession(this.sugarwsClient.getSessionID());
        request.setOrderBy(EuropeanaRetrievableField.DATE_ENTERED.getFieldId());
        request.setMaxResults(200);
        request.setOffset(0);
        if (query.length == 0) {
            request.setQuery(DATA_AGGREGATOR_QUERY);
        } else {
            StringWriter querywrt = new StringWriter();
            if (query.length == 1) {
                querywrt.append("(");
                querywrt.append(query[0]);
                querywrt.append(")");
                request.setQuery(querywrt.toString());
            } else {
                querywrt.append("(");
                for (int i = 0; i < query.length; ++i) {
                    querywrt.append("(");
                    querywrt.append(query[i]);
                    querywrt.append(")");
                    if (i >= query.length - 1) continue;
                    querywrt.append(" and ");
                }
                querywrt.append(")");
                request.setQuery(querywrt.toString());
            }
        }
        boolean getNext = true;
        while (getNext) {
            GetEntryListResponse response = this.sugarwsClient.getEntryList(request);
            ArrayList xmlElements = null;
            xmlElements = response.getReturn().getEntryList().getArray() != null ? (ArrayList)response.getReturn().getEntryList().getArray().getAnyList() : new ArrayList();
            this.log.info(String.format("Retrieved %d providers", xmlElements.size()));
            for (Element xmlElement : xmlElements) {
                Provider provider = new Provider();
                this.populateProviderFromDOMElement(provider, xmlElement);
                results.items.add(provider);
            }
            if (response.getReturn().getResultCount() > 0 && response.getReturn().getNextOffset() > 0) {
                request.setOffset(response.getReturn().getNextOffset().intValue());
                continue;
            }
            getNext = false;
        }
        return results;
    }

    private void extractDatasetsFromProvider(Element exportedProvider) throws JIXBQueryResultException {
        String sugarCRMProviderID = ClientUtils.extractFromElement((String)"id", (Element)exportedProvider);
        String uimProviderID = ClientUtils.extractFromElement((String)"name_id_c", (Element)exportedProvider);
        GetRelationships request = new GetRelationships();
        request.setDeleted(0);
        request.setModuleId(sugarCRMProviderID);
        request.setModuleName("Accounts");
        request.setRelatedModule("Opportunities");
        request.setRelatedModuleQuery("");
        request.setSession(this.sugarwsClient.getSessionID());
        GetRelationshipsResponse resp = this.sugarwsClient.getRelationships(request);
        if (resp.getReturn().getIds().getArray() != null) {
            List el = resp.getReturn().getIds().getArray().getAnyList();
            for (Element elm : el) {
                String datasetId = this.extractDatasetId(elm.getTextContent());
                if (!StringUtils.isNotBlank((String)datasetId)) continue;
                String query = "opportunities.id LIKE '" + datasetId + "%'";
                SugarCRMSearchResults datasets = this.retrieveDataset(query, uimProviderID);
                if (datasets.items.size() == 0) continue;
                for (DataSet dataSet : datasets.items) {
                    this.datastore.save((Object)dataSet);
                }
            }
        }
    }

    public SugarCRMSearchResults<Provider> pollProviders() throws JIXBQueryResultException {
        this.log.info("pollProviders()");
        String q1 = "accounts.date_modified > " + this.getLastProviderModification();
        String q2 = "accounts_cstm.agg_status_c LIKE '%D'";
        this.log.info("query: " + q1);
        SugarCRMSearchResults retrievedProviders = this.retrieveProviders(new String[]{q1, q2});
        this.log.info(String.format("retrievedProviders: %d", retrievedProviders.items.size()));
        for (Provider provider : retrievedProviders.items) {
            this.log.info(String.format("Provider: %s was updated by the scheduler...", provider.identifier));
            this.saveupdateProvider2Cache(provider);
        }
        return retrievedProviders;
    }

    public SugarCRMSearchResults<DataSet> pollCollections() throws JIXBQueryResultException {
        String query = "opportunities.date_modified > " + this.getLastDatasetModification();
        this.log.info("pollCollections(); query: " + query);
        SugarCRMSearchResults retrievedDatasets = this.retrieveDataset(query, null);
        this.log.info(String.format("retrievedDatasets: %d", retrievedDatasets.items.size()));
        for (DataSet dataset : retrievedDatasets.items) {
            this.log.info(String.format("Dataset: %s was updated by the scheduler at %s", dataset.identifier, dataset.savedsugarcrmFields.get("date_modified")));
            this.saveupdateCollection2Cache(dataset);
        }
        return retrievedDatasets;
    }

    public String getLastProviderModification() {
        Query query = this.datastore.find(Provider.class);
        query.field("savedsugarcrmFields.date_modified");
        query.order("-savedsugarcrmFields.date_modified");
        query.limit(1);
        List providers = query.asList();
        if (providers != null && providers.size() > 0) {
            return '\"' + (String)((Provider)providers.get((int)0)).savedsugarcrmFields.get(EuropeanaRetrievableField.DATE_MODIFIED.getFieldId()) + '\"';
        }
        return null;
    }

    public String getLastDatasetModification() {
        Query query = this.datastore.find(DataSet.class);
        query.field("savedsugarcrmFields.date_modified");
        query.order("-savedsugarcrmFields.date_modified");
        query.limit(1);
        List dataSets = query.asList();
        if (dataSets != null && dataSets.size() > 0) {
            return '\"' + (String)((DataSet)dataSets.get((int)0)).savedsugarcrmFields.get(EuropeanaRetrievableField.DATE_MODIFIED.getFieldId()) + '\"';
        }
        return null;
    }

    private SugarCRMSearchResults<DataSet> retrieveDataset(String query, String providerID) throws JIXBQueryResultException {
        SugarCRMSearchResults results = new SugarCRMSearchResults("", "");
        results.items = new ArrayList();
        GetEntryList request = new GetEntryList();
        SelectFields fields = new SelectFields();
        request.setSelectFields(fields);
        request.setModuleName(EuropeanaDatasets.DATASETS.getSysId());
        request.setSession(this.sugarwsClient.getSessionID());
        request.setOrderBy(EuropeanaRetrievableField.DATE_ENTERED.getFieldId());
        request.setMaxResults(100);
        request.setOffset(0);
        request.setQuery(query);
        boolean getNext = true;
        while (getNext) {
            GetEntryListResponse response = this.sugarwsClient.getEntryList(request);
            ArrayList xmlElements = null;
            xmlElements = response.getReturn().getEntryList().getArray() != null ? (ArrayList)response.getReturn().getEntryList().getArray().getAnyList() : new ArrayList();
            for (Element xmlElement : xmlElements) {
                DataSet dataSet = new DataSet();
                this.populateDatasetFromDOMElement(dataSet, xmlElement, providerID);
                results.items.add(dataSet);
            }
            if (response.getReturn().getResultCount() > 0 && response.getReturn().getNextOffset() > 0) {
                request.setOffset(response.getReturn().getNextOffset().intValue());
                continue;
            }
            getNext = false;
        }
        return results;
    }

    private void populateDatasetFromDOMElement(DataSet dataSet, Element xmlElement, String providerID) {
        String numberOfDeletedRecords;
        String identifier;
        dataSet.identifier = identifier = ClientUtils.extractFromElement((String)EuropeanaRetrievableField.NAME.getFieldId(), (Element)xmlElement).split("_")[0];
        dataSet.provIdentifier = providerID;
        dataSet.status = ClientUtils.translateStatus((String)ClientUtils.extractFromElement((String)EuropeanaUpdatableField.STATUS.getFieldId(), (Element)xmlElement));
        dataSet.edmDatasetName = ClientUtils.extractFromElement((String)EuropeanaRetrievableField.NAME.getFieldId(), (Element)xmlElement);
        String publishedRecordsStr = ClientUtils.extractFromElement((String)EuropeanaUpdatableField.TOTAL_INGESTED.getFieldId(), (Element)xmlElement);
        if (StringUtils.isNotBlank((String)publishedRecordsStr)) {
            try {
                dataSet.publishedRecords = Long.parseLong(publishedRecordsStr);
            }
            catch (NumberFormatException e) {
                dataSet.publishedRecords = 0L;
            }
        } else {
            dataSet.publishedRecords = 0L;
        }
        if (StringUtils.isNotBlank((String)(numberOfDeletedRecords = ClientUtils.extractFromElement((String)EuropeanaUpdatableField.DELETED_RECORDS.getFieldId(), (Element)xmlElement)))) {
            try {
                dataSet.deletedRecords = Long.parseLong(numberOfDeletedRecords);
            }
            catch (NumberFormatException e) {
                dataSet.deletedRecords = 0L;
            }
        } else {
            dataSet.deletedRecords = 0L;
        }
        dataSet.savedsugarcrmFields = ClientUtils.mapFromElement((Element)xmlElement);
    }

    private void populateProviderFromDOMElement(Provider provider, Element xmlElement) {
        provider.identifier = ClientUtils.extractFromElement((String)"name_id_c", (Element)xmlElement);
        provider.country = ClientUtils.extractFromElement((String)"country_c", (Element)xmlElement);
        provider.savedsugarcrmFields = ClientUtils.mapFromElement((Element)xmlElement);
    }

    private String extractDatasetId(String rawId) {
        if (StringUtils.isBlank((String)rawId)) {
            return null;
        }
        String[] datasetIdParts = rawId.split("-");
        StringBuilder datasetId = new StringBuilder();
        for (int i = 0; i < 5; ++i) {
            if (i < 4) {
                datasetId.append(datasetIdParts[i]);
                datasetId.append("-");
                continue;
            }
            datasetId.append(datasetIdParts[i].substring(0, 11));
        }
        return datasetId.toString();
    }

    public void saveupdateCollection2Cache(DataSet dataSet) {
        UpdateOperations operations = this.datastore.createUpdateOperations(DataSet.class).disableValidation().set("savedsugarcrmFields", (Object)dataSet.savedsugarcrmFields);
        Query query = (Query)this.datastore.createQuery(DataSet.class).field("identifier").equal((Object)dataSet.identifier);
        this.datastore.updateFirst(query, operations, true);
    }

    public void saveupdateProvider2Cache(Provider provider) {
        UpdateOperations operations = this.datastore.createUpdateOperations(Provider.class).disableValidation().set("savedsugarcrmFields", (Object)provider.savedsugarcrmFields);
        Query query = (Query)this.datastore.createQuery(Provider.class).field("identifier").equal((Object)provider.identifier);
        this.datastore.updateFirst(query, operations, true);
    }

    public void setSugarwsClient(SugarWsClient sugarwsClient) {
        this.sugarwsClient = sugarwsClient;
    }

    @PostConstruct
    public void initLocal() {
        if (this.datastore == null) {
            this.log.info("SugarCRMCache datasource is null");
            if (this.mongo == null) {
                this.log.info("SugarCRMCache mongo is null");
                try {
                    this.mongo = new Mongo();
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
                catch (MongoException e) {
                    e.printStackTrace();
                }
            }
            DB db = this.mongo.getDB(CACHEDB);
            Morphia morphia = new Morphia();
            morphia.map(new Class[]{DataSet.class}).map(new Class[]{Provider.class});
            this.datastore = morphia.createDatastore(this.mongo, CACHEDB);
        }
        this.datastore.getDB().getCollection("DataSet").ensureIndex("identifier");
        this.datastore.getDB().getCollection("DataSet").ensureIndex("savedsugarcrmFields.name");
        this.datastore.getDB().getCollection("DataSet").ensureIndex("savedsugarcrmFields.country_c");
        this.datastore.getDB().getCollection("DataSet").ensureIndex("savedsugarcrmFields.sales_stage");
        this.datastore.getDB().getCollection("Provider").ensureIndex("identifier");
    }
}

