/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller.mydata;

import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.v2.model.json.UserModification;
import eu.europeana.api2.v2.model.json.UserResults;
import eu.europeana.api2.v2.model.json.user.Search;
import eu.europeana.api2.v2.web.controller.abstracts.AbstractUserController;
import eu.europeana.corelib.db.exception.DatabaseException;
import eu.europeana.corelib.definitions.db.entity.relational.ApiKey;
import eu.europeana.corelib.definitions.db.entity.relational.SavedSearch;
import eu.europeana.corelib.definitions.db.entity.relational.User;
import eu.europeana.corelib.web.utils.UrlBuilder;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class MyDataSearchController
extends AbstractUserController {
    @RequestMapping(value={"/v2/mydata/savedsearch.json"}, params={"!action"}, produces={"application/json"}, method={RequestMethod.GET})
    public ModelAndView defaultAction(@RequestParam(value="callback", required=false) String callback, Principal principal) {
        return this.list(callback, principal);
    }

    @RequestMapping(value={"/v2/mydata/savedsearch.json"}, params={"action=LIST"}, produces={"application/json"})
    public ModelAndView list(@RequestParam(value="callback", required=false) String callback, Principal principal) {
        UserResults response = new UserResults(principal.getName(), "/v2/mydata/search.json");
        try {
            ApiKey apiKey = (ApiKey)this.apiKeyService.findByID((Serializable)((Object)principal.getName()));
            if (apiKey != null) {
                User user = apiKey.getUser();
                response.items = new ArrayList();
                response.username = user.getUserName();
                response.itemsCount = user.getSavedSearches().size();
                for (SavedSearch item : user.getSavedSearches()) {
                    Search search = new Search();
                    search.id = (Long)item.getId();
                    search.query = item.getQuery();
                    search.queryString = item.getQueryString();
                    search.dateSaved = item.getDateSaved();
                    response.items.add(search);
                }
            } else {
                response.success = false;
                response.error = "Invalid credentials";
            }
        }
        catch (DatabaseException e) {
            response.success = false;
            response.error = e.getMessage();
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }

    @RequestMapping(value={"/v2/mydata/savedsearch.json"}, produces={"application/json"}, method={RequestMethod.POST, RequestMethod.PUT})
    public ModelAndView createRest(@RequestParam(value="query", required=true) String query, @RequestParam(value="qf", required=false) String[] refinements, @RequestParam(value="start", required=false, defaultValue="1") String start, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        return this.create(query, refinements, start, callback, principal);
    }

    @RequestMapping(value={"/v2/mydata/savedsearch.json"}, params={"action=CREATE"}, produces={"application/json"})
    public ModelAndView create(@RequestParam(value="query", required=true) String query, @RequestParam(value="qf", required=false) String[] refinements, @RequestParam(value="start", required=false, defaultValue="1") String start, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        UserModification response = new UserModification(principal.getName(), "/v2/mydata/tag.search?action=CREATE");
        try {
            ApiKey apiKey = (ApiKey)this.apiKeyService.findByID((Serializable)((Object)principal.getName()));
            if (apiKey != null) {
                User user = apiKey.getUser();
                UrlBuilder ub = new UrlBuilder(query);
                ub.addParam("qf", refinements, true);
                ub.addParam("start", start, true);
                String queryString = StringUtils.replace((String)ub.toString(), (String)"?", (String)"&");
                this.userService.createSavedSearch((Long)user.getId(), query, queryString);
                response.success = true;
            }
        }
        catch (DatabaseException e) {
            response.success = false;
            response.error = e.getMessage();
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }

    @RequestMapping(value={"/v2/mydata/savedsearch.json"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ModelAndView deleteRest(@RequestParam(value="searchid", required=false) Long objectId, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        return this.delete(objectId, callback, principal);
    }

    @RequestMapping(value={"/v2/mydata/savedsearch.json"}, params={"action=DELETE"}, produces={"application/json"})
    public ModelAndView delete(@RequestParam(value="searchid", required=true) Long searchId, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        UserModification response = new UserModification(principal.getName(), "/v2/mydata/search.json?action=DELETE");
        try {
            ApiKey apiKey = (ApiKey)this.apiKeyService.findByID((Serializable)((Object)principal.getName()));
            if (apiKey != null) {
                User user = apiKey.getUser();
                this.userService.removeSavedSearch((Long)user.getId(), searchId);
                response.success = true;
            }
        }
        catch (DatabaseException e) {
            response.success = false;
            response.error = e.getMessage();
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }
}

