/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller.mydata;

import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.v2.model.json.UserModification;
import eu.europeana.api2.v2.model.json.UserResults;
import eu.europeana.api2.v2.model.json.abstracts.UserObject;
import eu.europeana.api2.v2.model.json.user.SavedItem;
import eu.europeana.api2.v2.web.controller.abstracts.AbstractUserController;
import eu.europeana.corelib.db.exception.DatabaseException;
import eu.europeana.corelib.definitions.db.entity.relational.ApiKey;
import eu.europeana.corelib.definitions.db.entity.relational.User;
import eu.europeana.corelib.definitions.db.entity.relational.abstracts.EuropeanaUserObject;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class MyDataItemController
extends AbstractUserController {
    @RequestMapping(value={"/v2/mydata/saveditem.json"}, params={"!action"}, produces={"application/json"}, method={RequestMethod.GET})
    public ModelAndView defaultAction(@RequestParam(value="europeanaid", required=false) String europeanaId, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        return this.list(europeanaId, callback, principal);
    }

    @RequestMapping(value={"/v2/mydata/saveditem.json"}, params={"action=LIST"}, produces={"application/json"})
    public ModelAndView list(@RequestParam(value="europeanaid", required=false) String europeanaId, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        UserResults response = new UserResults(principal.getName(), "/v2/mydata/saveditem.json");
        try {
            ApiKey apiKey = (ApiKey)this.apiKeyService.findByID((Serializable)((Object)principal.getName()));
            if (apiKey != null) {
                HashSet<eu.europeana.corelib.definitions.db.entity.relational.SavedItem> results;
                User user = apiKey.getUser();
                response.items = new ArrayList();
                response.username = user.getUserName();
                if (StringUtils.isBlank((String)europeanaId)) {
                    results = user.getSavedItems();
                } else {
                    results = new HashSet<eu.europeana.corelib.definitions.db.entity.relational.SavedItem>();
                    results.add(this.userService.findSavedItemByEuropeanaId((Long)user.getId(), europeanaId));
                }
                response.itemsCount = results.size();
                for (eu.europeana.corelib.definitions.db.entity.relational.SavedItem item : results) {
                    SavedItem fav = new SavedItem();
                    this.copyUserObjectData(response.apikey, (UserObject)fav, (EuropeanaUserObject)item);
                    fav.author = item.getAuthor();
                    response.items.add(fav);
                }
            } else {
                response.success = false;
                response.error = "Invalid credentials";
            }
        }
        catch (DatabaseException e) {
            response.success = false;
            response.error = e.getMessage();
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }

    @RequestMapping(value={"/v2/mydata/saveditem.json"}, produces={"application/json"}, method={RequestMethod.POST, RequestMethod.PUT})
    public ModelAndView createRest(@RequestParam(value="europeanaid", required=false) String europeanaId, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        return this.create(europeanaId, callback, principal);
    }

    @RequestMapping(value={"/v2/mydata/saveditem.json"}, params={"action=CREATE"}, produces={"application/json"}, method={RequestMethod.GET})
    public ModelAndView create(@RequestParam(value="europeanaid", required=false) String europeanaId, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        UserModification response = new UserModification(principal.getName(), "/v2/mydata/saveditem.json?action=CREATE");
        try {
            ApiKey apiKey = (ApiKey)this.apiKeyService.findByID((Serializable)((Object)principal.getName()));
            if (apiKey != null) {
                User user = apiKey.getUser();
                this.userService.createSavedItem((Long)user.getId(), europeanaId);
                response.success = true;
            } else {
                response.success = false;
                response.error = "Invalid credentials";
            }
        }
        catch (DatabaseException e) {
            response.success = false;
            response.error = e.getMessage();
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }

    @RequestMapping(value={"/v2/mydata/saveditem.json"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ModelAndView deleteRest(@RequestParam(value="itemid", required=false) Long itemId, @RequestParam(value="europeanaid", required=false) String europeanaId, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        return this.delete(itemId, europeanaId, callback, principal);
    }

    @RequestMapping(value={"/v2/mydata/saveditem.json"}, params={"action=DELETE"}, produces={"application/json"}, method={RequestMethod.GET})
    public ModelAndView delete(@RequestParam(value="itemid", required=false) Long itemId, @RequestParam(value="europeanaid", required=false) String europeanaId, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        UserModification response = new UserModification(principal.getName(), "/v2/mydata/saveditem.json?action=DELETE");
        try {
            ApiKey apiKey = (ApiKey)this.apiKeyService.findByID((Serializable)((Object)principal.getName()));
            if (apiKey != null) {
                User user = apiKey.getUser();
                response.success = true;
                if (itemId != null) {
                    this.userService.removeSavedItem((Long)user.getId(), itemId);
                } else if (StringUtils.isNotBlank((String)europeanaId)) {
                    this.userService.removeSavedItem((Long)user.getId(), europeanaId);
                } else {
                    response.success = false;
                    response.error = "Invalid arguments";
                }
            }
        }
        catch (DatabaseException e) {
            response.success = false;
            response.error = e.getMessage();
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }
}

