/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import eu.europeana.corelib.db.service.ApiLogService;
import eu.europeana.corelib.db.service.OAuth2TokenService;
import eu.europeana.corelib.db.service.UserService;
import eu.europeana.corelib.definitions.db.entity.relational.ApiKey;
import eu.europeana.corelib.definitions.db.entity.relational.User;
import java.io.Serializable;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class RedirectController {
    @Resource
    private ApiLogService apiLogService;
    @Resource(name="corelib_db_userService")
    private UserService userService;
    @Resource
    private OAuth2TokenService oAuth2TokenService;

    @RequestMapping(value={"/{uid}/redirect", "/{uid}/redirect.json"}, method={RequestMethod.GET})
    public String handleRedirect(@PathVariable String uid, @RequestParam(value="profile", required=false, defaultValue="full") String profile, @RequestParam(value="shownAt", required=true) String isShownAt, @RequestParam(value="id", required=true) String id) throws Exception {
        if (StringUtils.isBlank((String)isShownAt)) {
            throw new IllegalArgumentException("Expected to find 'shownAt' in the request URL");
        }
        User user = (User)this.userService.findByID((Serializable)Long.valueOf(Long.parseLong(uid)));
        String wskey = uid;
        if (user != null) {
            wskey = (String)((Object)((ApiKey)user.getApiKeys().iterator().next()).getId());
        }
        return "redirect:" + isShownAt;
    }

    @RequestMapping(value={"/clearTokens"}, method={RequestMethod.GET})
    public String removeAll() {
        this.oAuth2TokenService.removeAll();
        return "user/cleared";
    }
}

