/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import eu.europeana.api2.model.enums.ApiLimitException;
import eu.europeana.api2.model.json.ApiError;
import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.v2.model.LimitResponse;
import eu.europeana.api2.v2.model.json.HierarchicalResult;
import eu.europeana.api2.v2.utils.ControllerUtils;
import eu.europeana.corelib.db.entity.enums.RecordType;
import eu.europeana.corelib.db.service.ApiKeyService;
import eu.europeana.corelib.db.service.ApiLogService;
import eu.europeana.corelib.logging.Log;
import eu.europeana.corelib.logging.Logger;
import eu.europeana.corelib.neo4j.entity.Neo4jBean;
import eu.europeana.corelib.neo4j.entity.Neo4jStructBean;
import eu.europeana.corelib.solr.service.SearchService;
import eu.europeana.corelib.utils.service.OptOutService;
import eu.europeana.corelib.web.service.EuropeanaUrlService;
import eu.europeana.corelib.web.utils.RequestUtils;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/v2/record"})
public class HierarchicalController {
    private static final int MAX_LIMIT = 100;
    @Log
    private Logger log;
    @Resource
    private SearchService searchService;
    @Resource
    private ApiLogService apiLogService;
    @Resource
    private ApiKeyService apiService;
    @Resource
    private OptOutService optOutService;
    @Resource
    private EuropeanaUrlService urlService;
    @Resource
    private ControllerUtils controllerUtils;

    @RequestMapping(value={"/{collectionId}/{recordId}/self.json"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView getSelf(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="profile", required=false, defaultValue="") String profile, @RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="callback", required=false) String callback, HttpServletRequest request, HttpServletResponse response) {
        return this.hierarchyTemplate(RecordType.HIERARCHY_SELF, collectionId, recordId, profile, wskey, -1, -1, callback, request, response);
    }

    @RequestMapping(value={"/{collectionId}/{recordId}/ancestor-self-siblings.json"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView getAncestorSelfSiblings(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="profile", required=false, defaultValue="") String profile, @RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="callback", required=false) String callback, HttpServletRequest request, HttpServletResponse response) {
        return this.hierarchyTemplate(RecordType.HIERARCHY_ANCESTOR_SELF_SIBLINGS, collectionId, recordId, profile, wskey, -1, -1, callback, request, response);
    }

    @RequestMapping(value={"/{collectionId}/{recordId}/children.json"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView getChildren(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="profile", required=false, defaultValue="") String profile, @RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="limit", required=true, defaultValue="10") int limit, @RequestParam(value="offset", required=true, defaultValue="0") int offset, @RequestParam(value="callback", required=false) String callback, HttpServletRequest request, HttpServletResponse response) {
        return this.hierarchyTemplate(RecordType.HIERARCHY_CHILDREN, collectionId, recordId, profile, wskey, limit, offset, callback, request, response);
    }

    @RequestMapping(value={"/{collectionId}/{recordId}/parent.json"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView getParent(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="profile", required=false, defaultValue="") String profile, @RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="limit", required=true, defaultValue="10") int limit, @RequestParam(value="offset", required=true, defaultValue="0") int offset, @RequestParam(value="callback", required=false) String callback, HttpServletRequest request, HttpServletResponse response) {
        return this.hierarchyTemplate(RecordType.HIERARCHY_PARENT, collectionId, recordId, profile, wskey, limit, offset, callback, request, response);
    }

    @RequestMapping(value={"/{collectionId}/{recordId}/preceeding-siblings.json"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView getPreceedingSiblings(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="profile", required=false, defaultValue="") String profile, @RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="limit", required=true, defaultValue="10") int limit, @RequestParam(value="offset", required=true, defaultValue="0") int offset, @RequestParam(value="callback", required=false) String callback, HttpServletRequest request, HttpServletResponse response) {
        return this.hierarchyTemplate(RecordType.HIERARCHY_PRECEEDING_SIBLINGS, collectionId, recordId, profile, wskey, limit, offset, callback, request, response);
    }

    @RequestMapping(value={"/{collectionId}/{recordId}/following-siblings.json"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView getFollowingSiblings(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="profile", required=false, defaultValue="") String profile, @RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="limit", required=true, defaultValue="10") int limit, @RequestParam(value="offset", required=true, defaultValue="0") int offset, @RequestParam(value="callback", required=false) String callback, HttpServletRequest request, HttpServletResponse response) {
        return this.hierarchyTemplate(RecordType.HIERARCHY_FOLLOWING_SIBLINGS, collectionId, recordId, profile, wskey, limit, offset, callback, request, response);
    }

    private ModelAndView hierarchyTemplate(RecordType recordType, String collectionId, String recordId, String profile, String wskey, int limit, int offset, String callback, HttpServletRequest request, HttpServletResponse response) {
        long t0 = System.currentTimeMillis();
        this.controllerUtils.addResponseHeaders(response);
        limit = Math.min(limit, 100);
        long t1 = System.currentTimeMillis();
        LimitResponse limitResponse = null;
        try {
            limitResponse = this.controllerUtils.checkLimit(wskey, request.getRequestURL().toString(), this.getAction(recordType), recordType, profile);
        }
        catch (ApiLimitException e) {
            response.setStatus(e.getHttpStatus());
            return JsonUtils.toJson((Object)new ApiError(e), (String)callback);
        }
        this.log.info("Limit: " + (System.currentTimeMillis() - t1));
        t1 = System.currentTimeMillis();
        HierarchicalResult objectResult = new HierarchicalResult(wskey, this.getAction(recordType), limitResponse.getRequestNumber());
        this.log.info("Init object: " + (System.currentTimeMillis() - t1));
        if (StringUtils.containsIgnoreCase((String)profile, (String)"params")) {
            objectResult.addParams(RequestUtils.getParameterMap((HttpServletRequest)request), new String[]{"wskey"});
            objectResult.addParam("profile", (Object)profile);
        }
        String nodeId = "/" + collectionId + "/" + recordId;
        t1 = System.currentTimeMillis();
        if (recordType.equals((Object)RecordType.HIERARCHY_CHILDREN)) {
            objectResult.children = this.searchService.getChildren(nodeId, offset, limit);
            if (objectResult.children == null) {
                objectResult.message = "This record has no children!";
                objectResult.success = false;
            } else {
                this.addChildrenCount(objectResult.children);
            }
        } else if (recordType.equals((Object)RecordType.HIERARCHY_SELF)) {
            objectResult.self = this.searchService.getHierarchicalBean(nodeId);
            if (objectResult.self == null) {
                return JsonUtils.toJson((Object)new ApiError(wskey, this.getAction(recordType), String.format("Invalid record identifier: %s!", nodeId), limitResponse.getRequestNumber()), (String)callback);
            }
            objectResult.self.setChildrenCount(Long.valueOf(this.searchService.getChildrenCount(nodeId)));
        } else if (recordType.equals((Object)RecordType.HIERARCHY_PARENT)) {
            objectResult.self = this.searchService.getHierarchicalBean(nodeId);
            if (objectResult.self != null && StringUtils.isNotBlank((String)objectResult.self.getParent())) {
                objectResult.parent = this.searchService.getHierarchicalBean(objectResult.self.getParent());
                if (objectResult.parent == null) {
                    objectResult.message = "This record has no parent!";
                    objectResult.success = false;
                } else {
                    objectResult.parent.setChildrenCount(Long.valueOf(this.searchService.getChildrenCount(objectResult.parent.getId())));
                }
            }
        } else if (recordType.equals((Object)RecordType.HIERARCHY_FOLLOWING_SIBLINGS)) {
            long tgetsiblings = System.currentTimeMillis();
            objectResult.followingSiblings = this.searchService.getFollowingSiblings(nodeId, limit);
            this.log.info("Get siblings: " + (System.currentTimeMillis() - tgetsiblings));
            if (objectResult.followingSiblings == null) {
                objectResult.message = "This record has no following siblings!";
                objectResult.success = false;
            } else {
                long tgetsiblingsCount = System.currentTimeMillis();
                this.addChildrenCount(objectResult.followingSiblings);
                this.log.info("Get siblingsCount: " + (System.currentTimeMillis() - tgetsiblingsCount));
            }
        } else if (recordType.equals((Object)RecordType.HIERARCHY_PRECEEDING_SIBLINGS)) {
            objectResult.preceedingSiblings = this.searchService.getPreceedingSiblings(nodeId, limit);
            if (objectResult.preceedingSiblings == null) {
                objectResult.message = "This record has no preceeding siblings!";
                objectResult.success = false;
            } else {
                this.addChildrenCount(objectResult.preceedingSiblings);
            }
        } else if (recordType.equals((Object)RecordType.HIERARCHY_ANCESTOR_SELF_SIBLINGS)) {
            Neo4jStructBean struct = this.searchService.getInitialStruct(nodeId);
            if (struct == null) {
                objectResult.message = "This record has no hierarchical structure!";
                objectResult.success = false;
            } else {
                if (struct.getSelf() != null) {
                    objectResult.self = struct.getSelf();
                }
                if (struct.getParents() != null) {
                    objectResult.ancestors = struct.getParents();
                }
                if (struct.getFollowingSiblings() != null) {
                    objectResult.followingSiblings = struct.getFollowingSiblings();
                }
                if (struct.getPreceedingSiblings() != null) {
                    objectResult.preceedingSiblings = struct.getPreceedingSiblings();
                }
            }
        }
        this.log.info("get main: " + (System.currentTimeMillis() - t1));
        t1 = System.currentTimeMillis();
        if (!recordType.equals((Object)RecordType.HIERARCHY_SELF)) {
            objectResult.self = this.searchService.getHierarchicalBean(nodeId);
            if (objectResult.self != null) {
                objectResult.self.setChildrenCount(Long.valueOf(this.searchService.getChildrenCount(objectResult.self.getId())));
            }
        }
        this.log.info("get self: " + (System.currentTimeMillis() - t1));
        objectResult.statsDuration = System.currentTimeMillis() - t0;
        t1 = System.currentTimeMillis();
        ModelAndView json = JsonUtils.toJson((Object)objectResult, (String)callback);
        this.log.info("toJson: " + (System.currentTimeMillis() - t1));
        return json;
    }

    private void addChildrenCount(List<Neo4jBean> beans) {
        if (beans != null && beans.size() > 0) {
            for (Neo4jBean bean : beans) {
                if (!bean.hasChildren().booleanValue()) continue;
                bean.setChildrenCount(Long.valueOf(this.searchService.getChildrenCount(bean.getId())));
            }
        }
    }

    private String getAction(RecordType recordType) {
        String action = "";
        if (recordType.equals((Object)RecordType.HIERARCHY_CHILDREN)) {
            action = "children.json";
        } else if (recordType.equals((Object)RecordType.HIERARCHY_SELF)) {
            action = "self.json";
        } else if (recordType.equals((Object)RecordType.HIERARCHY_PARENT)) {
            action = "parent.json";
        } else if (recordType.equals((Object)RecordType.HIERARCHY_FOLLOWING_SIBLINGS)) {
            action = "following-siblings.json";
        } else if (recordType.equals((Object)RecordType.HIERARCHY_PRECEEDING_SIBLINGS)) {
            action = "preceeding-siblings.json";
        } else if (recordType.equals((Object)RecordType.HIERARCHY_ANCESTOR_SELF_SIBLINGS)) {
            action = "ancestor-self-siblings.json";
        }
        return action;
    }
}

