/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import eu.europeana.api2.model.json.ApiError;
import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.v2.model.json.BasicObjectResult;
import eu.europeana.corelib.db.exception.DatabaseException;
import eu.europeana.corelib.db.exception.LimitReachedException;
import eu.europeana.corelib.db.service.ApiKeyService;
import eu.europeana.corelib.db.service.ApiLogService;
import eu.europeana.corelib.definitions.db.entity.relational.ApiKey;
import eu.europeana.corelib.definitions.solr.beans.FullBean;
import eu.europeana.corelib.logging.Log;
import eu.europeana.corelib.logging.Logger;
import eu.europeana.corelib.solr.exceptions.MongoDBException;
import eu.europeana.corelib.solr.exceptions.SolrTypeException;
import eu.europeana.corelib.solr.service.SearchService;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/v2/basicrecord"})
public class BasicObjectController {
    @Log
    private Logger log;
    @Resource
    private ApiKeyService apiKeyService;
    @Resource
    private ApiLogService apiLogService;
    @Resource
    private SearchService searchService;

    @RequestMapping(value={"/{collectionId}/{recordId}.json"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView record(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="profile", required=false, defaultValue="full") String profile, @RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="callback", required=false) String callback, HttpServletRequest request, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        String europeanaObjectId = "/" + collectionId + "/" + recordId;
        String requestUri = europeanaObjectId + ".json";
        long requestNumber = 0L;
        try {
            ApiKey apiKey = (ApiKey)this.apiKeyService.findByID((Serializable)((Object)wskey));
            if (apiKey == null) {
                return JsonUtils.toJson((Object)new ApiError(wskey, "record.json", "Unregistered user"), (String)callback);
            }
            apiKey.getUsageLimit();
            requestNumber = this.apiKeyService.checkReachedLimit(apiKey);
        }
        catch (DatabaseException e) {
            return JsonUtils.toJson((Object)new ApiError(wskey, "record.json", e.getMessage(), requestNumber), (String)callback);
        }
        catch (LimitReachedException e) {
            return JsonUtils.toJson((Object)new ApiError(wskey, "record.json", e.getMessage(), e.getRequested()), (String)callback);
        }
        BasicObjectResult objectResult = new BasicObjectResult(wskey, "record.json", requestNumber);
        objectResult.object = new HashMap();
        try {
            FullBean bean = this.searchService.findById(europeanaObjectId, true);
            if (bean == null) {
                bean = this.searchService.resolve(europeanaObjectId, true);
            }
            if (bean == null) {
                return JsonUtils.toJson((Object)new ApiError(wskey, "record.json", "Invalid record identifier: " + europeanaObjectId, requestNumber), (String)callback);
            }
            this.flattenBean(bean, objectResult.object);
        }
        catch (SolrTypeException e) {
            return JsonUtils.toJson((Object)new ApiError(wskey, "record.json", e.getMessage(), requestNumber), (String)callback);
        }
        catch (MongoDBException e) {
            return JsonUtils.toJson((Object)new ApiError(wskey, "record.json", e.getMessage(), requestNumber), (String)callback);
        }
        return JsonUtils.toJson((Object)objectResult, (String)callback);
    }

    private void flattenBean(FullBean bean, Map<String, ?> values) {
    }
}

