/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.service;

import com.google.code.morphia.Datastore;
import com.google.code.morphia.Morphia;
import com.google.code.morphia.query.Query;
import com.google.code.morphia.query.UpdateOperations;
import com.google.common.collect.Lists;
import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import eu.europeana.api2.v2.model.json.sugarcrm.DataSet;
import eu.europeana.api2.v2.model.json.sugarcrm.Provider;
import eu.europeana.api2.v2.model.json.sugarcrm.SugarCRMSearchResults;
import eu.europeana.corelib.logging.Log;
import eu.europeana.corelib.logging.Logger;
import eu.europeana.uim.sugarcrmclient.enums.EuropeanaDatasets;
import eu.europeana.uim.sugarcrmclient.enums.EuropeanaRetrievableField;
import eu.europeana.uim.sugarcrmclient.enums.EuropeanaUpdatableField;
import eu.europeana.uim.sugarcrmclient.internal.helpers.ClientUtils;
import eu.europeana.uim.sugarcrmclient.jibxbindings.GetEntryList;
import eu.europeana.uim.sugarcrmclient.jibxbindings.GetEntryListResponse;
import eu.europeana.uim.sugarcrmclient.jibxbindings.GetRelationships;
import eu.europeana.uim.sugarcrmclient.jibxbindings.GetRelationshipsResponse;
import eu.europeana.uim.sugarcrmclient.jibxbindings.SelectFields;
import eu.europeana.uim.sugarcrmclient.ws.SugarWsClient;
import eu.europeana.uim.sugarcrmclient.ws.exceptions.JIXBQueryResultException;
import java.io.StringWriter;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;

public class SugarCRMCache {
    @Log
    private Logger log;
    @Resource
    private SugarWsClient sugarwsClient;
    @Resource(name="api_db_mongo_cache")
    private Mongo mongo;
    @Resource(name="corelib_db_morphia_datastore_sugarcrmcache")
    private Datastore datastore;
    private static final String CACHEDB = "sugarcrmCache";
    private static final String DATA_AGGREGATOR_QUERY = "(accounts_cstm.agg_status_c LIKE '%D')";
    private static final String CONTENT_PROVIDER_QUERY = "(accounts_cstm.agg_status_c LIKE '%P')";
    private static final String ALL_PROVIDER_QUERY = String.format("(%s OR %s)", "(accounts_cstm.agg_status_c LIKE '%D')", "(accounts_cstm.agg_status_c LIKE '%P')");

    @PostConstruct
    public void initLocal() {
        if (this.datastore == null) {
            this.log.info("SugarCRMCache datasource is null");
            if (this.mongo == null) {
                this.log.info("SugarCRMCache mongo is null");
                try {
                    this.mongo = new Mongo();
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
                catch (MongoException e) {
                    e.printStackTrace();
                }
            }
            DB db = this.mongo.getDB(CACHEDB);
            Morphia morphia = new Morphia();
            morphia.map(new Class[]{DataSet.class}).map(new Class[]{Provider.class});
            this.datastore = morphia.createDatastore(this.mongo, CACHEDB);
        }
        this.datastore.getDB().getCollection("DataSet").ensureIndex("identifier");
        this.datastore.getDB().getCollection("DataSet").ensureIndex("savedsugarcrmFields.name");
        this.datastore.getDB().getCollection("DataSet").ensureIndex("savedsugarcrmFields.country_c");
        this.datastore.getDB().getCollection("DataSet").ensureIndex("savedsugarcrmFields.sales_stage");
        this.datastore.getDB().getCollection("Provider").ensureIndex("identifier");
    }

    public SugarCRMSearchResults<Provider> getProviders() {
        return this.getProviders(null, 0, 0);
    }

    public SugarCRMSearchResults<Provider> getProviders(String country, int offset, int pagesize) {
        long count;
        SugarCRMSearchResults results = new SugarCRMSearchResults("", "");
        Query query = this.datastore.find(Provider.class);
        if (country != null) {
            query.filter("country", (Object)country.toUpperCase());
        }
        if (offset != 0 && pagesize != 0) {
            query.offset(offset);
            query.limit(pagesize);
        }
        if (offset == 0 && pagesize != 0) {
            query.offset(0);
            query.limit(pagesize);
        }
        if (offset != 0 && pagesize == 0) {
            query.offset(offset);
        }
        List providers = query.asList();
        results.totalResults = count = this.datastore.find(Provider.class).countAll();
        results.items = providers;
        for (Provider provider : providers) {
            this.inflateProvider(provider);
        }
        return results;
    }

    public SugarCRMSearchResults<DataSet> getCollections() {
        return this.getCollections(0, 0);
    }

    public SugarCRMSearchResults<DataSet> getCollections(int offset, int pagesize) {
        return this.getCollections(0, 0, null, null, null);
    }

    public SugarCRMSearchResults<DataSet> getCollections(int offset, int pagesize, String name, String country, String status) {
        long count;
        String sysId;
        SugarCRMSearchResults results = new SugarCRMSearchResults("", "");
        Query query = this.datastore.find(DataSet.class);
        if (StringUtils.isNotBlank((String)name)) {
            query.field("savedsugarcrmFields.name").equal((Object)name);
        }
        if (StringUtils.isNotBlank((String)country)) {
            query.field("savedsugarcrmFields.country_c").equal((Object)country);
        }
        if (StringUtils.isNotBlank((String)status) && StringUtils.isNotBlank((String)(sysId = ClientUtils.translateDsStatusDescription((String)status)))) {
            query.field("savedsugarcrmFields.sales_stage").equal((Object)sysId);
        }
        if (offset != 0 && pagesize != 0) {
            query.offset(offset);
            query.limit(pagesize);
        }
        if (offset == 0 && pagesize != 0) {
            query.offset(0);
            query.limit(pagesize);
        }
        if (offset != 0 && pagesize == 0) {
            query.offset(offset);
        }
        List dataSets = query.asList();
        results.totalResults = count = query.countAll();
        results.items = dataSets;
        for (DataSet dataSet : dataSets) {
            this.inflateDataset(dataSet);
        }
        return results;
    }

    public SugarCRMSearchResults<Provider> getProviderbyID(String id) {
        SugarCRMSearchResults results = new SugarCRMSearchResults("", "");
        results.items = new ArrayList();
        Provider provider = (Provider)((Query)this.datastore.find(Provider.class).field("_id").equal((Object)id)).get();
        if (provider != null) {
            this.inflateProvider(provider);
            results.items.add(provider);
        }
        return results;
    }

    public SugarCRMSearchResults<DataSet> getCollectionByID(String id) {
        SugarCRMSearchResults results = new SugarCRMSearchResults("", "");
        results.items = new ArrayList();
        DataSet dataSet = (DataSet)((Query)this.datastore.find(DataSet.class).field("_id").equal((Object)id)).get();
        if (dataSet != null) {
            this.inflateDataset(dataSet);
            results.items.add(dataSet);
        }
        return results;
    }

    public SugarCRMSearchResults<DataSet> getCollectionByProviderID(String id) {
        List dataSets = ((Query)this.datastore.find(DataSet.class).field("provIdentifier").equal((Object)id)).asList();
        for (DataSet dataSet : dataSets) {
            this.inflateDataset(dataSet);
        }
        SugarCRMSearchResults results = new SugarCRMSearchResults("", "");
        results.items = new ArrayList();
        results.items.addAll(dataSets);
        return results;
    }

    public void populateRepositoryFromScratch() throws JIXBQueryResultException {
        SugarCRMSearchResults providers = this.getProviders();
        if (providers.items.isEmpty()) {
            GetEntryListResponse response;
            ArrayList exportedProviders = Lists.newArrayListWithExpectedSize((int)1000);
            GetEntryList providerRequest = new GetEntryList();
            SelectFields fields = new SelectFields();
            providerRequest.setSelectFields(fields);
            providerRequest.setModuleName(EuropeanaDatasets.ORGANIZATIONS.getSysId());
            providerRequest.setSession(this.sugarwsClient.getSessionID());
            providerRequest.setOrderBy(EuropeanaRetrievableField.DATE_ENTERED.getFieldId());
            providerRequest.setMaxResults(100);
            providerRequest.setOffset(0);
            providerRequest.setQuery(DATA_AGGREGATOR_QUERY);
            int offset = 0;
            while ((response = this.sugarwsClient.getEntryList(providerRequest)).getReturn().getEntryList().getArray() != null) {
                exportedProviders.addAll((ArrayList)response.getReturn().getEntryList().getArray().getAnyList());
                offset = response.getReturn().getNextOffset();
                providerRequest.setOffset(offset);
            }
            this.log.info(String.format("Saving %d providers", exportedProviders.size()));
            int i = 1;
            for (Element exportedProvider : exportedProviders) {
                this.log.info(String.format("Processing provider %d/%d", i++, exportedProviders.size()));
                Provider provider = new Provider();
                this.populateProviderFromDOMElement(provider, exportedProvider);
                this.datastore.save((Object)provider);
                this.extractDatasetsFromProvider(exportedProvider);
            }
            this.log.info("All providers are saved.");
        }
    }

    public void saveupdateProvider2Cache(Provider provider) {
        UpdateOperations operations = this.datastore.createUpdateOperations(Provider.class).disableValidation().set("savedsugarcrmFields", (Object)provider.savedsugarcrmFields);
        Query query = (Query)this.datastore.createQuery(Provider.class).field("identifier").equal((Object)provider.identifier);
        this.datastore.updateFirst(query, operations, true);
    }

    public void saveupdateCollection2Cache(DataSet dataSet) {
        UpdateOperations operations = this.datastore.createUpdateOperations(DataSet.class).disableValidation().set("savedsugarcrmFields", (Object)dataSet.savedsugarcrmFields);
        Query query = (Query)this.datastore.createQuery(DataSet.class).field("identifier").equal((Object)dataSet.identifier);
        this.datastore.updateFirst(query, operations, true);
    }

    private void extractDatasetsFromProvider(Element exportedProvider) throws JIXBQueryResultException {
        String sugarCRMProviderID = ClientUtils.extractFromElement((String)"id", (Element)exportedProvider);
        String uimProviderID = ClientUtils.extractFromElement((String)"name_id_c", (Element)exportedProvider);
        GetRelationships request = new GetRelationships();
        request.setDeleted(0);
        request.setModuleId(sugarCRMProviderID);
        request.setModuleName("Accounts");
        request.setRelatedModule("Opportunities");
        request.setRelatedModuleQuery("");
        request.setSession(this.sugarwsClient.getSessionID());
        GetRelationshipsResponse resp = this.sugarwsClient.getRelationships(request);
        if (resp.getReturn().getIds().getArray() != null) {
            List el = resp.getReturn().getIds().getArray().getAnyList();
            for (Element elm : el) {
                String datasetId = this.extractDatasetId(elm.getTextContent());
                if (!StringUtils.isNotBlank((String)datasetId)) continue;
                String query = "opportunities.id LIKE '" + datasetId + "%'";
                SugarCRMSearchResults datasets = this.retrieveDataset(query, uimProviderID);
                if (datasets.items.size() == 0) continue;
                for (DataSet dataSet : datasets.items) {
                    this.datastore.save((Object)dataSet);
                }
            }
        }
    }

    private String extractDatasetId(String rawId) {
        if (StringUtils.isBlank((String)rawId)) {
            return null;
        }
        String[] datasetIdParts = rawId.split("-");
        StringBuilder datasetId = new StringBuilder();
        for (int i = 0; i < 5; ++i) {
            if (i < 4) {
                datasetId.append(datasetIdParts[i]);
                datasetId.append("-");
                continue;
            }
            datasetId.append(datasetIdParts[i].substring(0, 11));
        }
        return datasetId.toString();
    }

    public SugarCRMSearchResults<Provider> pollProviders() throws JIXBQueryResultException {
        String q1 = "accounts.date_modified > DATE_SUB(NOW(),INTERVAL 66 MINUTE)";
        String q2 = "accounts_cstm.agg_status_c LIKE '%D'";
        SugarCRMSearchResults retrievedProviders = this.retrieveProviders(new String[]{q1, q2});
        for (Provider provider : retrievedProviders.items) {
            this.log.info(String.format("Provider: %s was updated by the scheduler...", provider.identifier));
            this.saveupdateProvider2Cache(provider);
        }
        return retrievedProviders;
    }

    public SugarCRMSearchResults<DataSet> pollCollections() throws JIXBQueryResultException {
        SugarCRMSearchResults retrievedDatasets = this.retrieveDataset("opportunities.date_modified > DATE_SUB(NOW(),INTERVAL 66 MINUTE)", null);
        for (DataSet dataset : retrievedDatasets.items) {
            this.log.info(String.format("Dataset: %s was updated by the scheduler...", dataset.identifier));
            this.saveupdateCollection2Cache(dataset);
        }
        return retrievedDatasets;
    }

    private SugarCRMSearchResults<DataSet> retrieveDataset(String query, String providerID) throws JIXBQueryResultException {
        GetEntryList request = new GetEntryList();
        SugarCRMSearchResults results = new SugarCRMSearchResults("", "");
        results.items = new ArrayList();
        SelectFields fields = new SelectFields();
        request.setSelectFields(fields);
        request.setModuleName(EuropeanaDatasets.DATASETS.getSysId());
        request.setSession(this.sugarwsClient.getSessionID());
        request.setOrderBy(EuropeanaRetrievableField.DATE_ENTERED.getFieldId());
        request.setMaxResults(100);
        request.setOffset(0);
        request.setQuery(query);
        GetEntryListResponse response = this.sugarwsClient.getEntryList(request);
        ArrayList xmlElements = null;
        xmlElements = response.getReturn().getEntryList().getArray() != null ? (ArrayList)response.getReturn().getEntryList().getArray().getAnyList() : new ArrayList();
        for (Element xmlElement : xmlElements) {
            DataSet dataSet = new DataSet();
            this.populateDatasetFromDOMElement(dataSet, xmlElement, providerID);
            results.items.add(dataSet);
        }
        return results;
    }

    private SugarCRMSearchResults<Provider> retrieveProviders(String ... query) throws JIXBQueryResultException {
        GetEntryList request = new GetEntryList();
        SugarCRMSearchResults results = new SugarCRMSearchResults("", "");
        results.items = new ArrayList();
        request.setSelectFields(new SelectFields());
        request.setModuleName(EuropeanaDatasets.ORGANIZATIONS.getSysId());
        request.setSession(this.sugarwsClient.getSessionID());
        request.setOrderBy(EuropeanaRetrievableField.DATE_ENTERED.getFieldId());
        request.setMaxResults(200);
        request.setOffset(0);
        if (query.length == 0) {
            request.setQuery(DATA_AGGREGATOR_QUERY);
        } else {
            StringWriter querywrt = new StringWriter();
            if (query.length == 1) {
                querywrt.append("(");
                querywrt.append(query[0]);
                querywrt.append(")");
                request.setQuery(querywrt.toString());
            } else {
                querywrt.append("(");
                for (int i = 0; i < query.length; ++i) {
                    querywrt.append("(");
                    querywrt.append(query[i]);
                    querywrt.append(")");
                    if (i >= query.length - 1) continue;
                    querywrt.append(" and ");
                }
                querywrt.append(")");
                request.setQuery(querywrt.toString());
            }
        }
        GetEntryListResponse response = this.sugarwsClient.getEntryList(request);
        ArrayList xmlElements = null;
        xmlElements = response.getReturn().getEntryList().getArray() != null ? (ArrayList)response.getReturn().getEntryList().getArray().getAnyList() : new ArrayList();
        this.log.info(String.format("Retrieved %d providers", xmlElements.size()));
        for (Element xmlElement : xmlElements) {
            Provider provider = new Provider();
            this.populateProviderFromDOMElement(provider, xmlElement);
            results.items.add(provider);
        }
        return results;
    }

    private void populateDatasetFromDOMElement(DataSet dataSet, Element xmlElement, String providerID) {
        String numberOfDeletedRecords;
        String identifier;
        dataSet.identifier = identifier = ClientUtils.extractFromElement((String)EuropeanaRetrievableField.NAME.getFieldId(), (Element)xmlElement).split("_")[0];
        dataSet.provIdentifier = providerID;
        dataSet.status = ClientUtils.translateStatus((String)ClientUtils.extractFromElement((String)EuropeanaUpdatableField.STATUS.getFieldId(), (Element)xmlElement));
        dataSet.edmDatasetName = ClientUtils.extractFromElement((String)EuropeanaRetrievableField.NAME.getFieldId(), (Element)xmlElement);
        String publishedRecordsStr = ClientUtils.extractFromElement((String)EuropeanaUpdatableField.TOTAL_INGESTED.getFieldId(), (Element)xmlElement);
        if (StringUtils.isNotBlank((String)publishedRecordsStr)) {
            try {
                dataSet.publishedRecords = Long.parseLong(publishedRecordsStr);
            }
            catch (NumberFormatException e) {
                dataSet.publishedRecords = 0L;
            }
        } else {
            dataSet.publishedRecords = 0L;
        }
        if (StringUtils.isNotBlank((String)(numberOfDeletedRecords = ClientUtils.extractFromElement((String)EuropeanaUpdatableField.DELETED_RECORDS.getFieldId(), (Element)xmlElement)))) {
            try {
                dataSet.deletedRecords = Long.parseLong(numberOfDeletedRecords);
            }
            catch (NumberFormatException e) {
                dataSet.deletedRecords = 0L;
            }
        } else {
            dataSet.deletedRecords = 0L;
        }
        dataSet.savedsugarcrmFields = ClientUtils.mapFromElement((Element)xmlElement);
    }

    private void inflateDataset(DataSet dataSet) {
        String delrecordsStr;
        dataSet.status = ClientUtils.translateStatus((String)((String)dataSet.savedsugarcrmFields.get(EuropeanaUpdatableField.STATUS.getFieldId())));
        dataSet.edmDatasetName = (String)dataSet.savedsugarcrmFields.get(EuropeanaRetrievableField.NAME.getFieldId());
        dataSet.creationDate = (String)dataSet.savedsugarcrmFields.get(EuropeanaRetrievableField.DATE_ENTERED.getFieldId());
        dataSet.providerName = (String)dataSet.savedsugarcrmFields.get(EuropeanaRetrievableField.ORGANIZATION_NAME.getFieldId());
        String precordsStr = (String)dataSet.savedsugarcrmFields.get(EuropeanaUpdatableField.TOTAL_INGESTED.getFieldId());
        if (precordsStr != null) {
            try {
                dataSet.publishedRecords = Long.parseLong(precordsStr);
            }
            catch (Exception ex) {
                dataSet.publishedRecords = 0L;
            }
        }
        if ((delrecordsStr = (String)dataSet.savedsugarcrmFields.get(EuropeanaUpdatableField.DELETED_RECORDS.getFieldId())) != null) {
            dataSet.deletedRecords = Long.parseLong(delrecordsStr);
        }
    }

    private void populateProviderFromDOMElement(Provider provider, Element xmlElement) {
        provider.identifier = ClientUtils.extractFromElement((String)"name_id_c", (Element)xmlElement);
        provider.country = ClientUtils.extractFromElement((String)"country_c", (Element)xmlElement);
        provider.savedsugarcrmFields = ClientUtils.mapFromElement((Element)xmlElement);
    }

    private void inflateProvider(Provider provider) {
        provider.name = (String)provider.savedsugarcrmFields.get("name");
        provider.country = (String)provider.savedsugarcrmFields.get("country_c");
        provider.name = (String)provider.savedsugarcrmFields.get("name");
        provider.altname = (String)provider.savedsugarcrmFields.get("name_alt_c");
        provider.acronym = (String)provider.savedsugarcrmFields.get("name_acronym_c");
        provider.domain = (String)provider.savedsugarcrmFields.get("account_type");
        provider.geolevel = (String)provider.savedsugarcrmFields.get("geo_level_c");
        provider.role = ClientUtils.translateType((String)((String)provider.savedsugarcrmFields.get("agg_status_c")));
        provider.scope = (String)provider.savedsugarcrmFields.get("scope_c");
        provider.sector = (String)provider.savedsugarcrmFields.get("sector_c");
        provider.website = (String)provider.savedsugarcrmFields.get("website");
    }

    public void setSugarwsClient(SugarWsClient sugarwsClient) {
        this.sugarwsClient = sugarwsClient;
    }
}

