/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.web.security.oauth2;

import eu.europeana.corelib.db.entity.nosql.AccessToken;
import eu.europeana.corelib.db.entity.nosql.RefreshToken;
import eu.europeana.corelib.db.service.OAuth2TokenService;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.security.oauth2.common.util.SerializationUtils;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.AuthenticationKeyGenerator;
import org.springframework.security.oauth2.provider.token.DefaultAuthenticationKeyGenerator;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.stereotype.Service;

@Service
public class ApiTokenStore
implements TokenStore {
    @Resource
    private OAuth2TokenService oAuth2TokenService;
    private AuthenticationKeyGenerator authenticationKeyGenerator = new DefaultAuthenticationKeyGenerator();

    @Scheduled(cron="@daily")
    public void cleanExpiredTokens() {
        this.oAuth2TokenService.cleanExpiredTokens();
    }

    public OAuth2Authentication readAuthentication(OAuth2AccessToken token) {
        return this.readAuthentication(token.getValue());
    }

    public OAuth2Authentication readAuthentication(String token) {
        OAuth2Authentication authentication = null;
        AccessToken entity = this.oAuth2TokenService.findAccessTokenByID(this.extractTokenKey(token));
        if (entity != null) {
            authentication = this.deserializeAuthentication(entity.getAuthentication());
        }
        return authentication;
    }

    public void storeAccessToken(OAuth2AccessToken token, OAuth2Authentication authentication) {
        String refreshToken = null;
        if (token.getRefreshToken() != null) {
            refreshToken = token.getRefreshToken().getValue();
        }
        AccessToken entity = new AccessToken(this.extractTokenKey(token.getValue()), token.getExpiration());
        entity.setToken(this.serializeAccessToken(token));
        entity.setAuthenticationId(this.authenticationKeyGenerator.extractKey(authentication));
        entity.setUserName(authentication.isClientOnly() ? null : authentication.getName());
        entity.setClientId(authentication.getAuthorizationRequest().getClientId());
        entity.setAuthentication(this.serializeAuthentication(authentication));
        entity.setRefreshToken(this.extractTokenKey(refreshToken));
        this.oAuth2TokenService.store(entity);
    }

    public OAuth2AccessToken readAccessToken(String tokenValue) {
        OAuth2AccessToken accessToken = null;
        AccessToken entity = this.oAuth2TokenService.findAccessTokenByID(this.extractTokenKey(tokenValue));
        if (entity != null) {
            accessToken = this.deserializeAccessToken(entity.getToken());
        }
        return accessToken;
    }

    public void removeAccessToken(OAuth2AccessToken token) {
        this.removeAccessToken(token.getValue());
    }

    public void removeAccessToken(String tokenValue) {
        this.oAuth2TokenService.removeAccessToken(this.extractTokenKey(tokenValue));
    }

    public void storeRefreshToken(OAuth2RefreshToken refreshToken, OAuth2Authentication authentication) {
        RefreshToken entity = new RefreshToken(this.extractTokenKey(this.extractTokenKey(refreshToken.getValue())));
        entity.setToken(this.serializeRefreshToken(refreshToken));
        entity.setAuthentication(this.serializeAuthentication(authentication));
        this.oAuth2TokenService.store(entity);
    }

    public OAuth2RefreshToken readRefreshToken(String tokenValue) {
        OAuth2RefreshToken refreshToken = null;
        RefreshToken entity = this.oAuth2TokenService.findRefreshTokenByID(this.extractTokenKey(tokenValue));
        if (entity != null) {
            refreshToken = this.deserializeRefreshToken(entity.getToken());
        }
        return refreshToken;
    }

    public OAuth2Authentication readAuthenticationForRefreshToken(OAuth2RefreshToken token) {
        return this.readAuthenticationForRefreshToken(token.getValue());
    }

    public OAuth2Authentication readAuthenticationForRefreshToken(String tokenValue) {
        OAuth2Authentication authentication = null;
        RefreshToken entity = this.oAuth2TokenService.findRefreshTokenByID(this.extractTokenKey(tokenValue));
        if (entity != null) {
            authentication = this.deserializeAuthentication(entity.getAuthentication());
        }
        return authentication;
    }

    public void removeRefreshToken(OAuth2RefreshToken token) {
        this.removeRefreshToken(token.getValue());
    }

    public void removeRefreshToken(String tokenValue) {
        this.oAuth2TokenService.removeRefreshToken(this.extractTokenKey(tokenValue));
    }

    public void removeAccessTokenUsingRefreshToken(OAuth2RefreshToken refreshToken) {
        this.removeAccessTokenUsingRefreshToken(refreshToken.getValue());
    }

    public void removeAccessTokenUsingRefreshToken(String refreshToken) {
        this.oAuth2TokenService.removeAccessTokenByRefreshTokenId(this.extractTokenKey(refreshToken));
    }

    public OAuth2AccessToken getAccessToken(OAuth2Authentication authentication) {
        OAuth2AccessToken accessToken = null;
        String key = this.authenticationKeyGenerator.extractKey(authentication);
        AccessToken entity = this.oAuth2TokenService.findAccessTokenByAuthenticationId(key);
        if (entity != null && (accessToken = this.deserializeAccessToken(entity.getToken())) != null && !key.equals(this.authenticationKeyGenerator.extractKey(this.readAuthentication(accessToken.getValue())))) {
            this.removeAccessToken(accessToken.getValue());
            this.storeAccessToken(accessToken, authentication);
        }
        return accessToken;
    }

    public Collection<OAuth2AccessToken> findTokensByUserName(String userName) {
        ArrayList<OAuth2AccessToken> accessTokens = new ArrayList<OAuth2AccessToken>();
        List entities = this.oAuth2TokenService.findByUserName(userName);
        if (entities != null) {
            for (AccessToken entity : entities) {
                accessTokens.add(this.deserializeAccessToken(entity.getToken()));
            }
        }
        return this.removeNulls(accessTokens);
    }

    public Collection<OAuth2AccessToken> findTokensByClientId(String clientId) {
        ArrayList<OAuth2AccessToken> accessTokens = new ArrayList<OAuth2AccessToken>();
        List entities = this.oAuth2TokenService.findByClientId(clientId);
        if (entities != null) {
            for (AccessToken entity : entities) {
                accessTokens.add(this.deserializeAccessToken(entity.getToken()));
            }
        }
        return this.removeNulls(accessTokens);
    }

    private List<OAuth2AccessToken> removeNulls(List<OAuth2AccessToken> accessTokens) {
        ArrayList<OAuth2AccessToken> tokens = new ArrayList<OAuth2AccessToken>();
        for (OAuth2AccessToken token : accessTokens) {
            if (token == null) continue;
            tokens.add(token);
        }
        return tokens;
    }

    private byte[] serializeAccessToken(OAuth2AccessToken token) {
        return SerializationUtils.serialize((Object)token);
    }

    private byte[] serializeRefreshToken(OAuth2RefreshToken token) {
        return SerializationUtils.serialize((Object)token);
    }

    private byte[] serializeAuthentication(OAuth2Authentication authentication) {
        return SerializationUtils.serialize((Object)authentication);
    }

    private OAuth2AccessToken deserializeAccessToken(byte[] token) {
        return (OAuth2AccessToken)SerializationUtils.deserialize((byte[])token);
    }

    private OAuth2RefreshToken deserializeRefreshToken(byte[] token) {
        return (OAuth2RefreshToken)SerializationUtils.deserialize((byte[])token);
    }

    private OAuth2Authentication deserializeAuthentication(byte[] authentication) {
        return (OAuth2Authentication)SerializationUtils.deserialize((byte[])authentication);
    }

    private String extractTokenKey(String value) {
        MessageDigest digest;
        if (value == null) {
            return null;
        }
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("MD5 algorithm not available.  Fatal (should be in the JDK).");
        }
        try {
            byte[] bytes = digest.digest(value.getBytes("UTF-8"));
            return String.format("%032x", new BigInteger(1, bytes));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 encoding not available.  Fatal (should be in the JDK).");
        }
    }
}

