/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.web.controller;

import eu.europeana.corelib.db.service.ApiKeyService;
import eu.europeana.corelib.definitions.db.entity.relational.ApiKey;
import java.io.Serializable;
import java.util.TreeMap;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

@Controller
@SessionAttributes(types={AuthorizationRequest.class})
public class AccessConfirmationController {
    @Resource
    private ApiKeyService apiKeyService;
    private ClientDetailsService clientDetailsService;

    @RequestMapping(value={"/oauth/confirm_access"})
    public ModelAndView getAccessConfirmation(@ModelAttribute AuthorizationRequest clientAuth) throws Exception {
        ClientDetails client = this.clientDetailsService.loadClientByClientId(clientAuth.getClientId());
        ApiKey key = (ApiKey)this.apiKeyService.findByID((Serializable)((Object)client.getClientId()));
        TreeMap<String, Object> model = new TreeMap<String, Object>();
        model.put("auth_request", clientAuth);
        model.put("client", client);
        model.put("appName", StringUtils.defaultIfBlank((String)key.getApplicationName(), (String)StringUtils.defaultIfBlank((String)key.getUser().getCompany(), (String)((String)((Object)key.getId())))));
        return new ModelAndView("user/authorize", model);
    }

    @RequestMapping(value={"/login"}, params={"form=user"})
    public String loginUserForm() {
        return "user/login";
    }

    @RequestMapping(value={"/login"}, params={"form=myData"})
    public String loginMyDataForm() {
        return "mydata/login";
    }

    @Autowired
    public void setClientDetailsService(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }
}

