/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.web.security.model;

import eu.europeana.corelib.utils.StringArrayUtils;
import java.util.Collection;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.provider.BaseClientDetails;

public class Api2OAuth2ClientDetails
extends BaseClientDetails {
    private static final long serialVersionUID = -5687602758230210358L;
    private Set<String> authGrantTypes = StringArrayUtils.toSet((String[])new String[]{"authorization_code", "implicit"});
    private Set<String> scope = StringArrayUtils.toSet((String[])new String[]{"read", "write"});

    public Api2OAuth2ClientDetails(String apikey, String secret) {
        this.setClientId(apikey);
        this.setClientSecret(secret);
        this.setAuthorities((Collection)AuthorityUtils.commaSeparatedStringToAuthorityList((String)"ROLE_CLIENT"));
    }

    public boolean isSecretRequired() {
        return true;
    }

    @JsonIgnore
    public Set<String> getAuthorizedGrantTypes() {
        return this.authGrantTypes;
    }

    public Set<String> getScope() {
        return this.scope;
    }
}

