/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller.user;

import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.v2.model.json.UserModification;
import eu.europeana.api2.v2.model.json.UserResults;
import eu.europeana.api2.v2.model.json.abstracts.UserObject;
import eu.europeana.api2.v2.model.json.user.Tag;
import eu.europeana.api2.v2.web.controller.abstracts.AbstractUserController;
import eu.europeana.corelib.db.exception.DatabaseException;
import eu.europeana.corelib.definitions.db.entity.relational.SocialTag;
import eu.europeana.corelib.definitions.db.entity.relational.User;
import eu.europeana.corelib.definitions.db.entity.relational.abstracts.EuropeanaUserObject;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class UserTagController
extends AbstractUserController {
    @RequestMapping(value={"/v2/user/tag.json"}, params={"!action"}, produces={"application/json"})
    public ModelAndView defaultAction(@RequestParam(value="europeanaid", required=false) String europeanaId, @RequestParam(value="tag", required=false) String tag, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        return this.list(europeanaId, tag, callback, principal);
    }

    @RequestMapping(value={"/v2/user/tag.json"}, params={"action=LIST"}, produces={"application/json"})
    public ModelAndView list(@RequestParam(value="europeanaid", required=false) String europeanaId, @RequestParam(value="tag", required=false) String tagFilter, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        UserResults response = new UserResults(this.getApiId(principal), "/v2/user/tag.json");
        try {
            User user = this.userService.findByEmail(principal.getName());
            if (user != null) {
                response.items = new ArrayList();
                response.username = user.getUserName();
                List tags = StringUtils.isNotBlank((String)tagFilter) ? this.userService.findSocialTagsByTag((Long)user.getId(), tagFilter) : (StringUtils.isNotBlank((String)europeanaId) ? this.userService.findSocialTagsByEuropeanaId((Long)user.getId(), europeanaId) : new ArrayList(user.getSocialTags()));
                response.itemsCount = tags.size();
                for (SocialTag item : tags) {
                    Tag tag = new Tag();
                    this.copyUserObjectData(response.apikey, (UserObject)tag, (EuropeanaUserObject)item);
                    tag.tag = item.getTag();
                    response.items.add(tag);
                }
            } else {
                response.success = false;
                response.error = "User Profile not retrievable...";
            }
        }
        catch (DatabaseException e) {
            response.success = false;
            response.error = e.getMessage();
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }

    @RequestMapping(value={"/v2/user/tag.json"}, params={"action=TAGCLOUD"}, produces={"application/json"})
    public ModelAndView listDistinct(@RequestParam(value="callback", required=false) String callback, Principal principal) {
        UserResults response = new UserResults(this.getApiId(principal), "/v2/user/tag.json?action=TAGCLOUD");
        try {
            User user = this.userService.findByEmail(principal.getName());
            if (user != null) {
                response.items = this.userService.createSocialTagCloud((Long)user.getId());
                response.itemsCount = response.items.size();
                response.success = true;
                response.username = user.getUserName();
            } else {
                response.success = false;
                response.error = "User Profile not retrievable...";
            }
        }
        catch (DatabaseException e) {
            response.success = false;
            response.error = e.getMessage();
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }

    @RequestMapping(value={"/v2/user/tag.json"}, produces={"application/json"}, method={RequestMethod.POST, RequestMethod.PUT})
    public ModelAndView createRest(@RequestParam(value="europeanaid", required=true) String europeanaId, @RequestParam(value="tag", required=true) String tag, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        return this.create(europeanaId, tag, callback, principal);
    }

    @RequestMapping(value={"/v2/user/tag.json"}, params={"action=CREATE"}, produces={"application/json"})
    public ModelAndView create(@RequestParam(value="europeanaid", required=true) String europeanaId, @RequestParam(value="tag", required=true) String tag, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        User user = this.userService.findByEmail(principal.getName());
        UserModification response = new UserModification(this.getApiId(principal), "/v2/user/tag.json?action=CREATE");
        if (user != null) {
            try {
                this.userService.createSocialTag((Long)user.getId(), europeanaId, tag);
                response.success = true;
            }
            catch (DatabaseException e) {
                response.success = false;
                response.error = e.getMessage();
            }
        } else {
            response.success = false;
            response.error = "User Profile not retrievable...";
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }

    @RequestMapping(value={"/v2/user/tag.json"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ModelAndView deleteRest(@RequestParam(value="tagid", required=false) Long tagId, @RequestParam(value="tag", required=false) String tag, @RequestParam(value="europeanaid", required=false) String europeanaId, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        return this.delete(tagId, tag, europeanaId, callback, principal);
    }

    @RequestMapping(value={"/v2/user/tag.json"}, params={"action=DELETE"}, produces={"application/json"})
    public ModelAndView delete(@RequestParam(value="tagid", required=false) Long tagId, @RequestParam(value="tag", required=false) String tag, @RequestParam(value="europeanaid", required=false) String europeanaId, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        User user = this.userService.findByEmail(principal.getName());
        UserModification response = new UserModification(this.getApiId(principal), "/v2/user/tag.json?action=DELETE");
        if (user != null) {
            try {
                if (tagId != null) {
                    this.userService.removeSocialTag((Long)user.getId(), tagId);
                } else if (StringUtils.isNotBlank((String)europeanaId) || StringUtils.isNotBlank((String)tag)) {
                    this.userService.removeSocialTag((Long)user.getId(), europeanaId, tag);
                }
                response.success = true;
            }
            catch (DatabaseException e) {
                response.success = false;
                response.error = e.getMessage();
            }
        } else {
            response.success = false;
            response.error = "User Profile not retrievable...";
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }
}

