/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import eu.europeana.api2.model.enums.ApiLimitException;
import eu.europeana.api2.model.json.ApiError;
import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.v2.model.LimitResponse;
import eu.europeana.api2.v2.model.json.sugarcrm.SugarCRMSearchResults;
import eu.europeana.api2.v2.service.SugarCRMCache;
import eu.europeana.api2.v2.utils.ControllerUtils;
import eu.europeana.corelib.db.entity.enums.RecordType;
import eu.europeana.corelib.db.service.ApiKeyService;
import eu.europeana.corelib.db.service.ApiLogService;
import eu.europeana.corelib.logging.Log;
import eu.europeana.corelib.logging.Logger;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SugarCRMController {
    @Log
    private Logger log;
    @Resource
    private SugarCRMCache sugarCRMCache;
    @Resource
    private ApiKeyService apiService;
    @Resource
    private ApiLogService apiLogService;
    @Resource
    private ControllerUtils controllerUtils;

    @RequestMapping(value={"/v2/providers.json"}, produces={"application/json"}, method={RequestMethod.POST, RequestMethod.GET})
    public ModelAndView findproviders(@RequestParam(value="wskey", required=false) String wskey, @RequestParam(value="callback", required=false) String callback, @RequestParam(value="countryCode", required=false) String countryCode, @RequestParam(value="offset", required=false) String offset, @RequestParam(value="pagesize", required=false) String pagesize, HttpServletRequest request, HttpServletResponse httpResponse) {
        this.controllerUtils.addResponseHeaders(httpResponse);
        Date starttime = new Date();
        SugarCRMSearchResults response = null;
        LimitResponse limitResponse = null;
        try {
            limitResponse = this.controllerUtils.checkLimit(wskey, request.getRequestURL().toString(), "providers.json", RecordType.PROVIDERS, null);
        }
        catch (ApiLimitException e) {
            httpResponse.setStatus(e.getHttpStatus());
            return JsonUtils.toJson((Object)new ApiError(e), (String)callback);
        }
        String action = "/v2/providers.json";
        try {
            int intOffset = offset == null ? 0 : Integer.parseInt(offset);
            int intPagesize = pagesize == null ? 0 : Integer.parseInt(pagesize);
            response = this.sugarCRMCache.getProviders(countryCode, intOffset, intPagesize);
            response.action = action;
            response.apikey = wskey;
            response.requestNumber = limitResponse.getRequestNumber();
            response.itemsCount = response.items.size();
            response.statsStartTime = starttime;
            Date endtime = new Date();
            response.statsDuration = endtime.getTime() - starttime.getTime();
        }
        catch (Exception e) {
            String error = "Error fetching all providers";
            this.log.error(error, (Throwable)e);
            return JsonUtils.toJson((Object)new ApiError(wskey, action, error + " " + e.getMessage(), limitResponse.getRequestNumber()), (String)callback);
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }

    @RequestMapping(value={"/v2/provider/{id}.json"}, produces={"application/json"}, method={RequestMethod.POST, RequestMethod.GET})
    public ModelAndView findprovidersByID(@PathVariable String id, @RequestParam(value="wskey", required=false) String wskey, @RequestParam(value="callback", required=false) String callback, HttpServletRequest request, HttpServletResponse httpResponse) {
        this.controllerUtils.addResponseHeaders(httpResponse);
        Date starttime = new Date();
        SugarCRMSearchResults response = null;
        LimitResponse limitResponse = null;
        try {
            limitResponse = this.controllerUtils.checkLimit(wskey, request.getRequestURL().toString(), "provider.json", RecordType.PROVIDER, null);
        }
        catch (ApiLimitException e) {
            httpResponse.setStatus(e.getHttpStatus());
            return JsonUtils.toJson((Object)new ApiError(e), (String)callback);
        }
        String action = "/v2/provider/" + id + ".json";
        try {
            response = this.sugarCRMCache.getProviderbyID(id);
            response.action = action;
            response.apikey = wskey;
            response.requestNumber = limitResponse.getRequestNumber();
            response.itemsCount = response.items.size();
            response.totalResults = response.items.size();
            response.statsStartTime = starttime;
            Date endtime = new Date();
            response.statsDuration = endtime.getTime() - starttime.getTime();
            response.success = true;
        }
        catch (Exception e) {
            String error = "Error fetching all providers";
            this.log.error(error, (Throwable)e);
            return JsonUtils.toJson((Object)new ApiError(wskey, action, error + " " + e.getMessage(), limitResponse.getRequestNumber()), (String)callback);
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }

    @RequestMapping(value={"/v2/provider/{id}/datasets.json"}, produces={"application/json"}, method={RequestMethod.POST, RequestMethod.GET})
    public ModelAndView findDatasetsPerProvider(@PathVariable String id, @RequestParam(value="wskey", required=false) String wskey, @RequestParam(value="callback", required=false) String callback, HttpServletRequest request, HttpServletResponse httpResponse) {
        this.controllerUtils.addResponseHeaders(httpResponse);
        Date starttime = new Date();
        SugarCRMSearchResults response = null;
        LimitResponse limitResponse = null;
        try {
            limitResponse = this.controllerUtils.checkLimit(wskey, request.getRequestURL().toString(), "provider/datasets.json", RecordType.PROVIDER_DATASETS, null);
        }
        catch (ApiLimitException e) {
            httpResponse.setStatus(e.getHttpStatus());
            return JsonUtils.toJson((Object)new ApiError(e), (String)callback);
        }
        String action = "/v2/provider/" + id + "/datasets.json";
        try {
            response = this.sugarCRMCache.getCollectionByProviderID(id);
            response.action = action;
            response.apikey = wskey;
            response.requestNumber = limitResponse.getRequestNumber();
            response.itemsCount = response.items.size();
            response.totalResults = response.items.size();
            response.statsStartTime = starttime;
            Date endtime = new Date();
            response.statsDuration = endtime.getTime() - starttime.getTime();
            response.success = true;
        }
        catch (Exception e) {
            String error = "Error fetching datasets by provider id";
            this.log.error(error, (Throwable)e);
            return JsonUtils.toJson((Object)new ApiError(wskey, action, error + " " + e.getMessage(), limitResponse.getRequestNumber()), (String)callback);
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }

    @RequestMapping(value={"/v2/datasets.json"}, produces={"application/json"}, method={RequestMethod.POST, RequestMethod.GET})
    public ModelAndView findDatasets(@RequestParam(value="wskey", required=false) String wskey, @RequestParam(value="callback", required=false) String callback, @RequestParam(value="edmDatasetName", required=false) String name, @RequestParam(value="countryCode", required=false) String country, @RequestParam(value="status", required=false) String status, @RequestParam(value="offset", required=false) String offset, @RequestParam(value="pagesize", required=false) String pagesize, HttpServletRequest request, HttpServletResponse httpResponse) {
        this.controllerUtils.addResponseHeaders(httpResponse);
        Date starttime = new Date();
        SugarCRMSearchResults response = null;
        LimitResponse limitResponse = null;
        try {
            limitResponse = this.controllerUtils.checkLimit(wskey, request.getRequestURL().toString(), "datasets.json", RecordType.DATASETS, null);
        }
        catch (ApiLimitException e) {
            httpResponse.setStatus(e.getHttpStatus());
            return JsonUtils.toJson((Object)new ApiError(e), (String)callback);
        }
        String action = "/v2/datasets.json";
        try {
            int intOffset = offset == null ? 0 : Integer.parseInt(offset);
            int intPagesize = pagesize == null ? 0 : Integer.parseInt(pagesize);
            response = this.sugarCRMCache.getCollections(intOffset, intPagesize, name, country, status);
            response.action = action;
            response.apikey = wskey;
            response.requestNumber = limitResponse.getRequestNumber();
            response.itemsCount = response.items.size();
            response.statsStartTime = starttime;
            Date endtime = new Date();
            response.statsDuration = endtime.getTime() - starttime.getTime();
        }
        catch (Exception e) {
            String error = "Error fetching all datasets";
            this.log.error(error, (Throwable)e);
            return JsonUtils.toJson((Object)new ApiError(wskey, action, error + " " + e.getMessage(), limitResponse.getRequestNumber()), (String)callback);
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }

    @RequestMapping(value={"/v2/dataset/{id}.json"}, produces={"application/json"}, method={RequestMethod.POST, RequestMethod.GET})
    public ModelAndView findDatasetsById(@PathVariable String id, @RequestParam(value="wskey", required=false) String wskey, @RequestParam(value="callback", required=false) String callback, HttpServletRequest request, HttpServletResponse httpResponse) {
        this.controllerUtils.addResponseHeaders(httpResponse);
        Date starttime = new Date();
        SugarCRMSearchResults response = null;
        LimitResponse limitResponse = null;
        try {
            limitResponse = this.controllerUtils.checkLimit(wskey, request.getRequestURL().toString(), "datasets.json", RecordType.DATASETS, null);
        }
        catch (ApiLimitException e) {
            httpResponse.setStatus(e.getHttpStatus());
            return JsonUtils.toJson((Object)new ApiError(e), (String)callback);
        }
        String action = "/v2/dataset/" + id + ".json";
        try {
            response = this.sugarCRMCache.getCollectionByID(id);
            response.action = action;
            response.apikey = wskey;
            response.requestNumber = limitResponse.getRequestNumber();
            response.itemsCount = response.items.size();
            response.totalResults = response.items.size();
            response.statsStartTime = starttime;
            Date endtime = new Date();
            response.statsDuration = endtime.getTime() - starttime.getTime();
            response.success = true;
        }
        catch (Exception e) {
            String error = "Error fetching datasets by dataset id";
            this.log.error(error, (Throwable)e);
            return JsonUtils.toJson((Object)new ApiError(wskey, action, error + " " + e.getMessage(), limitResponse.getRequestNumber()), (String)callback);
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }
}

