/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import com.github.jsonldjava.core.JSONLD;
import com.github.jsonldjava.core.JSONLDProcessingError;
import com.github.jsonldjava.core.Options;
import com.github.jsonldjava.core.RDFParser;
import com.github.jsonldjava.impl.JenaRDFParser;
import com.github.jsonldjava.utils.JSONUtils;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import eu.europeana.api2.model.enums.ApiLimitException;
import eu.europeana.api2.model.enums.Profile;
import eu.europeana.api2.model.json.ApiError;
import eu.europeana.api2.model.json.ApiNotImplementedYet;
import eu.europeana.api2.model.json.abstracts.ApiResponse;
import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.v2.model.LimitResponse;
import eu.europeana.api2.v2.model.json.ObjectResult;
import eu.europeana.api2.v2.model.json.view.BriefView;
import eu.europeana.api2.v2.model.json.view.FullView;
import eu.europeana.api2.v2.utils.ControllerUtils;
import eu.europeana.corelib.db.entity.enums.RecordType;
import eu.europeana.corelib.db.exception.DatabaseException;
import eu.europeana.corelib.db.exception.LimitReachedException;
import eu.europeana.corelib.db.service.ApiKeyService;
import eu.europeana.corelib.db.service.ApiLogService;
import eu.europeana.corelib.definitions.db.entity.relational.ApiKey;
import eu.europeana.corelib.definitions.solr.beans.BriefBean;
import eu.europeana.corelib.definitions.solr.beans.FullBean;
import eu.europeana.corelib.logging.Log;
import eu.europeana.corelib.logging.Logger;
import eu.europeana.corelib.solr.bean.impl.FullBeanImpl;
import eu.europeana.corelib.solr.exceptions.MongoDBException;
import eu.europeana.corelib.solr.exceptions.SolrTypeException;
import eu.europeana.corelib.solr.service.SearchService;
import eu.europeana.corelib.solr.utils.EdmUtils;
import eu.europeana.corelib.utils.service.OptOutService;
import eu.europeana.corelib.web.service.EuropeanaUrlService;
import eu.europeana.corelib.web.utils.RequestUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.solr.client.solrj.SolrServerException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/v2/record"})
public class ObjectController {
    @Log
    private Logger log;
    @Resource
    private SearchService searchService;
    @Resource
    private ApiLogService apiLogService;
    @Resource
    private ApiKeyService apiService;
    @Resource
    private OptOutService optOutService;
    @Resource
    private EuropeanaUrlService urlService;
    @Resource
    private ControllerUtils controllerUtils;
    private String similarItemsProfile = "minimal";

    @RequestMapping(value={"/{collectionId}/{recordId}.json"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView record(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="profile", required=false, defaultValue="full") String profile, @RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="callback", required=false) String callback, HttpServletRequest request, HttpServletResponse response) {
        this.controllerUtils.addResponseHeaders(response);
        LimitResponse limitResponse = null;
        try {
            limitResponse = this.controllerUtils.checkLimit(wskey, request.getRequestURL().toString(), "record.json", RecordType.OBJECT, profile);
        }
        catch (ApiLimitException e) {
            response.setStatus(e.getHttpStatus());
            return JsonUtils.toJson((Object)new ApiError(e), (String)callback);
        }
        this.log.info("record");
        ObjectResult objectResult = new ObjectResult(wskey, "record.json", limitResponse.getRequestNumber());
        if (StringUtils.containsIgnoreCase((String)profile, (String)"params")) {
            objectResult.addParams(RequestUtils.getParameterMap((HttpServletRequest)request), new String[]{"wskey"});
            objectResult.addParam("profile", (Object)profile);
        }
        String europeanaObjectId = "/" + collectionId + "/" + recordId;
        try {
            long t0 = new Date().getTime();
            FullBean bean = this.searchService.findById(europeanaObjectId, false);
            if (bean == null) {
                bean = this.searchService.resolve(europeanaObjectId, false);
            }
            if (bean == null) {
                return JsonUtils.toJson((Object)new ApiError(wskey, "record.json", "Invalid record identifier: " + europeanaObjectId, limitResponse.getRequestNumber()), (String)callback);
            }
            if (StringUtils.containsIgnoreCase((String)profile, (String)Profile.SIMILAR.getName())) {
                ArrayList<BriefView> beans = new ArrayList<BriefView>();
                try {
                    List similarItems = this.searchService.findMoreLikeThis(europeanaObjectId);
                    for (BriefBean b : similarItems) {
                        BriefView view = new BriefView(b, this.similarItemsProfile, wskey, ((Long)limitResponse.getApiKey().getUser().getId()).longValue(), this.optOutService.check(b.getId()));
                        beans.add(view);
                    }
                }
                catch (SolrServerException e) {
                    this.log.error("Error during getting similar items: " + e.getLocalizedMessage(), (Throwable)e);
                }
                objectResult.similarItems = beans;
            }
            objectResult.object = new FullView(bean, profile, ((Long)limitResponse.getApiKey().getUser().getId()).longValue(), this.optOutService.check(bean.getId()));
            long t1 = new Date().getTime();
            objectResult.statsDuration = t1 - t0;
        }
        catch (SolrTypeException e) {
            return JsonUtils.toJson((Object)new ApiError(wskey, "record.json", e.getMessage(), limitResponse.getRequestNumber()), (String)callback);
        }
        catch (MongoDBException e) {
            return JsonUtils.toJson((Object)new ApiError(wskey, "record.json", e.getMessage(), limitResponse.getRequestNumber()), (String)callback);
        }
        return JsonUtils.toJson((Object)objectResult, (String)callback);
    }

    @RequestMapping(value={"/{collectionId}/{recordId}.kml"}, produces={"application/vnd.google-earth.kml+xml"})
    @ResponseBody
    public ApiResponse searchKml(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="apikey", required=true) String apiKey, @RequestParam(value="sessionhash", required=true) String sessionHash) {
        return new ApiNotImplementedYet(apiKey, "record.kml");
    }

    @RequestMapping(value={"/context.jsonld", "/context.json-ld"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView contextJSONLD(@RequestParam(value="callback", required=false) String callback) {
        String jsonld = JSONUtils.toString((Object)this.getJsonContext());
        return JsonUtils.toJson((String)jsonld, (String)callback);
    }

    @RequestMapping(value={"/{collectionId}/{recordId}.jsonld", "/{collectionId}/{recordId}.json-ld"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView recordJSONLD(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="format", required=false, defaultValue="compacted") String format, @RequestParam(value="callback", required=false) String callback, HttpServletRequest request, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        LimitResponse limitResponse = null;
        try {
            limitResponse = this.controllerUtils.checkLimit(wskey, request.getRequestURL().toString(), "record.jsonld", RecordType.OBJECT_JSONLD, null);
        }
        catch (ApiLimitException e) {
            response.setStatus(e.getHttpStatus());
            return JsonUtils.toJson((Object)new ApiError(e), (String)callback);
        }
        String europeanaObjectId = "/" + collectionId + "/" + recordId;
        String jsonld = null;
        FullBeanImpl bean = null;
        try {
            bean = (FullBeanImpl)this.searchService.findById(europeanaObjectId, false);
            if (bean == null) {
                bean = (FullBeanImpl)this.searchService.resolve(europeanaObjectId, false);
            }
        }
        catch (SolrTypeException e) {
            this.log.error(ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        catch (MongoDBException e) {
            this.log.error(ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        if (bean != null) {
            String rdf = EdmUtils.toEDM((FullBeanImpl)bean, (boolean)false);
            try {
                Model modelResult = ModelFactory.createDefaultModel().read(IOUtils.toInputStream((String)rdf), "", "RDF/XML");
                JenaRDFParser parser = new JenaRDFParser();
                Object raw = JSONLD.fromRDF((Object)modelResult, (RDFParser)parser);
                if (StringUtils.equalsIgnoreCase((String)format, (String)"compacted")) {
                    raw = JSONLD.compact((Object)raw, (Object)this.getJsonContext(), (Options)new Options());
                } else if (StringUtils.equalsIgnoreCase((String)format, (String)"flattened")) {
                    raw = JSONLD.flatten((Object)raw);
                } else if (StringUtils.equalsIgnoreCase((String)format, (String)"normalized")) {
                    raw = JSONLD.normalize((Object)raw);
                }
                jsonld = JSONUtils.toString((Object)raw);
            }
            catch (JSONLDProcessingError e) {
                this.log.error(e.getMessage(), (Throwable)e);
                response.setStatus(500);
            }
        } else {
            response.setStatus(404);
        }
        return JsonUtils.toJson(jsonld, (String)callback);
    }

    @RequestMapping(value={"/{collectionId}/{recordId}.rdf"}, produces={"application/rdf+xml"})
    public ModelAndView recordRdf(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="wskey", required=true) String wskey, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("error", "");
        String europeanaObjectId = "/" + collectionId + "/" + recordId;
        String requestUri = europeanaObjectId + ".rdf";
        String profile = "full";
        try {
            ApiKey apiKey = (ApiKey)this.apiService.findByID((Serializable)((Object)wskey));
            if (apiKey == null) {
                response.setStatus(401);
                model.put("error", "Unregistered user");
                return new ModelAndView("rdf", model);
            }
            apiKey.getUsageLimit();
            this.apiService.checkReachedLimit(apiKey);
        }
        catch (DatabaseException e) {
            this.apiLogService.logApiRequest(wskey, requestUri, RecordType.OBJECT_RDF, profile);
            model.put("error", e.getMessage());
            response.setStatus(401);
            return new ModelAndView("rdf", model);
        }
        catch (LimitReachedException e) {
            this.apiLogService.logApiRequest(wskey, requestUri, RecordType.LIMIT, profile);
            this.log.error(e.getMessage());
            model.put("error", e.getMessage());
            response.setStatus(429);
            return new ModelAndView("rdf", model);
        }
        FullBeanImpl bean = null;
        try {
            bean = (FullBeanImpl)this.searchService.findById(europeanaObjectId, false);
            if (bean == null) {
                bean = (FullBeanImpl)this.searchService.resolve(europeanaObjectId, false);
            }
        }
        catch (SolrTypeException e) {
            this.log.error(ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        catch (MongoDBException e) {
            this.log.error(ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        if (bean != null) {
            model.put("record", EdmUtils.toEDM((FullBeanImpl)bean, (boolean)false));
        } else {
            response.setStatus(404);
            model.put("error", "Non-existing record identifier");
        }
        this.apiLogService.logApiRequest(wskey, requestUri, RecordType.OBJECT_RDF, profile);
        return new ModelAndView("rdf", model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getJsonContext() {
        InputStream in = this.getClass().getResourceAsStream("/jsonld/context.jsonld");
        try {
            Object object = JSONUtils.fromInputStream((InputStream)in);
            return object;
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return null;
    }
}

