/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import eu.europeana.api2.utils.DefaultImageCache;
import eu.europeana.api2.v2.model.enums.DefaultImage;
import eu.europeana.corelib.db.entity.nosql.ImageCache;
import eu.europeana.corelib.db.exception.DatabaseException;
import eu.europeana.corelib.db.service.ThumbnailService;
import eu.europeana.corelib.definitions.model.ThumbSize;
import eu.europeana.corelib.definitions.solr.DocType;
import eu.europeana.corelib.definitions.solr.beans.FullBean;
import eu.europeana.corelib.solr.exceptions.MongoDBException;
import eu.europeana.corelib.solr.service.SearchService;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/image"})
public class ImageController {
    @Resource
    private ThumbnailService thumbnailService;
    @Resource
    private SearchService searchService;

    @RequestMapping(value={"/{collectionId}/{recordId}.jpg"})
    public ResponseEntity<byte[]> image(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="imageid", required=false, defaultValue="0") String imageId, @RequestParam(value="size", required=false, defaultValue="MEDIUM") ThumbSize size) {
        byte[] image = null;
        String objectId = "/" + collectionId + "/" + recordId;
        MediaType mediaType = MediaType.IMAGE_JPEG;
        if (this.thumbnailService.exists(objectId, imageId)) {
            image = this.thumbnailService.retrieveThumbnail(objectId, imageId, size);
        }
        if (image == null) {
            try {
                FullBean bean = this.searchService.findById(collectionId, recordId, false);
                if (bean != null) {
                    image = DefaultImageCache.getImage((DocType)bean.getType());
                    mediaType = MediaType.IMAGE_GIF;
                }
            }
            catch (MongoDBException e) {
                // empty catch block
            }
        }
        if (image == null) {
            image = DefaultImage.UNKNOWN.getCache();
            mediaType = MediaType.IMAGE_PNG;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(mediaType);
        return new ResponseEntity((Object)image, (MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(value={"/image"})
    public void imageRedirect(HttpServletResponse response, @RequestParam(value="uri", required=false) String uri, @RequestParam(value="size", required=false) String sizeString) {
        ImageCache imageCache = null;
        if (StringUtils.isBlank((String)sizeString)) {
            sizeString = ThumbSize.LARGE.toString();
        } else if (StringUtils.equalsIgnoreCase((String)sizeString, (String)"BRIEF_DOC")) {
            sizeString = ThumbSize.MEDIUM.toString();
        } else if (StringUtils.equalsIgnoreCase((String)sizeString, (String)"FULL_DOC")) {
            sizeString = ThumbSize.LARGE.toString();
        }
        try {
            imageCache = this.thumbnailService.findByOriginalUrl(uri);
        }
        catch (DatabaseException e) {
            // empty catch block
        }
        String objectId = imageCache != null ? imageCache.getObjectId() : "";
        StringBuilder sb = new StringBuilder();
        sb.append("/image/");
        sb.append(objectId);
        sb.append("?size=");
        sb.append(sizeString);
        response.setStatus(301);
        response.setHeader("Location", sb.toString());
        response.setHeader("Connection", "close");
    }
}

