/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.utils;

import eu.europeana.api2.v2.model.json.common.LabelFrequency;
import eu.europeana.api2.v2.model.json.view.submodel.Facet;
import eu.europeana.api2.v2.model.json.view.submodel.SpellCheck;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.SpellCheckResponse;

public class ModelUtils {
    private ModelUtils() {
    }

    public static List<Facet> conventFacetList(List<FacetField> facetFields) {
        if (facetFields != null && !facetFields.isEmpty()) {
            ArrayList<Facet> facets = new ArrayList<Facet>();
            for (FacetField facetField : facetFields) {
                if (facetField.getValues() == null) continue;
                Facet facet = new Facet();
                facet.name = facetField.getName();
                for (FacetField.Count count : facetField.getValues()) {
                    if (!StringUtils.isNotEmpty((String)count.getName()) || count.getCount() <= 0L) continue;
                    LabelFrequency value = new LabelFrequency();
                    value.label = count.getName();
                    value.count = count.getCount();
                    facet.fields.add(value);
                }
                if (facet.fields.isEmpty()) continue;
                facets.add(facet);
            }
            return facets;
        }
        return null;
    }

    public static SpellCheck convertSpellCheck(SpellCheckResponse response) {
        if (response != null) {
            SpellCheck spellCheck = new SpellCheck();
            spellCheck.correctlySpelled = response.isCorrectlySpelled();
            for (SpellCheckResponse.Suggestion suggestion : response.getSuggestions()) {
                for (int i = 0; i < suggestion.getNumFound(); ++i) {
                    LabelFrequency value = new LabelFrequency();
                    value.label = (String)suggestion.getAlternatives().get(i);
                    value.count = ((Integer)suggestion.getAlternativeFrequencies().get(i)).longValue();
                    spellCheck.suggestions.add(value);
                }
            }
            return spellCheck;
        }
        return null;
    }
}

