/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.utils;

import eu.europeana.api2.v2.model.NumericFacetParameter;
import eu.europeana.corelib.definitions.solr.Facet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class FacetParameterUtils {
    static final String DEFAULT_LIMIT_KEY = "f.DEFAULT.facet.limit";
    static final String DEFAULT_OFFSET_KEY = "f.DEFAULT.facet.offset";
    static final int LIMIT_FOR_DATA_PROVIDER = 3000;
    static final int LIMIT_FOR_DEFAULT = 750;
    static final int LIMIT_FOR_CUSTOM = 50;
    private static List<String> facetList;

    public static Map<String, Integer> getFacetParams(String type, String[] facets, Map<String, String[]> parameters, boolean isDefaultFacetsRequested) {
        FacetParameterUtils.createFacetList();
        HashMap<String, Integer> facetParams = new HashMap<String, Integer>();
        if (isDefaultFacetsRequested) {
            for (Facet facet : Facet.values()) {
                FacetParameterUtils.saveFacetParam((String)type, (String)facet.name(), parameters, (boolean)true, facetParams);
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])facets)) {
            for (String string : facets) {
                FacetParameterUtils.saveFacetParam((String)type, (String)string, parameters, (boolean)facetList.contains(string), facetParams);
            }
        }
        return facetParams;
    }

    public static void createFacetList() {
        if (facetList == null) {
            facetList = new ArrayList();
            for (Facet facet : Facet.values()) {
                facetList.add(facet.toString());
            }
        }
    }

    public static void saveFacetParam(String type, String name, Map<String, String[]> parameters, boolean isDefault, Map<String, Integer> facetParams) {
        NumericFacetParameter parameter = null;
        if (type.equals("limit")) {
            parameter = FacetParameterUtils.getFacetLimit((String)name, parameters, (boolean)isDefault);
        } else if (type.equals("offset")) {
            parameter = FacetParameterUtils.getFacetOffset((String)name, parameters, (boolean)isDefault);
        }
        if (parameter != null) {
            facetParams.put(parameter.getName(), parameter.getValue());
        }
    }

    public static NumericFacetParameter getFacetLimit(String facet, Map<String, String[]> parameters, boolean isDefault) {
        String key = "f." + facet + ".facet.limit";
        Integer defaultLimit = isDefault ? (StringUtils.equals((String)facet, (String)"DATA_PROVIDER") ? 3000 : 750) : 50;
        return FacetParameterUtils.extractParameter((String)key, (String)"f.DEFAULT.facet.limit", parameters, (boolean)isDefault, (Integer)defaultLimit);
    }

    public static NumericFacetParameter getFacetOffset(String facet, Map<String, String[]> parameters, boolean isDefault) {
        String key = "f." + facet + ".facet.offset";
        return FacetParameterUtils.extractParameter((String)key, (String)"f.DEFAULT.facet.offset", parameters, (boolean)isDefault, null);
    }

    public static NumericFacetParameter extractParameter(String key, String defaultKey, Map<String, String[]> parameters, boolean isDefault, Integer defaultValue) {
        if (parameters.containsKey(key)) {
            String[] value = parameters.get(key);
            return new NumericFacetParameter(key, value[0]);
        }
        if (isDefault && parameters.containsKey(defaultKey)) {
            String[] value = parameters.get(defaultKey);
            return new NumericFacetParameter(key, value[0]);
        }
        if (defaultValue != null) {
            return new NumericFacetParameter(key, defaultValue);
        }
        return null;
    }
}

