/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.utils;

import eu.europeana.api2.model.enums.ApiLimitException;
import eu.europeana.api2.v2.model.LimitResponse;
import eu.europeana.corelib.db.entity.enums.RecordType;
import eu.europeana.corelib.db.exception.DatabaseException;
import eu.europeana.corelib.db.exception.LimitReachedException;
import eu.europeana.corelib.db.service.ApiKeyService;
import eu.europeana.corelib.db.service.ApiLogService;
import eu.europeana.corelib.definitions.db.entity.relational.ApiKey;
import java.io.Serializable;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

public class ControllerUtils {
    @Resource
    private ApiKeyService apiService;
    @Resource
    private ApiLogService apiLogService;

    public LimitResponse checkLimit(String wskey, String url, String apiCall, RecordType recordType, String profile) throws ApiLimitException {
        ApiKey apiKey = null;
        long requestNumber = 0L;
        try {
            apiKey = (ApiKey)this.apiService.findByID((Serializable)((Object)wskey));
            if (apiKey == null) {
                throw new ApiLimitException(wskey, apiCall, "Unregistered user", 0L, 401);
            }
            apiKey.getUsageLimit();
            requestNumber = this.apiService.checkReachedLimit(apiKey);
            this.apiLogService.logApiRequest(wskey, url, recordType, profile);
        }
        catch (DatabaseException e) {
            this.apiLogService.logApiRequest(wskey, url, recordType, profile);
            throw new ApiLimitException(wskey, apiCall, e.getMessage(), requestNumber, 401);
        }
        catch (LimitReachedException e) {
            this.apiLogService.logApiRequest(wskey, url, RecordType.LIMIT, recordType.toString());
            throw new ApiLimitException(wskey, apiCall, e.getMessage(), requestNumber, 429);
        }
        return new LimitResponse(apiKey, requestNumber);
    }

    public void addResponseHeaders(HttpServletResponse response) {
        this.addCharacterEncoding(response);
        this.addAccessControlHeaders(response);
    }

    public void addCharacterEncoding(HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
    }

    public void addAccessControlHeaders(HttpServletResponse response) {
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.addHeader("Access-Control-Allow-Methods", "POST");
        response.addHeader("Access-Control-Max-Age", "1000");
    }
}

