/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v1.web.controller;

import eu.europeana.api2.model.json.ApiError;
import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.v1.model.json.SearchResults;
import eu.europeana.api2.v1.model.json.view.BriefDoc;
import eu.europeana.api2.v2.model.xml.rss.Channel;
import eu.europeana.api2.v2.model.xml.rss.Enclosure;
import eu.europeana.api2.v2.model.xml.rss.Item;
import eu.europeana.api2.v2.model.xml.rss.RssResponse;
import eu.europeana.corelib.db.service.ApiKeyService;
import eu.europeana.corelib.db.service.UserService;
import eu.europeana.corelib.definitions.solr.beans.ApiBean;
import eu.europeana.corelib.definitions.solr.beans.IdBean;
import eu.europeana.corelib.definitions.solr.model.Query;
import eu.europeana.corelib.logging.Log;
import eu.europeana.corelib.logging.Logger;
import eu.europeana.corelib.solr.exceptions.SolrTypeException;
import eu.europeana.corelib.solr.model.ResultSet;
import eu.europeana.corelib.solr.service.SearchService;
import eu.europeana.corelib.solr.utils.SolrUtils;
import eu.europeana.corelib.utils.service.OptOutService;
import eu.europeana.corelib.web.service.EuropeanaUrlService;
import eu.europeana.corelib.web.utils.UrlBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.solr.common.SolrException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SearchController1 {
    @Log
    private Logger log;
    @Resource(name="corelib_db_userService")
    private UserService userService;
    @Resource
    private SearchService searchService;
    @Resource
    private ApiKeyService apiService;
    @Resource
    private OptOutService optOutService;
    @Resource
    private EuropeanaUrlService urlService;
    private static final int RESULT_ROWS_PER_PAGE = 12;
    private static final String DESCRIPTION_SUFFIX = " - Europeana Open Search";

    @RequestMapping(value={"/opensearch.json", "/v1/search.json"}, produces={"application/json"})
    public ModelAndView search2Json(@RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="searchTerms", required=true) String queryString, @RequestParam(value="startPage", required=false, defaultValue="1") int start, @RequestParam(value="callback", required=false) String callback, HttpServletResponse response) throws Exception {
        ModelAndView mov;
        if (StringUtils.isBlank((String)wskey)) {
            response.setStatus(401);
            mov = JsonUtils.toJson((Object)new ApiError(wskey, "search.json", "No API authorisation key."), (String)callback);
        } else if (this.userService.findByApiKey(wskey) == null && this.apiService.findByID((Serializable)((Object)wskey)) == null) {
            response.setStatus(401);
            mov = JsonUtils.toJson((Object)new ApiError(wskey, "search.json", "Unregistered user"), (String)callback);
        } else {
            this.log.info("opensearch.json");
            Query query = new Query(SolrUtils.rewriteQueryFields((String)queryString)).setApiQuery(true).setPageSize(12).setStart(start - 1).setAllowSpellcheck(false).setAllowFacets(false);
            Class<ApiBean> clazz = ApiBean.class;
            try {
                SearchResults result = this.createResultsForApi1(wskey, query, clazz);
                result.startIndex = start;
                result.description = queryString + DESCRIPTION_SUFFIX;
                result.link = this.urlService.getApi1SearchJson(wskey, queryString, start).toString();
                this.log.info("got response " + result.items.size());
                mov = JsonUtils.toJson((Object)result, (String)callback);
            }
            catch (SolrTypeException e) {
                this.logException((Exception)((Object)e));
                mov = JsonUtils.toJson((Object)new ApiError(wskey, "search.json", "Internal Server Error. Something is broken."), (String)callback);
                response.setStatus(500);
            }
            catch (Exception e) {
                this.logException(e);
                mov = JsonUtils.toJson((Object)new ApiError(wskey, "search.json", "Internal Server Error. Something is broken."), (String)callback);
                response.setStatus(500);
            }
        }
        return mov;
    }

    @RequestMapping(value={"/opensearch.rss", "/v1/opensearch.rss"}, produces={"application/rss+xml"})
    @ResponseBody
    public RssResponse openSearchControllerRSS(@RequestParam(value="searchTerms", required=false) String queryString, @RequestParam(value="startPage", required=false, defaultValue="1") String startPage, @RequestParam(value="wskey", required=false, defaultValue="") String wskey, HttpServletResponse response) throws Exception {
        this.log.info("===== openSearchControllerRSS =====");
        response.setCharacterEncoding("UTF-8");
        UrlBuilder url = this.urlService.getApi1Home(null).addPage("opensearch.rss");
        url.addParam("searchTerms", queryString);
        url.addParam("startPage", startPage);
        RssResponse rss = new RssResponse();
        Channel channel = rss.channel;
        channel.startIndex.value = Integer.parseInt(startPage);
        channel.itemsPerPage.value = 12L;
        channel.query.searchTerms = queryString;
        channel.query.startPage = Integer.parseInt(startPage);
        channel.setLink("http://www.europeana.eu");
        channel.atomLink.href = url.toString();
        channel.updateDescription();
        try {
            if (this.log.isInfoEnabled()) {
                this.log.info(queryString + ", " + 12 + ", " + (Integer.parseInt(startPage) - 1));
            }
            Query query = new Query(SolrUtils.rewriteQueryFields((String)queryString)).setApiQuery(true).setPageSize(12).setStart(Integer.parseInt(startPage) - 1).setAllowSpellcheck(false).setAllowFacets(false);
            Class<ApiBean> clazz = ApiBean.class;
            SearchResults resultSet = this.createResultsForRSS(wskey, query, clazz);
            channel.totalResults.value = resultSet.totalResults;
            for (BriefDoc bean : resultSet.items) {
                Item item = new Item();
                item.guid = bean.getGuid();
                item.title = this.getTitle(bean);
                item.link = bean.getLink(1);
                item.description = bean.getDescription();
                String enclosure = bean.getThumbnail();
                if (enclosure != null) {
                    item.enclosure = new Enclosure(enclosure);
                }
                item.dcCreator = bean.getCreator();
                item.dcTermsHasPart = bean.getDcTermsHasPart();
                item.dcTermsIsPartOf = bean.getDcTermsIsPartOf();
                item.europeanaYear = bean.getYear();
                item.europeanaLanguage = bean.getLanguage();
                item.europeanaType = bean.getType();
                item.europeanaProvider = bean.getProvider();
                item.europeanaDataProvider = bean.getDataProvider();
                item.europeanaRights = bean.getEuropeanaRights();
                item.enrichmentPlaceLatitude = Float.valueOf(bean.getEnrichmentPlaceLatitude());
                item.enrichmentPlaceLongitude = Float.valueOf(bean.getEnrichmentPlaceLongitude());
                item.enrichmentPlaceTerm = bean.getEnrichmentPlaceTerm();
                item.enrichmentPlaceLabel = bean.getEnrichmentPlaceLabel();
                item.enrichmentPeriodTerm = bean.getEnrichmentPeriodTerm();
                item.enrichmentPeriodLabel = bean.getEnrichmentPeriodLabel();
                item.enrichmentPeriodBegin = bean.getEnrichmentPeriodBegin();
                item.enrichmentPeriodEnd = bean.getEnrichmentPeriodEnd();
                item.enrichmentAgentTerm = bean.getEnrichmentAgentLabel();
                item.enrichmentAgentLabel = bean.getEnrichmentAgentLabel();
                item.enrichmentConceptTerm = bean.getEnrichmentConceptTerm();
                item.enrichmentConceptLabel = bean.getEnrichmentConceptLabel();
                channel.items.add(item);
            }
            response.setStatus(200);
        }
        catch (SolrTypeException e) {
            this.log.error(e.getMessage());
            channel.totalResults.value = 0L;
            Item item = new Item();
            item.title = "Error";
            item.description = e.getMessage();
            channel.items.add(item);
        }
        catch (SolrException e) {
            this.log.error(e.getMessage());
            channel.totalResults.value = 0L;
            Item item = new Item();
            item.title = "Error";
            item.description = e.getMessage();
            channel.items.add(item);
        }
        return rss;
    }

    private String getTitle(BriefDoc bean) {
        if (!StringUtils.isEmpty((String)bean.getTitle())) {
            return bean.getTitle();
        }
        return bean.getDataProvider() + " " + bean.getUrl();
    }

    private <T extends IdBean> SearchResults<Map<String, Object>> createResultsForApi1(String wskey, Query q, Class<T> clazz) throws SolrTypeException {
        SearchResults response = new SearchResults(wskey, "search.json");
        ResultSet resultSet = this.searchService.search(clazz, q);
        response.totalResults = resultSet.getResultSize();
        response.itemsPerPage = resultSet.getResults().size();
        ArrayList<Map> items = new ArrayList<Map>();
        for (IdBean o : resultSet.getResults()) {
            ApiBean bean = (ApiBean)o;
            BriefDoc doc = new BriefDoc(bean, this.optOutService.check(bean.getId()), this.urlService);
            doc.setWskey(wskey);
            items.add(doc.asMap());
        }
        response.items = items;
        if (this.log.isInfoEnabled()) {
            this.log.info("response: " + response);
        }
        return response;
    }

    private SearchResults<BriefDoc> createResultsForRSS(String wskey, Query q, Class<? extends IdBean> clazz) throws SolrTypeException {
        SearchResults response = new SearchResults(wskey, "search.json");
        ResultSet resultSet = this.searchService.search(clazz, q);
        response.totalResults = resultSet.getResultSize();
        response.itemsPerPage = resultSet.getResults().size();
        ArrayList<BriefDoc> items = new ArrayList<BriefDoc>();
        for (IdBean o : resultSet.getResults()) {
            ApiBean bean = (ApiBean)o;
            BriefDoc doc = new BriefDoc(bean, this.optOutService.check(bean.getId()), this.urlService);
            doc.setWskey(wskey);
            items.add(doc);
        }
        response.items = items;
        return response;
    }

    private void logException(Exception e) {
        if (this.log.isErrorEnabled()) {
            this.log.error(ExceptionUtils.getRootCauseMessage((Throwable)e));
            this.log.error(ExceptionUtils.getFullStackTrace((Throwable)e));
        }
    }
}

