/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v1.web.controller;

import eu.europeana.api2.model.json.ApiError;
import eu.europeana.api2.model.xml.srw.SrwResponse;
import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.v1.model.json.view.FullDoc;
import eu.europeana.api2.v2.model.xml.srw.Record;
import eu.europeana.corelib.db.service.ApiKeyService;
import eu.europeana.corelib.db.service.UserService;
import eu.europeana.corelib.definitions.exception.ProblemType;
import eu.europeana.corelib.definitions.solr.beans.FullBean;
import eu.europeana.corelib.logging.Log;
import eu.europeana.corelib.logging.Logger;
import eu.europeana.corelib.solr.exceptions.EuropeanaQueryException;
import eu.europeana.corelib.solr.service.SearchService;
import eu.europeana.corelib.web.service.EuropeanaUrlService;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/v1/record"})
public class ObjectController1 {
    @Log
    private Logger log;
    @Resource(name="corelib_db_userService")
    private UserService userService;
    @Resource
    private ApiKeyService apiService;
    @Resource
    private SearchService searchService;
    @Resource
    private EuropeanaUrlService urlService;
    static String portalPath;

    @Transactional
    @RequestMapping(value={"/{collectionId}/{recordId}.json"}, produces={"application/json"})
    public ModelAndView recordJson(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="wskey", required=false) String wskey, @RequestParam(value="callback", required=false) String callback, HttpServletResponse response) throws Exception {
        this.log.info("====== /v1/record/{collectionId}/{recordId}.json ======");
        if (StringUtils.isBlank((String)wskey)) {
            response.setStatus(401);
            return JsonUtils.toJson((Object)new ApiError(wskey, "record.json", "No API authorisation key."), (String)callback);
        }
        if (this.userService.findByApiKey(wskey) == null && this.apiService.findByID((Serializable)((Object)wskey)) == null) {
            response.setStatus(401);
            return JsonUtils.toJson((Object)new ApiError(wskey, "record.json", "Unregistered user"), (String)callback);
        }
        String europeanaObjectId = "/" + collectionId + "/" + recordId;
        FullBean bean = this.searchService.findById(europeanaObjectId, true);
        if (bean == null) {
            bean = this.searchService.resolve(europeanaObjectId, true);
        }
        if (bean != null) {
            return JsonUtils.toJson((Object)new FullDoc(bean).asMap(), (String)callback);
        }
        response.setStatus(404);
        return JsonUtils.toJson((Object)new ApiError(wskey, "record.json", "not found error"), (String)callback);
    }

    @Transactional
    @RequestMapping(value={"/{collectionId}/{recordId}.srw"}, produces={"text/xml"})
    @ResponseBody
    public SrwResponse recordSrw(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="wskey", required=false) String wskey, HttpServletResponse response) throws Exception {
        this.log.info("====== /v1/record/{collectionId}/{recordId}.srw ======");
        boolean hasResult = false;
        if (!hasResult && StringUtils.isBlank((String)wskey)) {
            throw new EuropeanaQueryException(ProblemType.NO_PASSWORD);
        }
        if (!hasResult && this.userService.findByApiKey(wskey) == null && this.apiService.findByID((Serializable)((Object)wskey)) == null) {
            throw new EuropeanaQueryException(ProblemType.NO_PASSWORD);
        }
        if (!hasResult) {
            String europeanaObjectId = "/" + collectionId + "/" + recordId;
            FullBean bean = this.searchService.findById(europeanaObjectId, true);
            if (bean == null) {
                bean = this.searchService.resolve(europeanaObjectId, true);
            }
            SrwResponse srwResponse = new SrwResponse();
            FullDoc doc = null;
            if (bean == null) {
                String url = this.urlService.getPortalRecord(true, collectionId, recordId).toString();
                response.setStatus(302);
                response.setHeader("Location", url);
                return null;
            }
            doc = new FullDoc(bean);
            Record record = new Record();
            record.recordData.dc = doc;
            srwResponse.records.record.add(record);
            this.log.info("record added");
            this.createXml(srwResponse);
            this.log.info("xml created");
            return srwResponse;
        }
        return null;
    }

    private void createXml(SrwResponse response) {
        block3: {
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{SrwResponse.class});
                Marshaller marshaller = context.createMarshaller();
                StringWriter stringWriter = new StringWriter();
                marshaller.marshal((Object)response, (Writer)stringWriter);
                if (this.log.isInfoEnabled()) {
                    this.log.info("result: " + stringWriter.toString());
                }
            }
            catch (JAXBException e) {
                if (!this.log.isErrorEnabled()) break block3;
                this.log.error("JAXBException: " + e.getMessage() + ", " + e.getCause().getMessage(), (Throwable)e);
            }
        }
    }
}

