/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.utils;

import com.github.jsonldjava.utils.JSONUtils;
import eu.europeana.corelib.logging.Logger;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.springframework.web.servlet.ModelAndView;

/*
 * Exception performing whole class analysis ignored.
 */
public class JsonUtils {
    private static final Logger log = Logger.getLogger(JSONUtils.class);

    public static ModelAndView toJson(Object object) {
        return JsonUtils.toJson((Object)object, null);
    }

    public static ModelAndView toJson(String json, String callback) {
        String resultPage = "json";
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("json", json);
        if (StringUtils.isNotBlank((String)callback)) {
            resultPage = "jsonp";
            model.put("callback", callback);
        }
        return new ModelAndView(resultPage, model);
    }

    public static ModelAndView toJson(Object object, String callback) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        try {
            return JsonUtils.toJson((String)objectMapper.writeValueAsString(object), (String)callback);
        }
        catch (JsonGenerationException e) {
            log.error("Json Generation Exception: " + e.getMessage(), (Throwable)e);
        }
        catch (JsonMappingException e) {
            log.error("Json Mapping Exception: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error("I/O Exception: " + e.getMessage(), (Throwable)e);
        }
        String resultPage = "json";
        HashMap<String, String> model = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)callback)) {
            resultPage = "jsonp";
            model.put("callback", callback);
        }
        return new ModelAndView(resultPage, model);
    }
}

