/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2demo.web.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.europeana.api2.v2.model.json.ModificationConfirmation;
import eu.europeana.api2demo.Config;
import eu.europeana.api2demo.web.model.TagCloud;
import eu.europeana.api2demo.web.model.UserProfile;
import eu.europeana.api2demo.web.model.UserSavedItems;
import eu.europeana.api2demo.web.model.UserSearches;
import eu.europeana.api2demo.web.model.UserTags;
import eu.europeana.api2demo.web.service.Api2UserService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestOperations;

@Service
public class Api2UserServiceImpl
implements Api2UserService {
    @Resource(name="myEuropeanaRestTemplate")
    private RestOperations restTemplate;
    @Resource
    private Config config;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T getJson(String uri, Class<T> clazz) {
        try (ByteArrayInputStream is = new ByteArrayInputStream((byte[])this.restTemplate.getForObject(URI.create(uri), byte[].class));){
            Object object = new ObjectMapper().readValue((InputStream)is, clazz);
            return (T)object;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T postJson(String uri, Class<T> clazz) {
        try (ByteArrayInputStream is = new ByteArrayInputStream((byte[])this.restTemplate.postForObject(URI.create(uri), null, byte[].class));){
            Object object = new ObjectMapper().readValue((InputStream)is, clazz);
            return (T)object;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void deleteJson(String uri) {
        this.restTemplate.delete(URI.create(uri));
    }

    public UserProfile getProfile() {
        return (UserProfile)this.getJson(this.config.getUriProfile(), UserProfile.class);
    }

    public UserSavedItems getSavedItems() {
        return (UserSavedItems)this.getJson(this.config.getUriSavedItemGet(), UserSavedItems.class);
    }

    public boolean createSavedItem(String id) {
        ModificationConfirmation result = (ModificationConfirmation)this.postJson(this.config.getUriSavedItemCreate() + id, ModificationConfirmation.class);
        return result != null && result.success;
    }

    public void deleteSavedItem(Long id) {
        this.deleteJson(this.config.getUriSavedItemDelete() + id.toString());
    }

    public UserTags getTags(String tag) {
        StringBuilder url = new StringBuilder(this.config.getUriTagsGet());
        if (StringUtils.isNotBlank((CharSequence)tag)) {
            url.append("?tag=").append(tag);
        }
        return (UserTags)this.getJson(url.toString(), UserTags.class);
    }

    public TagCloud createTagCloud() {
        return (TagCloud)this.postJson(this.config.getUriTagsTagcloud(), TagCloud.class);
    }

    public boolean createTag(String id, String tag) {
        return false;
    }

    public void deleteTag(Long id) {
        this.deleteJson(this.config.getUriTagsDelete() + id.toString());
    }

    public UserSearches getSavedSearches() {
        return (UserSearches)this.getJson(this.config.getUriSearchesGet(), UserSearches.class);
    }

    public void deleteSavedSearch(Long id) {
        this.deleteJson(this.config.getUriSearchesDelete() + id.toString());
    }
}

