/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2demo.config;

import eu.europeana.api2demo.config.WebMvcConfig;
import eu.europeana.api2demo.config.WebSecurityConfig;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.filter.DelegatingFilterProxy;
import org.springframework.web.servlet.support.AbstractDispatcherServletInitializer;

public class ServletInitializer
extends AbstractDispatcherServletInitializer {
    public void onStartup(ServletContext container) throws ServletException {
        super.onStartup(container);
        this.registerProxyFilter(container, "springSecurityFilterChain");
        this.registerProxyFilter(container, "oauth2ClientContextFilter");
    }

    protected WebApplicationContext createRootApplicationContext() {
        return null;
    }

    protected WebApplicationContext createServletApplicationContext() {
        AnnotationConfigWebApplicationContext context = new AnnotationConfigWebApplicationContext();
        context.register(new Class[]{WebSecurityConfig.class, WebMvcConfig.class});
        return context;
    }

    protected String[] getServletMappings() {
        return new String[]{"/"};
    }

    private void registerProxyFilter(ServletContext servletContext, String name) {
        DelegatingFilterProxy filter = new DelegatingFilterProxy(name);
        filter.setContextAttribute("org.springframework.web.servlet.FrameworkServlet.CONTEXT.dispatcher");
        servletContext.addFilter(name, (Filter)filter).addMappingForUrlPatterns(null, false, new String[]{"/*"});
    }
}

