/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2demo.web.controller;

import eu.europeana.api2demo.web.model.TagCloud;
import eu.europeana.api2demo.web.model.UserProfile;
import eu.europeana.api2demo.web.model.UserSavedItems;
import eu.europeana.api2demo.web.model.UserSearches;
import eu.europeana.api2demo.web.model.UserTags;
import eu.europeana.api2demo.web.service.Api2UserService;
import java.util.HashMap;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/user"})
public class UserController {
    @Resource
    private Api2UserService api2UserService;

    @RequestMapping(value={"/"})
    public ModelAndView profile() {
        UserProfile profile = this.api2UserService.getProfile();
        HashMap<String, UserProfile> model = new HashMap<String, UserProfile>();
        model.put("profile", profile);
        return new ModelAndView("user/profile", model);
    }

    @RequestMapping(value={"/saveditems"}, params={"!action"})
    public ModelAndView items() {
        UserSavedItems userSavedItems = this.api2UserService.getSavedItems();
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("items", userSavedItems.items);
        model.put("username", userSavedItems.username);
        return new ModelAndView("user/saveditems", model);
    }

    @RequestMapping(value={"/saveditems"}, params={"action=DELETE"}, method={RequestMethod.GET})
    public ModelAndView itemsDelete(@RequestParam(value="id", required=true) Long objectId) {
        this.api2UserService.deleteSavedItem(objectId);
        return this.items();
    }

    @RequestMapping(value={"/tags"}, params={"!action"})
    public ModelAndView tags(@RequestParam(value="tag", required=false) String tag) {
        UserTags userTags = this.api2UserService.getTags(tag);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("items", userTags.items);
        model.put("username", userTags.username);
        return new ModelAndView("user/tags", model);
    }

    @RequestMapping(value={"/tagcloud"}, params={"!action"})
    public ModelAndView tagcloud() {
        TagCloud tagCloud = this.api2UserService.createTagCloud();
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("items", tagCloud.items);
        model.put("username", tagCloud.username);
        return new ModelAndView("user/tagcloud", model);
    }

    @RequestMapping(value={"/tags"}, params={"action=DELETE"}, method={RequestMethod.GET})
    public ModelAndView tagsDelete(@RequestParam(value="id", required=true) Long objectId) {
        this.api2UserService.deleteTag(objectId);
        return this.tags(null);
    }

    @RequestMapping(value={"/searches"}, params={"!action"})
    public ModelAndView searches() {
        UserSearches userSearches = this.api2UserService.getSavedSearches();
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("items", userSearches.items);
        model.put("username", userSearches.username);
        return new ModelAndView("user/searches", model);
    }

    @RequestMapping(value={"/searches"}, params={"action=DELETE"}, method={RequestMethod.GET})
    public ModelAndView searchesDelete(@RequestParam(value="id", required=true) Long objectId) {
        this.api2UserService.deleteSavedSearche(objectId);
        return this.searches();
    }
}

