/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2demo.web.service.impl;

import eu.europeana.api2.v2.model.json.UserModification;
import eu.europeana.api2demo.Config;
import eu.europeana.api2demo.web.model.TagCloud;
import eu.europeana.api2demo.web.model.UserProfile;
import eu.europeana.api2demo.web.model.UserSavedItems;
import eu.europeana.api2demo.web.model.UserSearches;
import eu.europeana.api2demo.web.model.UserTags;
import eu.europeana.api2demo.web.service.Api2UserService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.web.client.RestOperations;

public class Api2UserServiceImpl
implements Api2UserService {
    private RestOperations restTemplate;
    @Resource
    private Config config;

    private <T> T readJson(String uri, Class<T> clazz) {
        ByteArrayInputStream is = new ByteArrayInputStream((byte[])this.restTemplate.getForObject(URI.create(uri), byte[].class));
        try {
            return (T)new ObjectMapper().readValue((InputStream)is, clazz);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public UserProfile getProfile() {
        return (UserProfile)this.readJson(this.config.getUriProfile(), UserProfile.class);
    }

    public UserSavedItems getSavedItems() {
        return (UserSavedItems)this.readJson(this.config.getUriSavedItemGet(), UserSavedItems.class);
    }

    public boolean createSavedItem(String id) {
        UserModification result = (UserModification)this.readJson(this.config.getUriSavedItemCreate() + id, UserModification.class);
        return result != null ? result.success : false;
    }

    public void deleteSavedItem(Long id) {
        this.restTemplate.delete(URI.create(this.config.getUriSavedItemDelete() + id.toString()));
    }

    public UserTags getTags(String tag) {
        StringBuilder url = new StringBuilder(this.config.getUriTagsGet());
        if (StringUtils.isNotBlank((String)tag)) {
            url.append("?tag=").append(tag);
        }
        return (UserTags)this.readJson(url.toString(), UserTags.class);
    }

    public TagCloud createTagCloud() {
        return (TagCloud)this.readJson(this.config.getUriTagsTagcloud(), TagCloud.class);
    }

    public boolean createTag(String id, String tag) {
        return false;
    }

    public boolean deleteTag(Long id) {
        UserModification result = (UserModification)this.readJson(this.config.getUriTagsDelete() + id.toString(), UserModification.class);
        return result != null ? result.success : false;
    }

    public UserSearches getSavedSearches() {
        return (UserSearches)this.readJson(this.config.getUriSearchesGet(), UserSearches.class);
    }

    public boolean deleteSavedSearche(Long id) {
        UserModification result = (UserModification)this.readJson(this.config.getUriSearchesDelete() + id.toString(), UserModification.class);
        return result != null ? result.success : false;
    }

    public void setRestTemplate(OAuth2RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}

