/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.translation.web.service;

import eu.europeana.api.commons.error.EuropeanaI18nApiException;
import eu.europeana.api.translation.config.TranslationConfig;
import eu.europeana.api.translation.config.TranslationServiceProvider;
import eu.europeana.api.translation.config.services.TranslationLangPairCfg;
import eu.europeana.api.translation.definitions.language.LanguagePair;
import eu.europeana.api.translation.definitions.model.TranslationObj;
import eu.europeana.api.translation.definitions.model.TranslationRequest;
import eu.europeana.api.translation.definitions.model.TranslationResponse;
import eu.europeana.api.translation.service.TranslationService;
import eu.europeana.api.translation.service.exception.TranslationException;
import eu.europeana.api.translation.web.exception.ParamValidationException;
import eu.europeana.api.translation.web.service.BaseWebService;
import eu.europeana.api.translation.web.service.CachedTranslationService;
import eu.europeana.api.translation.web.service.RedisCacheService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TranslationWebService
extends BaseWebService {
    @Autowired
    protected TranslationConfig translationConfig;
    @Autowired
    private final TranslationServiceProvider translationServiceProvider;
    private RedisCacheService redisCacheService;
    private final Logger logger = LogManager.getLogger(this.getClass());

    @Autowired
    public TranslationWebService(TranslationServiceProvider translationServiceProvider) {
        this.translationServiceProvider = translationServiceProvider;
    }

    public TranslationResponse translate(TranslationRequest translationRequest) throws EuropeanaI18nApiException {
        List translObjs = this.buildTranslationObjectList(translationRequest);
        try {
            this.translationServiceProvider.getTranslationServicePreProcessor().translate(translObjs);
        }
        catch (TranslationException e) {
            this.logger.error("Error during the pre processing ", (Throwable)e);
        }
        LanguagePair languagePair = new LanguagePair(translationRequest.getSource(), translationRequest.getTarget());
        TranslationService translationService = this.selectTranslationService(translationRequest, languagePair);
        TranslationService fallback = null;
        if (translationRequest.getFallback() != null) {
            fallback = this.getTranslationService(translationRequest.getFallback(), languagePair, true);
        }
        List cachedTranslationServices = this.buildCachedTranslationServices(translationRequest.useCaching(), translationService, fallback);
        TranslationException translationError = null;
        String serviceId = null;
        for (TranslationService cachedTranslationService : cachedTranslationServices) {
            try {
                serviceId = cachedTranslationService.getServiceId();
                cachedTranslationService.translate(translObjs.stream().filter(to -> !to.isTranslated()).collect(Collectors.toList()));
                serviceId = cachedTranslationService.getServiceId();
                translationError = null;
                break;
            }
            catch (TranslationException ex) {
                if (translationError == null) {
                    translationError = ex;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Error when calling translation service: " + serviceId, (Throwable)ex);
            }
        }
        if (translationError != null) {
            this.throwApiException(translationError);
        }
        return this.buildTranslationResponse(translationRequest, translObjs, serviceId);
    }

    private TranslationResponse buildTranslationResponse(TranslationRequest translationRequest, List<TranslationObj> translObjs, String serviceId) {
        TranslationResponse result = new TranslationResponse();
        result.setTranslations(translObjs.stream().map(el -> el.getTranslation()).collect(Collectors.toList()));
        result.setLang(translationRequest.getTarget());
        result.setService(serviceId);
        return result;
    }

    private List<TranslationService> buildCachedTranslationServices(boolean useCaching, TranslationService translationService, TranslationService fallback) {
        ArrayList<TranslationService> cachedTranslationServices = new ArrayList<TranslationService>();
        cachedTranslationServices.add((TranslationService)this.instantiateCachedTranslationService(useCaching, translationService));
        if (fallback != null) {
            cachedTranslationServices.add((TranslationService)this.instantiateCachedTranslationService(useCaching, fallback));
        }
        return cachedTranslationServices;
    }

    CachedTranslationService instantiateCachedTranslationService(boolean useCaching, TranslationService translationService) {
        if (useCaching) {
            return new CachedTranslationService(this.redisCacheService, translationService);
        }
        return new CachedTranslationService(null, translationService);
    }

    private List<TranslationObj> buildTranslationObjectList(TranslationRequest translationRequest) {
        ArrayList<TranslationObj> translObjs = new ArrayList<TranslationObj>(translationRequest.getText().size());
        if (this.shouldTruncateText(translationRequest)) {
            this.limitTextSizeForETranslation(translationRequest, translObjs);
        } else {
            this.fillTranslationObjects(translObjs, translationRequest);
        }
        return translObjs;
    }

    private void fillTranslationObjects(List<TranslationObj> translationObjects, TranslationRequest translationRequest) {
        String source = translationRequest.getSource();
        String target = translationRequest.getTarget();
        for (String inputText : translationRequest.getText()) {
            TranslationObj newTranslObj = this.buildTranslationObject(source, target, inputText);
            translationObjects.add(newTranslObj);
        }
    }

    private TranslationObj buildTranslationObject(String source, String target, String inputText) {
        TranslationObj newTranslObj = new TranslationObj();
        newTranslObj.setSourceLang(source);
        newTranslObj.setTargetLang(target);
        newTranslObj.setText(inputText);
        newTranslObj.setTranslated(false);
        return newTranslObj;
    }

    private void limitTextSizeForETranslation(TranslationRequest translationRequest, List<TranslationObj> translationObjects) {
        StringBuilder translJointString = new StringBuilder(100);
        for (String inputText : translationRequest.getText()) {
            TranslationObj newTranslObj;
            if (!translJointString.isEmpty() && !this.exceedesSnippetLimit(translJointString, "\n[notranslate]deenPVsaOg[/notranslate]\n")) {
                translJointString.append("\n[notranslate]deenPVsaOg[/notranslate]\n");
            } else if (this.exceedesSnippetLimit(translJointString, "\n[notranslate]deenPVsaOg[/notranslate]\n")) break;
            if (!this.exceedesSnippetLimit(translJointString, inputText)) {
                translJointString.append(inputText);
                newTranslObj = this.buildTranslationObject(translationRequest.getSource(), translationRequest.getTarget(), inputText);
                translationObjects.add(newTranslObj);
                continue;
            }
            int charsAvailableForSnippet = 4990 - translJointString.length();
            int lastCharIndex = Math.min(charsAvailableForSnippet, inputText.length());
            String truncatedInput = inputText.substring(0, lastCharIndex);
            translJointString.append(truncatedInput);
            newTranslObj = this.buildTranslationObject(translationRequest.getSource(), translationRequest.getTarget(), truncatedInput);
            translationObjects.add(newTranslObj);
            break;
        }
    }

    private boolean exceedesSnippetLimit(StringBuilder translJointString, String textToAppend) {
        return translJointString.length() + textToAppend.length() >= 4990;
    }

    private boolean shouldTruncateText(TranslationRequest translationRequest) {
        return this.translationConfig.isEtranslationTruncate() && "ETRANSLATION".equals(translationRequest.getService());
    }

    private TranslationService selectTranslationService(TranslationRequest translationRequest, LanguagePair languagePair) throws ParamValidationException {
        TranslationService translationService;
        String serviceId = translationRequest.getService();
        if (serviceId != null) {
            return this.getTranslationService(serviceId, languagePair);
        }
        if (languagePair.getSrcLang() != null && (translationService = this.selectFromLanguageMappings(languagePair)) != null) {
            return translationService;
        }
        String defaultServiceId = this.translationServiceProvider.getTranslationServicesConfig().getTranslationConfig().getDefaultServiceId();
        return this.getTranslationService(defaultServiceId, languagePair);
    }

    private TranslationService selectFromLanguageMappings(LanguagePair languagePair) {
        String key = LanguagePair.generateKey((String)languagePair.getSrcLang(), (String)languagePair.getTargetLang());
        return this.translationServiceProvider.getLangMappings4TranslateServices().getOrDefault(key, null);
    }

    private TranslationService getTranslationService(String serviceId, LanguagePair languagePair) throws ParamValidationException {
        return this.getTranslationService(serviceId, languagePair, false);
    }

    private TranslationService getTranslationService(String serviceId, LanguagePair languagePair, boolean fallback) throws ParamValidationException {
        String param;
        TranslationService result = (TranslationService)this.translationServiceProvider.getTranslationServices().get(serviceId);
        String string = param = fallback ? "fallback" : "service";
        if (result == null) {
            throw new ParamValidationException("Requested service id is invalid" + serviceId, "error.invalid_param_value", "error.invalid_param_value", new String[]{param, serviceId + " (available services: " + String.join((CharSequence)", ", this.translationServiceProvider.getTranslationServices().keySet()) + ")"});
        }
        if (!result.isSupported(languagePair.getSrcLang(), languagePair.getTargetLang())) {
            throw new ParamValidationException("Language pair not supported:" + String.valueOf(languagePair), "error.invalid_param_value", "error.invalid_param_value", new String[]{LanguagePair.generateKey((String)"source", (String)"target"), languagePair.toString()});
        }
        return result;
    }

    public boolean isTranslationSupported(LanguagePair languagePair) {
        List langPairCfgList = this.translationServiceProvider.getTranslationServicesConfig().getTranslationConfig().getSupported();
        if (languagePair.getSrcLang() == null) {
            return this.isTargetInList(languagePair.getTargetLang(), langPairCfgList);
        }
        return this.isLangPairInList(languagePair, langPairCfgList);
    }

    private boolean isLangPairInList(LanguagePair languagePair, List<TranslationLangPairCfg> langPairCfgList) {
        for (TranslationLangPairCfg langPairCfg : langPairCfgList) {
            if (!langPairCfg.getSrcLang().contains(languagePair.getSrcLang()) || !langPairCfg.getTargetLang().contains(languagePair.getTargetLang())) continue;
            return true;
        }
        return false;
    }

    private boolean isTargetInList(String targetLang, List<TranslationLangPairCfg> langPairCfgList) {
        for (TranslationLangPairCfg translationLangPairCfg : langPairCfgList) {
            if (!translationLangPairCfg.getTargetLang().contains(targetLang)) continue;
            return true;
        }
        return false;
    }

    @PreDestroy
    public void close() {
        for (TranslationService service : this.translationServiceProvider.getTranslationServices().values()) {
            service.close();
        }
    }

    public RedisCacheService getRedisCacheService() {
        return this.redisCacheService;
    }

    @Autowired(required=false)
    public void setRedisCacheService(RedisCacheService redisCacheService) {
        this.redisCacheService = redisCacheService;
    }
}

