/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.translation.web.service;

import eu.europeana.api.translation.definitions.model.TranslationObj;
import eu.europeana.api.translation.service.TranslationService;
import eu.europeana.api.translation.service.exception.TranslationException;
import java.util.List;
import java.util.regex.Pattern;

public class TranslationPreProcessor
implements TranslationService {
    Pattern translationEligibleValuesPattern;

    public TranslationPreProcessor(Pattern translationEligibleValuesPattern) {
        this.translationEligibleValuesPattern = translationEligibleValuesPattern;
    }

    public String getServiceId() {
        return "TEXT_PROCESSOR";
    }

    public void setServiceId(String serviceId) {
    }

    public boolean isSupported(String srcLang, String trgLang) {
        return true;
    }

    public void translate(List<TranslationObj> translationStrings) throws TranslationException {
        for (TranslationObj obj : translationStrings) {
            if (this.translationEligibleValuesPattern.matcher(obj.getText()).find()) continue;
            obj.setTranslated(true);
        }
    }

    public void close() {
    }

    public String getExternalServiceEndPoint() {
        return null;
    }
}

